#include "ancheck.h"
#include "linkopt.h"
#include "olink.h"
#include <ctype.h>
#include <assert.h>
#include <string.h>

AnchorChecker::AnchorChecker(CLinkOptions &opt):
    ShortHeads(opt.Get_TStringCol(o_checked_scheme)),
    LongHeads(opt.Get_TStringCol(o_start_url)),
    Tails(opt.Get_TStringCol(o_checked_ext))
{
}

bool AnchorChecker::IsInteresting(const char *uri,
    HTMethod &method) const
{
    if (!HasOneOf(uri, ShortHeads))
	// unsupported scheme (i. e. mailto)
	return false;

    if (!HasOneOf(uri, LongHeads))
    {   // external link
	method = METHOD_HEAD;
        return true;
    }

    const char *p = strstr(uri, "://");
    if (!p)
	throw InvalidUriException(uri);
    const char *q = strchr(p + 3, '/');
    if (!q)
	throw InvalidUriException(uri);
    const char *r = strrchr(q + 1, '.');

    method = (!r || IsTail(r)) ? METHOD_GET : METHOD_HEAD;
    return true;
}

bool AnchorChecker::IsTail(const char *p) const
{
    for (vector<string>::const_iterator i = Tails.begin();
	i != Tails.end();
	++i)
    {   if (!strcasecmp(p, i->c_str()))
	    return true;
    }
    return false;
}

bool AnchorChecker::HasOneOf(const char *uri,
    const vector<string> &heads)
{
    for (vector<string>::const_iterator i = heads.begin();
	i != heads.end();
	++i)
    {   if (HasHead(uri, i->c_str()))
	    return true;
    }
    return false;
}

bool AnchorChecker::HasHead(const char *uri, const char *head)
{
    assert(uri != 0 && head != 0);

    int l = strlen(head);
    if (strlen(uri) < l)
	return false;

    for (int i = 0; i < l; ++i)
    {   if (tolower(uri[i]) != tolower(head[i]))
	    return false;
    }

    return true;
}
