/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* web.cpp */

// Adapted from _UNIX_Network_Programming, 2nd Edition
// by W. Richard Stevens
#include <qapp.h>
#include "web.h"

/* Write "n" bytes to a descriptor. */

ssize_t writen(int fd, const void *vptr, size_t n)
{
	size_t		nleft;
	ssize_t		nwritten;
	const char	*ptr;

	ptr = vptr;
	nleft = n;
	while (nleft > 0) {
		if ( (nwritten = write(fd, ptr, nleft)) <= 0) {
			if (errno == EINTR)
				nwritten = 0;		/* and call write() again */
			else
				return(-1);			/* error */
		}

		nleft -= nwritten;
		ptr   += nwritten;
	}
	return(n);
}
/* end writen */

void Writen(int fd, void *ptr, size_t nbytes)
{
	if (writen(fd, ptr, nbytes) != nbytes)
	   warning("written error");
}


///////////////////////////////////////////

int tcp_connect(const char* host, const char* serv)
{
   int sockfd = -1;
   int len;
   struct sockaddr_in address;
   struct hostent* 	  hostinfo;
   struct servent*    servinfo;   
         
   hostinfo = gethostbyname(host);
   if( !hostinfo )
   {
      warning( "ERROR: can't get host" );
   }
   else
   {
      servinfo = getservbyname("http", "tcp");
      sockfd = socket(AF_INET, SOCK_STREAM, 0);
	 	   
	   address.sin_family = AF_INET;
	   address.sin_port = servinfo->s_port;
	   address.sin_addr = *(struct in_addr *)*hostinfo->h_addr_list;
	   len = sizeof( address );
	   
	   if( -1 ==  connect( sockfd, (struct sockaddr *)&address, len) )
	   {
	      warning( "connect failed" );
	      close(sockfd);
	      sockfd = -1;
	   }
	}
	
	return sockfd;
}

/*
int tcp_connect(const char *host, const char *serv)
{
   int				sockfd;
   int		    n;
	struct addrinfo	 hints;
	struct addrinfo* res;
	struct addrinfo* ressave;

	bzero(&hints, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	if ( (n = getaddrinfo(host, serv, &hints, &res)) != 0)
   {
	   warning("ERROR getaddrinfo");
	   sockfd = -1;
   }
   else
   {
	   ressave = res;

	   do
	   {
		   sockfd = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
		   if (sockfd < 0)
			   continue;	// ignore this one 

		   if (connect(sockfd, res->ai_addr, res->ai_addrlen) == 0)
			   break;		// success 

		   close(sockfd);	// ignore this one 
	   }
	   while ( (res = res->ai_next) != NULL);

	   if (res == NULL)	// errno set from final connect() 
	   { 
        sockfd = -1; // connect must have failed
      }         
	   freeaddrinfo(ressave);
	}

	return(sockfd);
}
*/
/* end tcp_connect */



