/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* utils.cpp */

#include "utils.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
   
 
QDateTime* GetDateTimeFromString( QString str )
{
	int year;
	int month = 0;
	int day;
	int hour;
	int min;
	int day_len;
	
	//str is of format "mon may 11 04:11:15 1998" or "mon may 9 04:11:15 1998"
	
	// get the month and convert it to it's integer equiv
	QString strMonth = str.mid( 4, 3 );

   int i;
	for( i =0; strcmp( strMonth, months[i] ); i++)
		 
	month = i + 2;
	
	if( str.length() == 24 )
	{
	   day_len = 2;
	}
	else
	{ 
	   day_len = 1;
	}
	
	QString strDay = str.mid( 8, day_len );

  	day = atoi( strDay );
	
	QString strHour = str.mid( 9 + day_len, 2 );
	hour = atoi( strHour );
	
	QString strMin = str.mid( 12 + day_len, 2 );
	min = atoi( strMin );
	
	QString strYear = str.right( 4 );
	year = atoi( strYear );
		
	QDate* pDate = new QDate( year, month, day );
	QTime* pTime = new QTime( hour, min );
	QDateTime* pDateTime = new QDateTime( *pDate, *pTime );  
	
	return pDateTime;
}

QString StripTime( QDateTime dt )
{
   QString full_time = dt.toString();
   int first_colon = full_time.find( ':', 0 );
     
   return full_time.left( first_colon + 3 );
}

char* TrimString( char* s )
{
   int i;
   for ( i= strlen(s) - 1; s[i] == ' '; i-- )
   {
      s[i]= '\0';
   }
   
   return s;
}   
   
long CountCharsOutsideOfTags( const char* body_buff, int& tag_count )
{
   // tag_count is the number of "<" tags on our "stack"
   long count = 0;
   char* pTemp = (char*) body_buff;
   
   while( *pTemp != '\0' )
   {
      // if we are not on a tag or inside any tags, increment our counter
      if( *pTemp == '<' )
      {
		   tag_count++;
		}
		else if( *pTemp == '>' )
		{   
		   tag_count--;
      }
      else if ( tag_count == 0 )
      {
	      if( *pTemp != '\n' && *pTemp != '\r' && *pTemp != '\t'
	           && *pTemp != '\v' && *pTemp != '\f' && *pTemp != ' ' )
	      {
     	      count++;
         }
	   }
	       
      *pTemp++;  
   }
   
   return count;
}

bool FirstInstance()
{
   bool first_instance = true;
   flock lock;
   int fd = 0;
   QString lock_file = kapp->localkdedir() + "/share/apps/kwebwatch/lock_file";
   fd = open( lock_file, O_WRONLY | O_CREAT, 0777  );
    
   lock.l_type = F_WRLCK;
   lock.l_whence = SEEK_SET;    
   lock.l_start = 0;
   lock.l_len = 0;													
									  
   if ( -1 == fcntl( fd, F_SETLK, &lock ) )
   {
      fcntl( fd, F_GETLK, &lock );
      if ( lock.l_type != F_UNLCK ) // lock already exists
      { 
	 first_instance = false;
	 printf( "kwebwatch: already running - pid %ld\n", (long)(lock.l_pid) );
      }
   }    	
   
   return first_instance;
}





