/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* urllist.cpp */
#include <qmsgbox.h>
#include "urllist.h"

UrlNode::UrlNode( UrlItem* pUI = 0, UrlNode* pNext = 0 )
{
	pUrl = pUI;//->Copy(); // deep copy of our URLITEM object
	pNextNode = pNext;
}

UrlNode::~UrlNode()
{ 
	delete pUrl;
	delete pNextNode;
}

// This will make a deep copy of all the nodes in the list
UrlNode* UrlNode::Copy()
{
	if ( pNextNode )  // recursively call Copy() till the list is empty
		return new UrlNode( pUrl, pNextNode->Copy() );  
	
	return new UrlNode( pUrl, 0 );
}	




UrlList::UrlList()
{
	pListHead = 0;
}

UrlList::~UrlList()
{
	
}

// Place an item at the front of our (unsorted) list
void UrlList::Add( UrlItem* pItem )
{
	pListHead = new UrlNode( pItem, pListHead );
}

void UrlList::Remove( UrlItem* pUI )	
{
	UrlNode* pCurrent = pListHead;//->Copy();
	UrlNode* pPrevious = NULL;
	
	// walk through the list until we find a match
	while( pCurrent && pCurrent->pUrl != pUI ) 
	{
		pPrevious = pCurrent;
		pCurrent = pCurrent->pNextNode;
	}	
	
	if( pCurrent )
	{	
		// first handle case of deleting head node 
		if( pCurrent == pListHead )
			pListHead = pCurrent->pNextNode;
		else
			pPrevious->pNextNode = pCurrent->pNextNode;

		pCurrent->pNextNode = 0;
		delete pCurrent;
	}
	else
		warning("no match found in the ULRL list");
}	

	 
int UrlList::Count()
{
   int counter = 0;
   UrlNode* pCurrent = pListHead;
   
   while( pCurrent )
   {  
      pCurrent = pCurrent->pNextNode;
      counter++;
   } 
      
   return counter;
}

UrlItem* UrlList::GetAt( int target )
{
   int counter = 0;
   UrlNode* pCurrent = pListHead;
   
   while( counter < target && pCurrent->pNextNode )
   {   
      pCurrent = pCurrent->pNextNode;
      counter++;
   }
         
   return pCurrent->pUrl;
}
		 
			 	 
UrlItem* UrlList::Find( const char* Alias )
{
	UrlItem* pRtn = NULL;
	bool bMatch = FALSE;
	
	UrlNode* pCurrent = pListHead;
	
	if ( pListHead )
	{		
	   while( !bMatch ) 
	   {
	      if ( strcmp( pCurrent->pUrl->GetAlias(), Alias ) == 0 )
	      {
		      bMatch = TRUE;
	      }  
		   else if( pCurrent->pNextNode )
		   {
		      pCurrent = pCurrent->pNextNode;
		   }
		   else
	      {
		      break; // end of list
		   }
	   }
	}
	
	if( bMatch )
	{		
	   pRtn = pCurrent->pUrl;
	}
		
	return pRtn;  // returns NULL if no match found
	
}		 
