/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* propdialog.h */

#ifndef PROPDIALOG_H
#define PROPDIALOG_H

#include <qapp.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <qpopmenu.h>
#include <qlistbox.h>
#include <qmenubar.h>
#include <qpixmap.h>
#include <qkeycode.h>
#include <qpaintd.h>
#include <qpainter.h>
#include <qlined.h>
#include <qlabel.h>
#include <qcombo.h>
#include <qradiobt.h>
#include <qdialog.h>
#include <qmsgbox.h>
#include <qdatetm.h>
#include <qchkbox.h>

#include "urllist.h"
#include "mainwidget.h"
#include "utils.h"


class PropDialog : public QDialog
{
	Q_OBJECT

public:
	PropDialog( QWidget* parent =0,
					class UrlItem* pUrlItem = 0 , const char* name = 0 );

public slots:
	void ExitUrl();
   void UseThisBrowser();
   void UseDefaultBrowser();
	void ShowFileDialog();
	
private:
		
	QVBoxLayout* m_pBoxLayout;
	QPushButton* m_pOKButton;
	QPushButton* m_pCancelButton;
	QPushButton* m_pCheckNowButton;
	QListBox*	   m_pListBox;
	UrlItem* 	   m_pUrlItem;
	QLineEdit*   m_pUrlEdit;
	QLabel*  	   m_pLastTimeValue;
   QLabel*      m_pNextTimeValue;	
   QLabel*		    m_pLastResultValue;
	QComboBox*   m_pHowOftenCombo;
	QLabel*		    m_pUrlAliasDisplay;
	QLabel*		    m_pUrlLabel;
	QLabel*		    m_pUrlAliasLabel;
	QLabel*		    m_pLastTimeLabel;
	QLabel*		    m_pLastResult;
	QLabel*		    m_pNextTimeLabel;
	QLabel*      m_pHowOftenLabel; 
	
	QRadioButton* m_pRadioDefault;
   QRadioButton* m_pRadioMyBrowser;
   QLineEdit*    m_pBrowserPathEdit;
   QPushButton*  m_pBrowseButton;  
   QCheckBox*    m_pCheckSkipTags;
	
};


#endif /* PROPDIALOG_H */
 
