/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* options.h */

#ifndef OPTIONS_H
#define OPTIONS_H

#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlabel.h>
#include <qframe.h>
#include <qchkbox.h>
#include <qlayout.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kconfig.h>
#include <kapp.h>

#include "urlitem.h"

#define MAX_BROWSER_PATH 300

class OptionsDialog : public QDialog
{
	Q_OBJECT

public:
	OptionsDialog( QWidget* parent =0, const char* name = 0 );
	~OptionsDialog();
	
public slots:
   void SaveAndExit();
   void ShowFileDialog();
   void ToggleUseProxy();
   
signals:
   void NewDefaultBrowser( const char* );


private:
   QLineEdit* m_pBrowserPathEdit;
   QLineEdit* m_pProxyEdit;
   QLineEdit* m_pProxyPortEdit;
   QCheckBox* m_pCheckAtStartCheckBox;
   QCheckBox* m_pDockCheckBox;
   QCheckBox* m_pUseProxyCheckBox;
     
};

#endif //OPTIONS_H

