/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

//options.cpp

#include "options.h"
#include "options.moc"

OptionsDialog::OptionsDialog( QWidget* parent, const char* name )
			: QDialog( parent, name, TRUE /*modal*/ )
{
  	KConfig* pConfig = kapp->getConfig();
   pConfig->setGroup( "General Options" );

   QString path = pConfig->readEntry( "Default Browser", "" );
   bool dock_flag = pConfig->readBoolEntry( "StartDocked", 0 );
   bool proxy_flag = pConfig->readBoolEntry( "UseProxy", 0 );
   bool check_at_start_flag = pConfig->readBoolEntry( "CheckUrlsAtStart", 0 );

   m_pCheckAtStartCheckBox = new QCheckBox( i18n( "Check all URLS at startup" ), this );
   m_pCheckAtStartCheckBox->setMinimumSize( m_pCheckAtStartCheckBox->sizeHint() );
   m_pCheckAtStartCheckBox->setChecked( check_at_start_flag );

   m_pDockCheckBox = new QCheckBox( i18n( "Dock to panel at startup" ), this );
   m_pDockCheckBox->setMinimumSize( m_pDockCheckBox->sizeHint() );  
   m_pDockCheckBox->setChecked( dock_flag );
	     	     
   QLabel* pBrowserLabel = new QLabel( i18n( "Default browser: " ), this, "" );
   pBrowserLabel->setMinimumSize( pBrowserLabel->sizeHint() );
 
	m_pBrowserPathEdit = new QLineEdit( this, "" );
	m_pBrowserPathEdit->setMinimumSize(	m_pBrowserPathEdit->sizeHint() );
	m_pBrowserPathEdit->setMaxLength( BROWSER_PATH_LEN - 1 );
	m_pBrowserPathEdit->setText( path );
	m_pBrowserPathEdit->setFocus();
	        
   QPushButton* pBrowseButton = new QPushButton( i18n( "&Select..." ), this, "" );
   QSize button_size = pBrowseButton->sizeHint();
   pBrowseButton->setMinimumSize( button_size );

   m_pUseProxyCheckBox = new QCheckBox( i18n( "Use Proxy" ), this );
   m_pUseProxyCheckBox->setChecked( proxy_flag );
   m_pUseProxyCheckBox->setMinimumSize( m_pUseProxyCheckBox->sizeHint() );
   
   QLabel* pProxyLabel = new QLabel( i18n( "Proxy Address: "), this, "" );
   pProxyLabel->setMinimumSize( pProxyLabel->sizeHint() );

   m_pProxyEdit = new QLineEdit( this, "" );
   m_pProxyEdit->setMinimumSize( m_pProxyEdit->sizeHint() );
   m_pProxyEdit->setMaxLength( PROXY_ADDR_LEN - 1 );

   QLabel* pProxyPortLabel = new QLabel( i18n( "Port: "), this, "" );
   pProxyPortLabel->setMinimumSize( pProxyPortLabel->sizeHint() );

   m_pProxyPortEdit = new QLineEdit( this, "" );
   m_pProxyPortEdit->setMaxLength( 6 );
   m_pProxyPortEdit->setMinimumSize( m_pProxyEdit->sizeHint() / 2 );

   if( proxy_flag )
   {
       pConfig->setGroup( "Proxy Support" );
       m_pProxyEdit->setText( pConfig->readEntry( "Proxy Address", ""  ));
       m_pProxyPortEdit->setText( pConfig->readEntry( "Proxy Port", "" ));
   }
   else
   {
      m_pProxyEdit->setEnabled( FALSE );
      m_pProxyPortEdit->setEnabled( FALSE );
   }   
		   	   
	QFrame* pSep = new QFrame( this );
   pSep->setFrameStyle( 0x0004 | 0x0030 );
   pSep->setLineWidth( 2 );
	pSep->setFixedHeight( 2 );
	       
	QPushButton* pOkButton = new QPushButton( i18n( "&OK" ), this, "" );
	pOkButton->setMinimumSize( button_size );
	
	QPushButton* pCancelButton = new QPushButton( i18n( "&Cancel" ), this, "" );
	pCancelButton->setMinimumSize( button_size );

	// main layout for dialog
   QBoxLayout* pTopLayout = new QVBoxLayout( this, 10 );		
				
   // Layouts
   QBoxLayout* pDockCheckLayout = new QHBoxLayout();
   QBoxLayout* pBrowserLayout = new QHBoxLayout();
   QBoxLayout* pSelectButtonLayout = new QHBoxLayout();
   QBoxLayout* pProxyCheckLayout = new QHBoxLayout();
   QBoxLayout* pProxyEditLayout = new QHBoxLayout();
   QBoxLayout* pOkCancelLayout = new QHBoxLayout();
   
   //pTopLayout->addLayout( pCheckAtStartLayout );
   pTopLayout->addLayout( pDockCheckLayout );
   pTopLayout->addStretch(10);
   pTopLayout->addLayout( pBrowserLayout );
   pTopLayout->addStretch(1);
   pTopLayout->addLayout( pSelectButtonLayout );
   pTopLayout->addStretch(1);
   pTopLayout->addLayout( pProxyCheckLayout );
   pTopLayout->addStretch(1);
   pTopLayout->addLayout( pProxyEditLayout );
   pTopLayout->addWidget( pSep );
   pTopLayout->addLayout( pOkCancelLayout );
    
   //pCheckAtStartLayout->addWidget( m_pCheckAtStartCheckBox );
   pDockCheckLayout->addWidget( m_pCheckAtStartCheckBox );
   pDockCheckLayout->addWidget( m_pDockCheckBox );

   pBrowserLayout->addWidget( pBrowserLabel );
   pBrowserLayout->addWidget( m_pBrowserPathEdit, 1 );
 
   pSelectButtonLayout->addStretch( 1 ); //right justify
   pSelectButtonLayout->addWidget( pBrowseButton );
   
   pProxyCheckLayout->addWidget( m_pUseProxyCheckBox );
      
   pProxyEditLayout->addWidget( pProxyLabel );
   pProxyEditLayout->addWidget( m_pProxyEdit, 1 );
   pProxyEditLayout->addWidget( pProxyPortLabel );
   pProxyEditLayout->addWidget( m_pProxyPortEdit );
   
   pOkCancelLayout->addStretch( 1 );
   pOkCancelLayout->addWidget( pOkButton );
   pOkCancelLayout->addWidget( pCancelButton );
   
   pTopLayout->activate();
			
	this->setCaption( i18n( "KWebWatch: Options" ) );
	 
	connect( pBrowseButton, SIGNAL(clicked()), SLOT( ShowFileDialog() )); 
   connect( pOkButton, SIGNAL(clicked()), SLOT( SaveAndExit() ));
	connect( pCancelButton, SIGNAL(clicked()), SLOT(reject()) );	
	connect( m_pUseProxyCheckBox, SIGNAL(clicked()), SLOT(ToggleUseProxy()) );
}

OptionsDialog::~OptionsDialog()
{

}


void OptionsDialog::SaveAndExit()
{
   QString path = m_pBrowserPathEdit->text();

   if( !path.isEmpty() )
   {
		 KConfig* pConfig = kapp->getConfig();
						
		 QString oldgroup = pConfig->group();									      							      
		 pConfig->setGroup( "General Options" );
		
		 pConfig->writeEntry( "Default Browser", path );
	    pConfig->writeEntry( "StartDocked", m_pDockCheckBox->isChecked() );
		 pConfig->writeEntry( "UseProxy", m_pUseProxyCheckBox->isChecked() );
       pConfig->writeEntry( "CheckUrlsAtStart", m_pCheckAtStartCheckBox->isChecked() );

		 if ( m_pUseProxyCheckBox->isChecked() )
		 {
		    pConfig->setGroup( "Proxy Support" );
		    pConfig->writeEntry( "Proxy Address", m_pProxyEdit->text() );
		    pConfig->writeEntry( "Proxy Port", m_pProxyPortEdit->text() );
		 }		 

		 // change the default browser for all UrlItems in memory
       emit NewDefaultBrowser( path );
      
		 this->hide();
   }
   else
   {
      //tell the user to enter a path
      KMsgBox* pMsgBox = new KMsgBox( this,
				                          i18n( "Path is empty" ),
								              i18n( "Please enter a path" ),
										        1, //INFORMATION
											     i18n("&OK") );
											     
		 pMsgBox->show();
   
   }
}

void OptionsDialog::ShowFileDialog()
{
   m_pBrowserPathEdit->setText(KFileDialog::getOpenFileName() );
}

void OptionsDialog::ToggleUseProxy()
{
   if( m_pUseProxyCheckBox->isChecked() )
   {
      m_pProxyEdit->setEnabled( TRUE );
      m_pProxyPortEdit->setEnabled( TRUE );
   }
   else
   {
      m_pProxyEdit->setEnabled( FALSE );
      m_pProxyPortEdit->setEnabled( FALSE );
   }
}
