/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* newdialog.h */

#ifndef NEWDIALOG_H
#define NEWDIALOG_H

#include "urlitem.h"
#include "propdialog.h"

class NewDialog : public QDialog
{
	Q_OBJECT

public:
	NewDialog( QWidget* parent =0, class UrlList* pUrlList = 0,
					const char* name = 0 );

public slots:

	void ExitUrl();
   void UseThisBrowser();
   void UseDefaultBrowser();
	void ShowFileDialog();

		
signals:
	void NewListBoxItem( const char* );
	void NewUrl( class UrlItem* );
  	void PaintNewLBItem( UrlItem*, bool );
  	
private:
		
	QVBoxLayout* m_pBoxLayout;
	QListBox*	 m_pListBox;
	UrlList* 	 m_pUrlList;
	
	QPushButton* m_pOKButton;
	QPushButton* m_pCancelButton;
		
	QLineEdit*   m_pUrlEdit;
	QLineEdit*   m_pUrlAliasEdit;
   QComboBox*   m_pHowOftenCombo;
	
	QLabel*		 m_pUrlLabel;
	QLabel*		 m_pUrlAliasLabel;
	QLabel*   m_pHowOftenLabel;
	
	QRadioButton* m_pRadioDefault;
   QRadioButton* m_pRadioMyBrowser;
   QLineEdit*    m_pBrowserPathEdit;
   QPushButton*  m_pBrowseButton;
   
};


#endif // NEWDIALOG_H
