/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


/* newdialog.cpp */

#include "newdialog.h"
#include "newdialog.moc"

NewDialog::NewDialog( QWidget* parent, class UrlList* pUrlList,
							 const char* name )
			: QDialog( parent, name, 1 )
{
	m_pUrlList = pUrlList; 
	
	m_pUrlLabel = new QLabel( i18n( "URL Address:" ), this, "");
	m_pUrlLabel->setMinimumSize( m_pUrlLabel->sizeHint() );

	m_pUrlEdit = new QLineEdit( this, "" );
	m_pUrlEdit->setMinimumSize( m_pUrlEdit->sizeHint() );
	m_pUrlEdit->setMaxLength( URL_LEN - 1 );
	m_pUrlEdit->setFocus();
	
	m_pUrlAliasLabel = new QLabel( i18n( "URL Name:" ), this, "");
	m_pUrlAliasLabel->setMinimumSize( m_pUrlAliasLabel->sizeHint() );
	
	m_pUrlAliasEdit = new QLineEdit( this, "" );
	m_pUrlAliasEdit->setMinimumSize( m_pUrlAliasEdit->sizeHint() );
	m_pUrlAliasEdit->setMaxLength( ALIAS_LEN - 1 );
	
	
	m_pHowOftenLabel = new QLabel( i18n( "Check every: " ), this, "");
	m_pHowOftenLabel->setMinimumSize( m_pHowOftenLabel->sizeHint() );

	m_pHowOftenCombo = new QComboBox( FALSE, this, "" );
	m_pHowOftenCombo->insertStrList( (const char**)timechoices );
	m_pHowOftenCombo->setMinimumSize( m_pHowOftenCombo->sizeHint() );

   // first separator
	QFrame* pSep = new QFrame( this );
   pSep->setFrameStyle( 0x0004 | 0x0030 );
   pSep->setLineWidth( 2 );
   pSep->setFixedHeight( 2 );
   
   // browser choice radio buttons 
   m_pRadioMyBrowser = new QRadioButton( i18n( "Use this browser: "), this, "");
   m_pBrowserPathEdit = new QLineEdit( this, "" );
   m_pBrowserPathEdit->setMaxLength( BROWSER_PATH_LEN - 1 );
   m_pRadioDefault = new QRadioButton( i18n( "Use default browser" ), this, "" );
 
   m_pBrowseButton = new QPushButton( i18n( "&Select..." ), this, "" );
   QSize button_size = m_pBrowseButton->sizeHint();
   m_pBrowseButton->setMinimumSize( button_size );
   
   m_pRadioDefault->setMinimumSize( m_pRadioDefault->sizeHint() );
   m_pRadioMyBrowser->setMinimumSize( m_pRadioMyBrowser->sizeHint() );
   m_pBrowserPathEdit->setMinimumSize( m_pBrowserPathEdit->sizeHint() );

    
	 // separator 2
   QFrame* pSep2 = new QFrame( this );
   pSep2->setFrameStyle( 0x0004 | 0x0030 );
   pSep2->setLineWidth( 2 );
   pSep2->setFixedHeight( 2 );
	  	
	m_pOKButton = new QPushButton( i18n( "&OK" ), this, "" );							
	m_pCancelButton = new QPushButton( i18n( "&Cancel" ), this, "" );
	m_pCancelButton->setMinimumSize( button_size );
	m_pOKButton->setMinimumSize( button_size );
  
   // check the default browser button
   m_pRadioDefault->setChecked( TRUE );
	    
   // disable the browser edit box and the "select" button
   m_pBrowserPathEdit->setEnabled( FALSE );
   m_pBrowseButton->setEnabled( FALSE );
  
	// Layouts
	QBoxLayout* pTopLayout = new QVBoxLayout( this, 10 );
	QBoxLayout* pAddressLayout= new QHBoxLayout();
	QBoxLayout* pAliasLayout = new QHBoxLayout();
	QBoxLayout* pHowOftenLayout = new QHBoxLayout();
	QBoxLayout* pOkCancelLayout = new QHBoxLayout();
   QBoxLayout* pUseThisLayout = new QHBoxLayout();
   QBoxLayout* pUseDefaultLayout = new QHBoxLayout();

	pTopLayout->addLayout( pAddressLayout );
	pTopLayout->addStretch(1);
	pTopLayout->addLayout( pAliasLayout );
	pTopLayout->addStretch( 1 );
	pTopLayout->addLayout( pHowOftenLayout );
	pTopLayout->addWidget( pSep, 1 );
	pTopLayout->addLayout( pUseThisLayout );
   pTopLayout->addLayout( pUseDefaultLayout );
   pTopLayout->addWidget( pSep2, 1 );
	pTopLayout->addLayout( pOkCancelLayout );
	
	pAddressLayout->addWidget( m_pUrlLabel );
	pAddressLayout->addWidget( m_pUrlEdit, 1 );
	
	pAliasLayout->addWidget( m_pUrlAliasLabel );
	pAliasLayout->addWidget( m_pUrlAliasEdit, 1 );
	
	pHowOftenLayout->addWidget( m_pHowOftenLabel );
	pHowOftenLayout->addWidget( m_pHowOftenCombo );
	
   pUseThisLayout->addWidget( m_pRadioMyBrowser );
   pUseThisLayout->addWidget( m_pBrowserPathEdit, 1 );
   
   pUseDefaultLayout->addWidget( m_pRadioDefault );
   pUseDefaultLayout->addStretch( 1 ); //spacing
   pUseDefaultLayout->addWidget( m_pBrowseButton );

   pOkCancelLayout->addStretch( 1 );
	pOkCancelLayout->addWidget( m_pOKButton );
   pOkCancelLayout->addWidget( m_pCancelButton );

	pTopLayout->activate();
	
	this->setCaption( i18n( "KWebWatch: New Url" ) );
	
	connect( m_pOKButton, SIGNAL(clicked()), SLOT( ExitUrl() ));
	connect( m_pCancelButton, SIGNAL(clicked()), SLOT(reject()) );	
	connect( m_pRadioDefault, SIGNAL(clicked()), SLOT( UseDefaultBrowser() ));
   connect( m_pRadioMyBrowser, SIGNAL(clicked()), SLOT( UseThisBrowser() ));
	connect( m_pBrowseButton, SIGNAL(clicked()), SLOT( ShowFileDialog() ));
}


void NewDialog::ExitUrl()
{
	char browser_path[ BROWSER_PATH_LEN ];
	bool use_default_browser;

	// Don't allow exit if Url name is a duplicate
	UrlItem* pMatch = NULL;
	pMatch = m_pUrlList->Find( m_pUrlAliasEdit->text() );
	if ( pMatch )
	{
	   QMessageBox::about( this,
			                 i18n( "Duplicate Name" ),
								  i18n( "Please enter a unique name for this URL" ) );
								
	}
	else
	{
	   // Calculate NextTime from HowOften and the current time
	   QDateTime dt = QDateTime::currentDateTime();
	
	   // find the timechoices[] index of our HowOften string	
	   int i;
	   for( i=0; strcmp (timechoices[i], m_pHowOftenCombo->currentText()); i++);
	
	   // Convert HowOften into seconds
	   int secs = time_in_seconds[i];
	
	   // Add the HowOften value to the current time to get our NextTime value
	   dt = dt.addSecs( secs );
	
	   QString strNextTime = dt.toString();
	
	   // convert the next time to a QDateTime object
	   QDateTime* pDateTime = GetDateTimeFromString( strNextTime );
	
	   // set our browser path value
	   if( m_pRadioDefault->isChecked() )
	   {
	      // get our default browser path from the config file
  	      KConfig* pConfig = kapp->getConfig();
	
	      pConfig->setGroup( "General Options" );
         QString path = pConfig->readEntry( "Default Browser", "" );
     
         use_default_browser = TRUE;
         strcpy( browser_path, path );
      }
      else
      {
         use_default_browser = FALSE;
         strcpy( browser_path, m_pBrowserPathEdit->text() );
      }

	   bool skip_tags =  FALSE;

	   UrlItem* pUrl = new UrlItem( m_pUrlAliasEdit->text(),
											  TrimString( (char*)m_pUrlEdit->text() ),
										     m_pHowOftenCombo->currentText(),
										     use_default_browser,
										     browser_path,
										     0, // best_guess is FALSE initially
										     skip_tags,
										     "",
										     pDateTime,
										     0,
										     INITIAL_LAST_MODIFIED );

	   // Add our new urlitem to the dbm	
	   pUrl->WriteToDisk();

	   // Add our new urlitem to our list in memory
	   m_pUrlList->Add( pUrl );
		
	   // Add the description of our item to the list box
	   emit NewListBoxItem( (const char*) m_pUrlAliasEdit->text()  );
	
	   emit PaintNewLBItem( pUrl, FALSE );
						
	   // Close the dialog
	   this->hide();
	}
}

void NewDialog::UseThisBrowser()
{
   m_pRadioDefault->setChecked( FALSE );
   m_pBrowserPathEdit->setEnabled( TRUE );
   m_pBrowseButton->setEnabled( TRUE );
}

void NewDialog::UseDefaultBrowser()
{
   m_pRadioMyBrowser->setChecked( FALSE );
   m_pBrowserPathEdit->setEnabled( FALSE );
   m_pBrowseButton->setEnabled( FALSE );
}

void NewDialog::ShowFileDialog()
{
   m_pBrowserPathEdit->setText(KFileDialog::getOpenFileName() );
}
