/*

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/   

/* mainwidget.h */

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <sys/stat.h>

#include <qpopmenu.h>
#include <qlistbox.h>
#include <qmenubar.h>
#include <qpixmap.h>
#include <qkeycode.h>
#include <qpaintd.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qmsgbox.h>
#include <qpoint.h>

#include <ktopwidget.h>

#include "newdialog.h"
#include "propdialog.h"
#include "mainlistbox.h"
#include "utils.h"
#include "options.h"
#include "dockwidget.h"

#include "web.h"

#define APP_CAPTION "KWebWatch"

#define NOT_YET_CHECKED_COLOR  lightGray
#define NO_CHANGE_COLOR        black
#define UPDATE_FOUND_COLOR     blue
#define CHECK_NOT_NEEDED_COLOR  blue
#define CONNECT_FAILED_COLOR   darkRed
#define NO_DATE_PROVIDED_COLOR darkRed 
#define UPDATE_READ_COLOR      black
#define URL_SYNTAX_ERROR_COLOR darkRed
#define URL_NOT_FOUND_COLOR    darkRed
#define URL_MOVED_COLOR        darkRed
#define UNKNOWN_ERROR_COLOR    darkRed


class MainWidget : public KTopLevelWidget
{
   Q_OBJECT
	
public:
	UrlList* 		        m_pUrlList;		
	~MainWidget();
	MainWidget( QWidget* parent = 0, const char* name = 0 );

	MainListBox* 			GetListBox(){ return m_pListBox; };
	class UrlList*  GetUrlList(){ return m_pUrlList; };
	bool					 StartingDocked(){ return m_StartDocked; };
		
	
private:
	
	void LoadUrls();
	
	QVBoxLayout*	m_pLayout;
	QMenuBar* 		 m_pMenuBar;
	QPopupMenu* 	m_pPopUpMenu;
	QPopupMenu* 	m_pMenuView;
	QPopupMenu* 	m_pMenuUrl;
	QPopupMenu* 	m_pMenuHelp;

   QLabel*		    m_pStatusText;
	MainListBox* m_pListBox;	
	
	class PropDialog* 	m_pPropDialog;
	class NewDialog*	  m_pNewDialog;
	class DockWidget*  m_pDockWidget;
	
	bool 				 m_bCheckingUrls;
	bool         m_StartDocked;
	 
public slots:
	void AddUrl();
	void CheckAllUrls();
	void CheckUrlsIfTime();	
	void AddItemToListBox( const char* );
	void Delete();
	void ShowProperties();
	void ShowPopupMenu( QPoint point );
	void CheckSelectedNow();
	bool CheckNow( class UrlItem* pUrlItem );
   void LaunchSelected();
   void UpdateListBox( UrlItem* pItem, bool checked_this_session );
   void ShowOptions();
   void ChangeDefaultBrowserPaths( const char* path );
   void MarkSelectedRead();
   void DockToPanel();
   void HelpAbout();
   void HelpContents();
   
public:
   UrlItem* GetSelectedUrlItem();
   void LaunchBrowser( UrlItem* pItem );

};

#endif /* MAINWIDGET_H */
