/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


/*mainlistbox.h*/

#ifndef MAINLISTBOX_H
#define MAINLISTBOX_H

#include <qapp.h>
#include <qlistbox.h>
#include <qpainter.h>

class MainListBox : public QListBox
{
	Q_OBJECT

public:

	MainListBox( QWidget* parent=0, const char* name = 0, WFlags f = 0);
	void mousePressEvent( QMouseEvent* pMouse );
   void colorItem( QColor, int row );
   void paintCell( QPainter* p, int row, int col );
signals:
	void RightMouse( QPoint );	
 
};


class MyListBoxItem : public QListBoxItem
{    
public: 
   MyListBoxItem( const char *s, QColor c, const QPixmap p )
   : QListBoxItem(), pm(p){ setText( s ); m_color = c;}
   
protected:
   virtual void paint( QPainter * );
   virtual int height( const QListBox * ) const;
   virtual int width( const QListBox * ) const;
   virtual const QPixmap *pixmap() { return &pm; }
   
private:
   QPixmap pm;
   QColor m_color;
   
};

        
#endif //MAINLISTBOX_H
