/*

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/   

//docking.cpp

#include "dockwidget.h"
#include "dockwidget.moc"

extern QString g_icon_dir;
extern QString g_pics_dir;

DockWidget::DockWidget( MainWidget* pMW, const char* name )
	:QWidget( 0, name, 0 )
{
	m_pMWidget = pMW;
	m_docked = FALSE;
	m_pixmap.load( g_pics_dir + "/kww_eye.xpm" );
  	m_pixmap_new.load( g_pics_dir + "/kww_eye_new.xpm" );
   m_menu_item_added = FALSE;
	
	m_pRightMenu = new QPopupMenu();
	m_pLeftMenu = new QPopupMenu();
	
	m_pRightMenu->insertItem(klocale->translate("Restore"), this, 
								  SLOT( ToggleView()));
	m_pRightMenu->insertSeparator();
	m_pRightMenu->insertItem(klocale->translate("Exit"), this,
								   SLOT( Bye()));

   QPixmap menu_pixmap;
   menu_pixmap.load( g_pics_dir + "/kww_new.xpm" );					
																											
	// walk through our list of urls and add the ones with
	// results of UPDATE_FOUND or CHECK_NOT_NEEDED to our menu
   int i;
   UrlItem* pUrlItem;
   for (i = 0; i < pMW->m_pUrlList->Count(); i++ )
   {
	   pUrlItem = pMW->m_pUrlList->GetAt( i );
		if( pUrlItem->GetResult() == UPDATE_FOUND ||
			 pUrlItem->GetResult() == CHECK_NOT_NEEDED )
		{
			QString menu_text = klocale->translate( pUrlItem->GetAlias() );
			m_pLeftMenu->insertItem( menu_pixmap, menu_text, this,
											SLOT( Launch( ) ));
		}
	}
	
	connect( m_pLeftMenu, SIGNAL( highlighted( int ) ), SLOT( SaveSelectedMenu( int )) );
   connect( this, SIGNAL( CloseApp() ), kapp->getKApplication(), SLOT( quit() ));
}

DockWidget::~DockWidget()
{
}

void DockWidget::Dock()
{
	if( !m_docked )
	{
		KWM::setDockWindow(this->winId());
		
		this->setFixedSize( 24, 24 );
		
		this->show();
		m_docked = TRUE;
	}
}

void DockWidget::UnDock()
{
	this->destroy(TRUE, TRUE);
	this->create( 0, TRUE, FALSE );
	
	m_docked = FALSE;
}

void DockWidget::UpdateMenu( UrlItem* pUrlItem, bool add_to_menu )
{	
	QString menu_text = i18n( pUrlItem->GetAlias() );
	
	if( add_to_menu )
	{
	   QPixmap* menu_icon = new QPixmap( g_pics_dir + "/kww_new.xpm" );
	   m_pLeftMenu->insertItem( *menu_icon, menu_text, this, SLOT( Launch()) );
		
		m_menu_item_added = TRUE;  
		PaintIcon();
	}
	else // remove the item from the menu											
	{
		QString test;
		int index;
		int count = m_pLeftMenu->count();
		bool match = FALSE;
	
		// look for a match to get the index we need to remove
		for( index=0; index<=count && !match; index++ )
		{
		   test = m_pLeftMenu->text( m_pLeftMenu->idAt(index) );
		   if ( menu_text == test )
			{
			   match = TRUE;
			   m_pLeftMenu->removeItemAt(index);
			}
		}
	}
}

void DockWidget::Launch( )
{
   UrlItem* pUrlItem = NULL;
   
   // get the text of the selected menu
   QString menu_text = m_pLeftMenu->text( m_selected_menu );
   
   // look through the urllist until we find a match
   int i;
   for (i = 0; i < m_pMWidget->m_pUrlList->Count(); i++ )
   {
	   pUrlItem = m_pMWidget->m_pUrlList->GetAt( i );
      if( strcmp( menu_text, pUrlItem->GetAlias() ) == 0) 
	      break;
   }
   
   m_pMWidget->LaunchBrowser( pUrlItem );
	
}

void DockWidget::ToggleView()
{
   if( m_docked )
   {
      m_pMWidget->show();
      m_docked = FALSE;
   }
   else
   {
      m_pMWidget->hide();
      m_docked = TRUE;
   }
}

void DockWidget::Bye()
{
   UnDock();
   emit CloseApp();
}

void DockWidget::PaintIcon()
{
   if( m_menu_item_added )
      bitBlt( this, 0, 0, &m_pixmap_new );
   else
	   bitBlt( this, 0, 0, &m_pixmap );
}

void DockWidget::paintEvent( QPaintEvent* e )
{
	(void) e;
	PaintIcon();
}

void DockWidget::mousePressEvent( QMouseEvent *pMouse )
{
	QPoint* pPoint = new QPoint( pMouse->x(), pMouse->y() );
	QPoint GlobalPt = mapToGlobal( *pPoint );

	if( pMouse->button() == LeftButton )
	{
		m_pLeftMenu->popup(GlobalPt, m_pLeftMenu->count() -1);
		m_menu_item_added = FALSE;
		PaintIcon();
	}
	else if( pMouse->button() == RightButton  )
	{
		if( !m_docked )
		   m_pRightMenu->changeItem( i18n("Dock"), m_pRightMenu->idAt(0) );
		else
		   m_pRightMenu->changeItem( i18n("Restore"), m_pRightMenu->idAt(0) );
		
		m_pRightMenu->popup(GlobalPt, m_pRightMenu->count() -1);
	}
	else if( pMouse->button() == MidButton )
	{
	   ToggleView();
	}
}

void DockWidget::SaveSelectedMenu( int index )
{
   m_selected_menu = index;
}
	
