/*
	Misc functions for got_it.
*/

#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include "common.h"

char resp_line[RESP_LINE_SIZE];

#define START_DIR_SIZE	255
char *start_dir=NULL;

int check_line(char *netbuf) {
  char delims[] = "\n\r";
  char temp_buf[NETBUF_SIZE];
  int tok_len;
  char *token;
  
  strcpy(temp_buf,netbuf);
  token=strtok(temp_buf,delims);
  while (token) {
    tok_len=strlen(token);
    if (tok_len>=3) {
      if ((tok_len==3) || (token[3]==' ')) {
        strcpy(resp_line,token);
        return(1);
      }
    }
    token=strtok(NULL,delims);
  }
  return(0);
}

void waiting(int interval) {
  struct timeval tv;
  tv.tv_sec=interval;
  tv.tv_usec=0;
  select(0,NULL,NULL,NULL,&tv);
}

int parse_url(char *url, char *protocol, char *host, int *port, char *file) {
  char *p,*p1;
  *port=0;
  p=strstr(url,"://");
  if (!p) return(0);
  strncpy(protocol,url,p-url); protocol[p-url]='\0';
  p+=3;
  p1=strstr(p,"/");
  if (!p1) return(0);
  strncpy(host,p,p1-p); host[p1-p]='\0';
  if (p1[0]=='\0') return(0);
  strcpy(file,p1);
  p=strstr(host,":");
  if (!p) {
    if (strcmp(protocol,"http")==0) *port=80;
    if (strcmp(protocol,"ftp")==0) *port=21;
    return(1);
  }
  if (p[1]=='\0') return(0);
  *port=atoi(p+1);
  p[0]='\0';
  return(1);
}

void change_to_dir(char *dirname) {
  if ((!dirname) || (strlen(dirname)==0)) return;
  start_dir=malloc(START_DIR_SIZE);
  if (!getcwd(start_dir,START_DIR_SIZE)) 
    perror("Can't get current directory");
  if (chdir(dirname)==-1) {
    perror("Can't change directory");
    free(start_dir);
    start_dir=NULL;
  }
}

void restore_start_dir() {
  if (start_dir!=NULL) {
    if (chdir(start_dir)==-1) perror("Can't restore start directory");
    free(start_dir);
    start_dir=NULL;
  }
}
