/*
*/

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <stdlib.h>

#include "logger.h"

char *logfilename = NULL;
FILE *logfile = NULL;

void setlogfilename(char *filename) {
  if (logfilename!=NULL) {
    free(logfilename);
    logfilename=NULL;
  }
  if ((!filename) || (strlen(filename)==0)) return;
  logfilename=strdup(filename);
}

void openlogfile(char *filename) {
  if (!logfilename) {
    if ((!filename) || (strlen(filename)==0)) return;
    setlogfilename(filename);
  }
  if (strcmp(logfilename,"-")==0) {
    logfile=stdout;
  } else {
    if (!(logfile=fopen(logfilename,"a"))) {
      perror("can't open log file");
      free(logfilename);
      logfilename=NULL;
    }
  }
}

void closelogfile() {
  if (logfile) {
    fclose(logfile);
    logfile=NULL;
  }
  if (logfilename) {
    free(logfilename);
    logfilename=NULL;
  }
}

void logit(int c, char *msg) {
  char lc_signs[] = "iW!E<>";
  time_t curtime;
  struct tm *ptime;
  char lc_sign;
  
  if (!logfile) return;
  if ((c<0) || (c>5))
    lc_sign='?';
  else lc_sign=lc_signs[c];
  curtime=time(NULL);
  ptime=localtime(&curtime);
  fprintf(logfile,"%.2d.%.2d.%d %.2d:%.2d:%.2d %c %s\n",
          ptime->tm_mday,ptime->tm_mon+1,ptime->tm_year,ptime->tm_hour,
          ptime->tm_min,ptime->tm_sec,lc_sign,msg);
  fflush(logfile);
}

void logerror(int c, char *msg) {
  char buf[512];
  sprintf(buf,"Error: '%s' in %s",strerror(errno),msg);
  logit(c,buf);
}

void logherror(int c, char *msg) {
  char buf[512],t[255];
  switch (h_errno) {
    case NETDB_INTERNAL:
      strcpy(t,"internal error");
      break;
    case HOST_NOT_FOUND:
      strcpy(t,"host not found");
      break;
    case TRY_AGAIN:
      strcpy(t,"temporary error (try again)");
      break;
    case NO_RECOVERY:
      strcpy(t,"unexpected server failure");
      break;
    case NO_DATA:
      strcpy(t,"name is valid, but doesn't have an IP address");
      break;
    default:
      strcpy(t,"unknown error");
  }
  sprintf(buf,"Error: '%s' in %s",t,msg);
  logit(c,buf);
}
