/*
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>

#include "asockets.h"
#include "logger.h"
#include "advconnect.h"

void close_socket(int *s, int how) {
  if ((!s) || (*s<0) || (*s==STDOUT_FILENO)) return;
  if (how>=0) shutdown(*s,how);
  close(*s);
  *s=-1;
}

int write_socket_strs(int s, char *str1, char *str2, int log_it, int log_error, char *suffix) {
  int bufsize=0;
  char *buf=NULL;
  int r;
  
  if ((s<0) || (!str1)) return(-1);
  bufsize=strlen(str1);
  if (str2!=NULL) bufsize+=strlen(str2);
  if (suffix!=NULL) bufsize+=strlen(suffix);
  bufsize++;
  if (!(buf=malloc(bufsize))) {
    logit(LC_FATAL,"asockets:write_socket_str: can't allocate memory");
    return(-1);
  }
  strcpy(buf,str1);
  if (str2!=NULL) strcat(buf,str2);
  if (log_it>=0) logit(log_it,buf);
  if (suffix!=NULL) strcat(buf,suffix);
  r=write(s,buf,strlen(buf));
  free(buf);
  if ((r<0) && (log_error>=0)) logerror(log_error,"asockets:write_socket_strs");
  return(r);
}

int write_socket_str(int s, char *str, int log_it, int log_error, char *suffix) {
  return(write_socket_strs(s,str,NULL,log_it,log_error,suffix));
}

int write_socket_str_int(int s, char *str, int i, int log_it, int log_error, char *suffix) {
  char buf[40];
  sprintf(buf,"%s%i",str,i);
  return(write_socket_str(s,buf,log_it,log_error,suffix));
}

int create_n_connect(int *s, char *host_name, int port) {
  struct sockaddr_in sin;
  struct hostent *phe;
  int r=-1;

  bzero(&sin,sizeof(sin));
  sin.sin_family = AF_INET;
  
  sin.sin_port=htons(port);
  if (!(phe=gethostbyname(host_name))) {
    logherror(LC_NONFATAL,"asockets:create_n_connect:gethostbyname");
    return(-1);
  }
  memcpy((char *)&sin.sin_addr,phe->h_addr,phe->h_length);
  if ((*s=socket(PF_INET,SOCK_STREAM,IPPROTO_TCP))==-1) {
    logerror(LC_FATAL,"asockets:create_n_connect:socket");
    return(-1);
  }
  if ((r=advconnect(*s,(struct sockaddr *)&sin,sizeof(sin)))!=1)
     close_socket(s,2);
  return(r);
}
