/*
*/

#include <string.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "common.h"
#include "ahttplib.h"
#include "logger.h"
#include "base64.h"
#include "advconnect.h"
#include "asockets.h"

int ahttp_verbose=0;
int shData=-1;
int localfile=-1;
int ahttp_timeout=TIMEOUT;
char localfilename[255];
char http_outfilename[512],http_auth[512],http_uagent[512];

int http_createsocket(char *hostname, int port) {
  return(create_n_connect(&shData,hostname,port));
}

void http_closesocket() {
  close_socket(&shData,2);
}

void http_closefile() {
  if ((localfile>=0) && (localfile!=STDOUT_FILENO)) close(localfile);
  localfile=-1;
}

int http_createfile(char *filename, int file_exist) {
  int flags=O_WRONLY | O_CREAT | O_TRUNC;
  mode_t mode=S_IRUSR | S_IWUSR;
  
  if (strcmp(http_outfilename,"-")==0) {
    localfile=STDOUT_FILENO;
    return(1);
  }
  
  if (file_exist) flags=O_WRONLY | O_APPEND;
  if ((localfile=open(localfilename,flags,mode))==-1) {
    logerror(LC_FATAL,"ahttplib:http_createfile:open");
    return(0);
  }
  return(1);
}

int http_makelocalfilename(char *filename) {
  if (http_outfilename[0]=='\0') {
    if (filename[strlen(filename)-1]=='/') {
      strcpy(localfilename,"index.html");
    } else {
      strcpy(localfilename,rindex(filename,'/')+1);
    }
  } else strcpy(localfilename,http_outfilename);
  return(1);
}

int http_fileexist(char *filename) {
  struct stat file_stat;
  if (strcmp(http_outfilename,"-")==0) return(0);
  if (stat(filename,&file_stat)==0) return(file_stat.st_size);
  return(0);
}

int http_sendrequest(char *filename, int file_exist_size) {
  char buf[1024],authbuf[512],tmpbuf[512],uagentbuf[512];
  
  authbuf[0]='\0';
  if (http_auth[0]!='\0') {
    uuencode(http_auth,strlen(http_auth),tmpbuf);
    sprintf(authbuf,"Authorization: Basic %s\n",tmpbuf);
  }
  uagentbuf[0]='\0';
  if (http_uagent[0]!='\0') sprintf(uagentbuf,"User-Agent: %s\n",http_uagent);
  if (!file_exist_size) {
    sprintf(buf,"GET %s HTTP/1.0\n%sAccept: */*\n%s\r\n",filename,uagentbuf,authbuf);
  } else {
    sprintf(buf,"GET %s HTTP/1.0\n%sAccept: */*\nRange: bytes=%i-\n%s\r\n",
            filename,uagentbuf,file_exist_size,authbuf);
  }
  logit(LC_SEND,"GET");
  if (write(shData,buf,strlen(buf))==-1) {
    logerror(LC_NONFATAL,"ahttplib:http_sendrequest:write");
    return(0);
  }
  return(1);
}

int http_readtobuf(char *buf, int bufsize) {
  fd_set rfds;
  struct timeval tv;
  int retval;
  
  FD_ZERO(&rfds);
  FD_SET(shData,&rfds);
  tv.tv_sec=ahttp_timeout;
  tv.tv_usec=0;
  if ((retval=select(shData+1,&rfds,NULL,NULL,&tv))==0) {
    logit(LC_NONFATAL,"Timeout");
    return(-1);
  }
  if (retval==-1) {
    logerror(LC_NONFATAL,"ahttplib:http_readtobuf:select");
    return(-1);
  }
  if ((retval=read(shData,buf,bufsize-1))==-1) {
    logerror(LC_NONFATAL,"ahttplib:http_readtobuf:read");
    return(-1);
  }
  return(retval);
}

int http_getfile(char *filename) {
  char buf[4096],tok_buf[4096],*p,*d,*token;
  char delims[] = "\r\n";
  char servcode[4];
  int file_exist_size,r;
  int c_length=-1;
  int r_start=-1;
  int r_end=-1;
  int r_total=-1;
  int inbuf=0;
  int infile=0;
  int hdr_term_size=0;
  
  if (!http_makelocalfilename(filename)) return(HTTP_FATAL);
  file_exist_size=http_fileexist(localfilename);
  if (!http_sendrequest(filename,file_exist_size)) return(HTTP_NONFATAL);
  p=buf;
  memset(&buf,0,sizeof(buf));
  while ((p-buf)<sizeof(buf)) {
    if ((r=http_readtobuf(p,sizeof(buf)))<=0) return(HTTP_NONFATAL);
    inbuf+=r;
    
    if ((d=strstr(buf,"\r\n\r\n"))!=NULL)
      hdr_term_size=4;
      else if ((d=strstr(buf,"\n\n"))!=NULL) hdr_term_size=2;
    
    if (hdr_term_size) {
      d[0]='\0';
      strcpy(tok_buf,buf);
      token=strtok(tok_buf,delims);
      if (!token) {
        logit(LC_FATAL,"First line of http header is empty");
        return(HTTP_FATAL);
      }
      logit(LC_REC,token);
      strncpy(servcode,token+9,3);
      servcode[3]='\0';
      token=strtok(NULL,delims);
      while (token) {
        logit(LC_REC,token);
        if (strncasecmp(token,"Content-Length: ",16)==0) {
          c_length=atoi(token+16);
        }
        if (strncasecmp(token,"Content-Range: bytes ",21)==0) {
          sscanf(token+21,"%i-%i/%i",&r_start,&r_end,&r_total);
        }
        token=strtok(NULL,delims);
      }
      if ( (strcmp(servcode,"200")!=0) && (strcmp(servcode,"206")!=0) )
        return(HTTP_FATAL);
      if (c_length<=0) {
        logit(LC_WARNING,"Content-Length not found in http header");
      }
      if (file_exist_size) {
        if ((r_start<0) || (r_end<0) || (r_total<0)) {
          logit(LC_WARNING,"Hmm, seems this server doesn't support Range");
          file_exist_size=0;
        } else {
          if (((r_end-r_start)+1)!=c_length) {
            logit(LC_WARNING,"Content-Range not equal Content-Length! (f*cked Microsoft)");
            file_exist_size=0;
          }
        }
      }
      if (!http_createfile(filename,file_exist_size)) return(HTTP_FATAL);
      p=d+hdr_term_size;
      write(localfile,p,inbuf-(p-buf));
      infile+=inbuf-(p-buf);
      break;
    }
    p+=r;
  }
  if ((p-buf)==sizeof(buf)) {
    logit(LC_FATAL,"Header too large (or my buffer too small ;)");
    logit(LC_FATAL,"Buffer contents follow:");
    logit(LC_FATAL,buf);
    return(HTTP_FATAL);
  }
  while ((r=http_readtobuf(buf,sizeof(buf)))>0) {
    write(localfile,buf,r);
    infile+=r;
  }
  if (r==-1) return(HTTP_NONFATAL);
  if (r==0) {
    if ((strcmp(http_outfilename,"-")!=0) &&
       (((r_total>=0) && (http_fileexist(localfilename)<r_total)) ||
       ((c_length>0) && (http_fileexist(localfilename)<c_length)))) {
      logit(LC_NONFATAL,"Something wrong, file is smaller than must be");
      return(HTTP_NONFATAL);
    }
  }
  return(HTTP_OK);
}

int http_gotit(char *hostname, int port, char *filename) {
  int r;
  if ((r=http_createsocket(hostname,port))==HTTP_OK) r=http_getfile(filename);
  http_closesocket();
  http_closefile();
  return(r);
}
