/*
	Advanced FTP library by Andy Roger.
	v0.03, 1997,98 (C)
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <string.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>

#include "aftplib.h"
#include "common.h"
#include "misc.h"
#include "logger.h"
#include "advconnect.h"
#include "asockets.h"

int sControl=-1;		/* control socket */
int sData=-1;			/* data prorotype socket */
int sDataCh=-1;			/* data channel socket */
char netbuf[NETBUF_SIZE];	/* network buffer */
int local_file=-1;		/* fd of local file */
int must_say_quit=0;		/* we must say 'quit' */
int ftp_timeout=TIMEOUT;	/* timeout for all operations */
int get_dir=0;			/* get directory list instead a file */
int file_size=-1;		/* remote file size in bytes */
char ftp_outfilename[512],ftp_auth[512],ftp_user[255],ftp_pass[255];
int nlst_file_fd=-1;
char nlst_file_name[128];
FILE *nlst_file=NULL;
char fname[512];
int ok_get_next;

int read_line(char *expect) {
  char *buf_ptr;
  int b,retval,avail;
  fd_set rfds;
  struct timeval tv;
  
  bzero(&netbuf,sizeof(netbuf));
  FD_ZERO(&rfds);
  FD_SET(sControl,&rfds);
  buf_ptr=netbuf;
  avail=sizeof(netbuf)-1;
  while (avail>=1) {
    tv.tv_sec=ftp_timeout;
    tv.tv_usec=0;
    retval=select(sControl+1,&rfds,NULL,NULL,&tv);
    if (retval==-1) {
      logerror(LC_NONFATAL,"aftplib:read_line:select");
      return(0);
    }
    if (retval==0) {
      logit(LC_WARNING,"Timeout");
      return(0);
    }
    if ((b=read(sControl,buf_ptr,avail))<1) {
      logerror(LC_NONFATAL,"aftplib:read_line:read");
      return(0);
    }
    if ((buf_ptr[b-1]=='\n') && (check_line(netbuf))) {
      logit(LC_REC,resp_line);
      if ((strlen(expect)>0) && (strncmp(resp_line,expect,strlen(expect))!=0))
         return(0);
      return(1);
    }  
    buf_ptr+=b;
    avail-=b;
  }
  return(0);
}

void ftp_close() {
  if (must_say_quit) {
    if (write_socket_str(sControl,"quit",LC_SEND,-1,"\n")) read_line("");
    must_say_quit=0;
  }  
  close_socket(&sData,2);
  close_socket(&sDataCh,2);
  close_socket(&sControl,2);
  close_socket(&local_file,-1);
}

int ftp_open(char *host_name, int port) {
  char *p;
  int r;

  if ((r=create_n_connect(&sControl,host_name,port))!=FTP_OK) return(r);

  if (!read_line("")) return(FTP_NONFATAL);
  if (resp_line[0]!='2') return(FTP_FATAL);
  must_say_quit=1;
  
  strcpy(ftp_user,"ftp");
  if (strstr(resp_line,"wu-")) {
    strcpy(ftp_pass,"-got_it@");
    logit(LC_INFO,"wu-ftpd detected. try be smart");
    } else strcpy(ftp_pass,"got_it@");
  if ((p=index(ftp_auth,':'))) {
    strncpy(ftp_user,ftp_auth,p-ftp_auth);
    strcpy(ftp_pass,p+1);
  }
  
  return(FTP_OK);
}

int ftp_login() {
  if (sControl<=0) {
    logerror(LC_FATAL,"aftplib:ftp_login:control socket closed");
    return(FTP_FATAL);
  }
  
  if (write_socket_strs(sControl,"user ",ftp_user,
      LC_SEND,LC_NONFATAL,"\n")<=0)
     return(FTP_NONFATAL);
  if (!read_line("")) return(FTP_NONFATAL);
  if (resp_line[0]=='2') return(FTP_OK);
  if (resp_line[0]!='3') return(FTP_FATAL);
  
  if (write_socket_strs(sControl,"pass ",ftp_pass,
      LC_SEND,LC_NONFATAL,"\n")<=0)
     return(FTP_NONFATAL);
  if (!read_line("")) return(FTP_NONFATAL);
  if (resp_line[0]!='2') return(FTP_FATAL);
  
  return(FTP_OK);
}

int ftp_port() {
  union {
    struct sockaddr sa;
    struct sockaddr_in in;
  } sin;
  int l;
  char buf[64];
  
  l=sizeof(sin);
  if (getsockname(sControl,&sin.sa,&l)<0) {
    logerror(LC_FATAL,"aftplib:ftp_port:getsockname");
    return(FTP_FATAL);
  }  
  if ((sData=socket(PF_INET,SOCK_STREAM,IPPROTO_TCP))==-1) {
    logerror(LC_FATAL,"aftplib:ftp_open:socket");
    return(FTP_FATAL);
  }
  sin.in.sin_port=0;
  if (bind(sData,&sin.sa,sizeof(sin))==-1) {
    logerror(LC_FATAL,"aftplib:ftp_open:bind");
    return(FTP_FATAL);
  }
  if (listen(sData,1)<0) {
    logerror(LC_FATAL,"aftplib:ftp_open:listen");
    return(FTP_FATAL);
  }
  if (getsockname(sData,&sin.sa,&l)<0) {
    logerror(LC_FATAL,"aftplib:ftp_open:getsockname");
    return(FTP_FATAL);
  }
  sprintf(buf,"port %d,%d,%d,%d,%d,%d",
              (unsigned char)sin.sa.sa_data[2],
              (unsigned char)sin.sa.sa_data[3],
              (unsigned char)sin.sa.sa_data[4],
              (unsigned char)sin.sa.sa_data[5],
              (unsigned char)sin.sa.sa_data[0],
              (unsigned char)sin.sa.sa_data[1]);
              
  if (write_socket_str(sControl,buf,LC_SEND,LC_NONFATAL,"\n")<=0)
     return(FTP_NONFATAL);            
  if (!read_line("2")) return(FTP_NONFATAL);
  return(FTP_OK);
}

int ftp_getdata() {
  fd_set rfds;
  struct timeval tv;
  struct sockaddr addr;
  int l;
  char buf[2048];
  
  FD_ZERO(&rfds);
  FD_SET(sControl,&rfds);
  FD_SET(sData,&rfds);
  tv.tv_sec=ftp_timeout;
  tv.tv_usec=0;
  l=(sControl > sData) ? sControl : sData;
  if (select(l+1,&rfds,NULL,NULL,&tv)==0) {
    logerror(LC_NONFATAL,"aftplib:ftp_getdata:select");
    return(FTP_NONFATAL);
  }
  
  if (FD_ISSET(sControl,&rfds) && !FD_ISSET(sData,&rfds)) {
    logit(LC_NONFATAL,"Data arrived to sControl before sData");
    return(FTP_NONFATAL);
  }
  l=sizeof(addr);
  if ((sDataCh=accept(sData,&addr,&l))<=0) {
    logerror(LC_NONFATAL,"aftplib:ftp_getdata:accept");
    return(FTP_NONFATAL);
  }
  close(sData);
  sData=-1;
  
  FD_ZERO(&rfds);
  FD_SET(sDataCh,&rfds);
  while (1) {
    tv.tv_sec=ftp_timeout;
    tv.tv_usec=0;
    if (select(sDataCh+1,&rfds,NULL,NULL,&tv)<=0) return(0);
    l=read(sDataCh,buf,sizeof(buf));
    if (l>0) write(local_file,buf,l);
    if (l==0) break;
    if (l<0) {
      logerror(LC_NONFATAL,"aftplib:ftp_getdata:read from sDataCh");
      return(FTP_NONFATAL);
    }
  }
  return(FTP_OK);
}

int ftp_getsize(char *file_to_get) {
  char buf[80];
  char delims[]=" \t\n\r";
  char *p1,*p2;

  if (write_socket_strs(sControl,"size ",file_to_get,LC_SEND,
                        LC_NONFATAL,"\n")<=0)
     return(FTP_NONFATAL);
  if (!read_line("")) return(FTP_NONFATAL);
  if (resp_line[0]!='2') return(FTP_FATAL);
  p1=strtok(resp_line,delims);
  p2=strtok(NULL,delims);
  if ((!p1) || (!p2)) {
    logit(LC_FATAL,"unknown responce from server");
    return(FTP_FATAL);
  }
  if ((file_size=atoi(p2))<0) {
    logit(LC_FATAL,"file size can't be negative");
    return(FTP_FATAL);
  }
  sprintf(buf,"remote file size is %i",file_size);
  logit(LC_INFO,buf);
  
  return(FTP_OK);
}

int output_to_stdout() {
  if (strcmp(ftp_outfilename,"-")==0) {
    local_file=STDOUT_FILENO;
    return(1);
  }
  return(0);
}

int ftp_open_local_file(char *filename) {
  char *local_file_name,*s,buf[80];
  int l;
  int open_flags=O_WRONLY | O_CREAT | O_TRUNC;
  struct stat file_stat;
  int r;

  if (!(l=strlen(filename))) {
    logit(LC_FATAL,"Error in aftplib:ftp_open_local_file:invalid filename");
    return(FTP_FATAL);
  }
  
  if (get_dir) {
    logit(LC_INFO,"Get FTP directory listing");
    if (ftp_outfilename[0]=='\0')
      local_file_name="ftp_directory";
    else {
      if (output_to_stdout()) return(FTP_OK);
      local_file_name=(char *)&ftp_outfilename;
    }
    
    if (write_socket_str(sControl,"type a",LC_SEND,LC_NONFATAL,"\n")<=0)
       return(FTP_NONFATAL);
    if (!read_line("2")) return(FTP_NONFATAL);
    
  } else {
  
    if ((r=ftp_getsize(filename))!=FTP_OK) return(r);
    if (write_socket_str(sControl,"type i",LC_SEND,LC_NONFATAL,"\n")<=0)
      return(FTP_NONFATAL);
    if (!read_line("2")) return(FTP_NONFATAL);

    if (ftp_outfilename[0]=='\0') {
      local_file_name=filename;
      if ((s=rindex(filename,'/'))!=NULL) local_file_name=++s;
    } else {
      if (output_to_stdout()) return(FTP_OK);
      local_file_name=(char *)&ftp_outfilename;
    }
    if (stat(local_file_name,&file_stat)==0) {
      sprintf(buf,"Local file exist, size is %i",(int)file_stat.st_size);
      logit(LC_INFO,buf);
    
      if (write_socket_str_int(sControl,"rest ",(int)file_stat.st_size,
                               LC_SEND,LC_NONFATAL,"\n")<=0)
         return(FTP_NONFATAL);
      if (!read_line("")) return(FTP_NONFATAL);
      if (resp_line[0]=='3') open_flags=O_WRONLY | O_APPEND;
    }
  }
  
  if ((local_file=open(local_file_name,open_flags,
                       S_IRUSR | S_IWUSR))==-1) {
    logerror(LC_FATAL,"aftplib:ftp_open_local_file:open");
    return(FTP_FATAL);
  }
  return(FTP_OK);
}

int ftp_connect(char *hostname, int port) {
  int r;
  while (1) {
    r=ftp_open(hostname,port);
    if (r!=FTP_OK) break;
    r=ftp_login();
    break;
  }
  return(r);
}

int ftp_nlst(char *file_to_get) {
  int r;
  
  if (nlst_file_fd!=-1) return(FTP_OK);
  tmpnam(nlst_file_name);
  nlst_file_fd=open(nlst_file_name,O_CREAT | O_TRUNC | O_RDWR,
                    S_IRUSR | S_IWUSR);
  if (nlst_file_fd<=0) {
    logit(LC_FATAL,"Can't create temporary file for NLST");
    return(FTP_FATAL);
  }
  while (1) {
    r=ftp_port();
    if (r!=FTP_OK) break;
    r=FTP_NONFATAL;
    if (write_socket_strs(sControl,"nlst ",file_to_get,LC_SEND,
                          LC_NONFATAL,"\n")<=0) break;
    if (!read_line("")) break;
    if (resp_line[0]!='1') {
      r=FTP_FATAL;
      break;
    }
    local_file=nlst_file_fd;
    r=ftp_getdata();
    if (r!=FTP_OK) break;
    r=FTP_NONFATAL;
    if (!read_line("2")) break;
    r=FTP_OK;
    break;
  }
  close_socket(&sData,2);
  close(nlst_file_fd);
  if (r!=FTP_OK) {
    nlst_file_fd=-1;
    remove(nlst_file_name);
  }
  return(r);
}

int count_lines(FILE *f) {
  int c=0;
  fpos_t pos;
  
  char buf[512];
  if (!f) return(-1);
  pos=fgetpos(f,&pos);
  rewind(f);
  while (fgets(buf,sizeof(buf)-1,f)) c++;
  fsetpos(f,&pos);
  return(c);
}

int ftp_getfname() {
  int l;
  
  if (!nlst_file) {
    nlst_file=fopen(nlst_file_name,"r");
    if (!nlst_file) {
      logit(LC_FATAL,"Can't open NLST file for reading");
      return(0);
    }
    if ((count_lines(nlst_file)>1) && (strlen(ftp_outfilename)>0)) {
      logit(LC_INFO,"Not single file would be getted, ignore -o option.");
      ftp_outfilename[0]='\0';
    }
    ok_get_next=1;
  }
  if (!ok_get_next) return(1);
  ok_get_next=0;
  if (fgets(fname,sizeof(fname)-1,nlst_file)) {
    while (((l=strlen(fname))>0) && ((fname[l-1]=='\n') || (fname[l-1]=='\r')))
      fname[l-1]='\0';
    return(1);
  } else {
    ftp_remove_temp();
    return(0);
  }
}

void ftp_check_is_dir(char *filename) {
  int l;
  get_dir=0;
  if (!filename) return;
  l=strlen(filename);
  if ((l==0) || (filename[l-1]!='/')) return;
  get_dir=1;
}

int ftp_gotit(char *hostname, int port, char *file_to_get) {
  int r;
  
  ftp_check_is_dir(file_to_get);
  
  while (1) {
    r=ftp_connect(hostname,port);
    if (r!=FTP_OK) break;
    
    if (!get_dir) {
      r=ftp_nlst(file_to_get);
      if (r!=FTP_OK) break;
    }

    while (get_dir || ftp_getfname()) {    
      r=ftp_port();
      if (r!=FTP_OK) break;
      if (get_dir)
        r=ftp_open_local_file(file_to_get);
      else
        r=ftp_open_local_file(fname);
      if (r!=FTP_OK) break;
      r=FTP_NONFATAL;
      if (get_dir) {
        if (write_socket_strs(sControl,"list ",file_to_get,LC_SEND,
                                  LC_NONFATAL,"\n")<=0) break;
      } else {
          if (write_socket_strs(sControl,"retr ",fname,LC_SEND,
                                    LC_NONFATAL,"\n")<=0) break;
      }
      if (!read_line("1")) break;
      r=ftp_getdata();
      if (r!=FTP_OK) break;
      r=FTP_NONFATAL;
      if (!read_line("2")) break;
      ok_get_next=1;
      close_socket(&sData,2);
      r=FTP_OK;
      if (get_dir) break;
    }
    break;
  }
  ftp_close();
  return(r);
}

void ftp_remove_temp() {
  if (nlst_file!=NULL) {
    fclose(nlst_file);
    nlst_file=NULL;
    remove(nlst_file_name);
  }
}
