/* 
*/

#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <errno.h>

#include "advconnect.h"
#include "logger.h"
#include "aftplib.h"

void dummy_SIGCHLD_proc() {
}

void unmask_SIGCHLD() {
  struct sigaction sa;
  sigset_t nbs;
  
  sa.sa_handler=dummy_SIGCHLD_proc;
  sigfillset(&sa.sa_mask);
  sa.sa_flags=SA_RESETHAND;
  sigaction(SIGCHLD,&sa,NULL);
  
  sigemptyset(&nbs);
  sigaddset(&nbs,SIGCHLD);
  sigprocmask(SIG_UNBLOCK,&nbs,NULL);
}

void mask_SIGCHLD() {
  sigset_t bs;
  
  sigemptyset(&bs);
  sigaddset(&bs,SIGCHLD);
  sigprocmask(SIG_BLOCK,&bs,NULL);
}

int advconnect(int s, struct sockaddr *sa, int sa_size) {
  pid_t r;
  struct timeval tv;
  int child_status;

  unmask_SIGCHLD();
  switch (r=fork()) {
    case 0: /* we are child */
      if (connect(s,sa,sa_size)==-1) {
        logerror(LC_NONFATAL,"advconnect:connect");
        _exit(0);
      }
      logit(LC_INFO,"Connected");
      _exit(1);
      
    case -1: /* error */
      logerror(LC_FATAL,"advconnect:fork");
      return(FTP_FATAL);
      
    default: /* we are parent */
      tv.tv_sec=ftp_timeout;
      tv.tv_usec=0;
      switch(select(s+1,NULL,NULL,NULL,&tv)) {
        case 0:   /* timeout */
          logit(LC_WARNING,"Timeout");
          mask_SIGCHLD();
          kill(r,SIGTERM);  /* kill child */
          waitpid(r,NULL,0);  /* wait for child exit */
          return(FTP_NONFATAL);
        
        case -1:  /* error */        
          if (errno==EINTR) {  /* signal from child */
            waitpid(r,&child_status,0);  /* wait for child exit */
            if (!WIFEXITED(child_status)) {
              logit(LC_FATAL,"We are receive non-blocking signal, but child was not exit normally");
              kill(r,SIGTERM);
              waitpid(r,NULL,0);
              return(FTP_FATAL);
            }
            if (WEXITSTATUS(child_status)==0) return(FTP_NONFATAL);
            if (WEXITSTATUS(child_status)==1) break;
            logit(LC_FATAL,"Unknown child exit code");
            return(FTP_FATAL);
          } else {
            logerror(LC_FATAL,"advconnect:select");
            return(FTP_FATAL);
          }
      }
  }

  return(FTP_OK);
}
