/*
**  A quick and nasty FTP fetcher which takes a URL of the format
**  ftp://<site name>/<file name>
**  http://<site name>/<file name>
**
**  Uses the very useful ftplib.c, written by Thomas Pfau (pfau@cnj.digex.net)
**
**  Hacked together by Mike Bremford (mike@opac.bl.uk), 14-10-96
**  Improved considerably Jan 1997
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "ftplib.h"

#define VERSION	"1.0"
#define FTPHEADER "ftp://"
#define HTTPHEADER "http://"
#define HTTPLEN "Content-length:"

char *prog;
int debug=1;
void doHttp();
void doFtp();
void version();

int main(int argc, char *argv[])
{
    int i, start=1;

    prog=argv[0];
    if (argv[1] && argv[1][0]=='-') {
	for(i=1;i<strlen(argv[1]);i++) {
	    if (argv[1][i]=='d') debug++;
	    if (argv[1][i]=='q') debug--;
	    if (argv[1][i]=='v') version();
	}
	start++;
    }
    if (argc-start>2 || argc-start<1)
	merror(0);

    ftplib_debug=debug;
    if (debug>1) ftplib_debug--;

    if (strncasecmp(argv[start], FTPHEADER, strlen(FTPHEADER))==0)
       doFtp(&argv[start]);
    if (strncasecmp(argv[start], HTTPHEADER, strlen(HTTPHEADER))==0)
       doHttp(&argv[start]);
    merror(0);
}

void doHttp(char *argv[])
{
    int sock;
    struct sockaddr_in sin;
    struct hostent *phe;
    char *host, *path, *file, *c;
    char buf[1024];
    int i, ilen=0, tot;
    FILE *fp, *ofp;

    memset(&sin, 0, sizeof(sin));

    host=argv[0]+strlen(HTTPHEADER);

    path=strchr(host, '/');
    if (path==NULL)
        merror(1);
    *path++=0;
    file=strrchr(path, '/');
    if (file==NULL) {
        file=path;
    } else {
	file++;
    }

    if (argv[1])
        file=argv[1];

    if (!(ofp=fopen(file, "w"))) {
        perror("fopen");
	exit(-1);
    }
        
    if ((c=strchr(host, ':'))==NULL) {
	sin.sin_port = htons(80);
    } else {
        *c++=0;
	sin.sin_port = htons(atoi(c));
    }

    sin.sin_family = AF_INET;
    if (!(phe = gethostbyname(host))) {
        perror ("gethostbyname");
	exit(-1);
    }
    memcpy((char *)&sin.sin_addr, phe->h_addr, phe->h_length);
    sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sock == -1) {
        perror ("socket");
	exit(-1);
    }
    if (connect(sock, (struct sockaddr *)&sin, sizeof(sin)) == -1) {
        perror("connect");
	exit(-1);
    }
    sprintf (buf, "GET /%s HTTP/1.0\n\r\n", path);
    write(sock, buf, strlen(buf));
    i=read(sock, buf, sizeof(buf)-1);
    c=buf+sizeof(buf);
    if (i>0) {
        for (c=buf;c<buf+i-2;c++) {
	    if (memcmp(c, "\r\n\r\n", 4)==0) {
	        c+=2;
	        *c++=0;
	        *c++=0;
		if (debug>1)
		    write(STDOUT_FILENO, buf, c-buf);
		if (strstr(buf, HTTPLEN))
		    sscanf(strstr(buf, HTTPLEN)+strlen(HTTPLEN), " %d", &ilen);
		break;
	    } else
	    if (memcmp(c, "\n\n", 2)==0) {
	        c++;
	        *c++=0;
		if (debug>1)
		    write(STDOUT_FILENO, buf, c-buf);
		if (strstr(buf, HTTPLEN))
		    sscanf(strstr(buf, HTTPLEN)+strlen(HTTPLEN), " %d", &ilen);
		break;
	    }
	}
    }
    if (c-buf>i) {
        printf ("Error: Unable to find HTTP header");
	exit(-1);
    }

    setbuf(stdout, NULL);
    tot=i-(c-buf);
    if (debug) {
	printf ("Reading...     ");
	if (ilen)
	    printf ("%c%c%c%c%3d%%", 8,8,8,8, (tot*100)/ilen);
    }
   write(fileno(ofp), c, i-(c-buf));

    while((i=read(sock, buf, sizeof(buf)-1))>0) {
        write(fileno(ofp), buf, i);
	tot+=i;
	if (ilen && debug)
	    printf ("%c%c%c%c%3d%%", 8,8,8,8, (tot*100)/ilen);
    }
    if (debug)
        printf ("%c%c%c%cDone.\n", 8,8,8,8);
    exit(0);
}

void doFtp(char *argv[])
{
    char *path, *site, *file, *ofile;
    char passwd[100]="", x[50];

    ftpInit();

    if (getenv("USER"))
        strcpy(passwd, getenv("USER"));
    else if (getenv("LOGNAME"))
        strcpy(passwd, getenv("LOGNAME"));
    else
        strcpy(passwd, "unknown");
    strcat(passwd, "@");
    if (gethostname(x, sizeof(x)-1))
	strcat(passwd, "unknown.com");
    else
        strcat(passwd, x);

    site=argv[0]+strlen(FTPHEADER);

    path=strchr(site, '/');
    if (path==NULL)
        merror(1);
    *path++=0;

    file=strrchr(path, '/');
    if (file==NULL) {
        file=path;
	path=NULL;
    } else {
	*file++=0;
    }

    if (argv[1])
        ofile=argv[1];
    else
	ofile=file;

    if (debug>1) {
	printf ("Connecting to \"%s\" as anonymous, passwd \"%s\"\n", site, passwd);
	if (path) printf ("Changing directory to \"%s\"\n", path);
	printf ("Getting remote file \"%s\" local file \"%s\"\n", file, ofile);
    }

    if (!ftpOpen(site))
        merror(3);
    if (!ftpLogin("anonymous", passwd))
	merror(4);
    if (path && !ftpChdir(path))
        merror(5);
    setbuf(stdout, NULL);
    if (debug)
	printf ("Reading...   0%%");
    if (!ftpGet(ofile, file, 'I'))
        merror(6);
    if (debug)
	printf ("%c%c%c%cDone.\n", 8,8,8,8);

    ftpQuit();
    exit(0);
}

int merror(int i)
{
    if (i<3) {
	fprintf (stderr, "Usage: %s [-dv] ftp://<site>/<file> [<local filename>]\n", prog, i);
	fprintf (stderr, "       %s [-dv] http://<site>/<file> [<local filename>]\n\n", prog, i);
	exit(-1);
    }
    if (debug>0) 
        printf ("\n");

    if (i==3)
        fprintf (stderr, "%sConnect failed.\n", ftplib_lastresp);
    else if (i==4)
        fprintf (stderr, "%sLogin failed.\n", ftplib_lastresp);
    else if (i==5)
        fprintf (stderr, "%sChdir failed.\n", ftplib_lastresp);
    else if (i==6)
        fprintf (stderr, "%sGet failed.\n", ftplib_lastresp);
    exit(-1);
}

void version()
{
    printf ("%s Version %s\n", prog, VERSION);
    exit(0);
}
