/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1999)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Include / Inclusion ........................................... */

      #include "weblib/l_http/l_http_server.h"
      #include "weblib/l_http/l_http_download/l_http10_page.h"


   /* ... Functions / Funciones ......................................... */
  
      /*  Auxiliar Functions  *
       * -------------------- */
      T_BOOL  L_HTTP_SERVER_GetHttpVersion   ( INOUT t_http_ver       *httpVer,
                                               IN    t_http_response  *httpr,
                                               IN    t_downLoadWS     *dlws )
      {
        T_CHAR  *httpVersion ;

        /* ... check params ... */
        NULL__SET_ERROR__RET_FALSE(httpVer) ;
        NULL__SET_ERROR__RET_FALSE(httpr) ;
        NULL__SET_ERROR__RET_FALSE(dlws) ;

        /* ... Get version ... */
        httpVersion = L_HTTP_RESPONSE_getField(httpr,"HttpVersion") ;
        if (X_STRING_Equal(httpVersion,"HTTP/0.9") == TRUE)
            (*httpVer) = v_0_9 ;
        if (X_STRING_Equal(httpVersion,"HTTP/1.0") == TRUE)
            (*httpVer) = v_1_0 ;
        if (X_STRING_Equal(httpVersion,"HTTP/1.1") == TRUE)
            (*httpVer) = v_1_1 ;

        switch ((*httpVer))
        {
          case v_0_9 :
               L_VERBOSE_LOG_appendMsg(dlws,"-> 0.9") ;
               break ;
          case v_1_0 :
               L_VERBOSE_LOG_appendMsg(dlws,"-> 1.0") ;
               break ;
          case v_1_1 :
               L_VERBOSE_LOG_appendMsg(dlws,"-> 1.1") ;
               break ;
          default :
        }

        return TRUE ;
      }

      T_BOOL  L_HTTP_SERVER_GetConfiguration  ( IN     t_httpCfg      *webCfg,
                                                IN     t_url          *url,
                                                INOUT  t_downLoadWS   *dlws )
      {
        T_BOOL            ok ;
        t_http_response  *httpr ;
        T_INT             codigo ;

        /* ... check params ... */
        NULL__SET_ERROR__RET_FALSE(webCfg) ;
        NULL__SET_ERROR__RET_FALSE(url) ;
        NULL__SET_ERROR__RET_FALSE(dlws) ;

        L_VERBOSE_LOG_newMsg(dlws,"Server Configuration... ") ;
        if (dlws->proxy == NULL)
           {
             L_VERBOSE_LOG_newMsg(dlws,
                                  "Trying connect %s... ",
                                  url->machine) ;
           }
        else 
           {
             L_VERBOSE_LOG_newMsg(dlws,
                                  "Trying connect to proxy %s... ",
                                  (dlws->proxyUrl).machine) ;
           }

        if (dlws->skipEL == TRUE)
           {
             /* ... Get / ... */
             ok = L_HTTP10_PAGE_OpenPage2ToReadFile(dlws,
                                                    webCfg,
                                                    url->machine,
                                                    url->port,
                                                    "/",
                                                    &httpr) ;
             FALSE_RET_FALSE(ok) ;
             L_VERBOSE_LOG_appendMsg(dlws,"-> OK") ;
             L_VERBOSE_LOG_newMsg(dlws,"Trying get /... ") ;
             L_HTTP10_COMMAND_Close(&(webCfg->sd)) ;
             webCfg->connected = FALSE ;
           }
        if (dlws->skipEL == FALSE)
           {
             /* ... Get /robots.txt ... */
             ok = L_HTTP10_PAGE_OpenPage2ToReadFile(dlws,
                                                    webCfg,
                                                    url->machine,
                                                    url->port,
                                                    "/robots.txt",
                                                    &httpr) ;
             FALSE_RET_FALSE(ok) ;
             L_VERBOSE_LOG_appendMsg(dlws,"-> OK") ;
             L_VERBOSE_LOG_newMsg(dlws,"Trying get /robots.txt... ") ;

             /* ... read disallow ... */
             codigo = atoi(L_HTTP_RESPONSE_getField(httpr,"Codigo")) ;
             if (codigo < 400)
                 ok = L_DISALLOWLI_ReadDisallow( &(webCfg->disallowList),
                                                  (webCfg->sd).fsocket ) ;
             L_HTTP10_COMMAND_Close(&(webCfg->sd)) ;
             if (codigo < 400)
                      L_VERBOSE_LOG_appendMsg(dlws,"-> YES") ;
                 else L_VERBOSE_LOG_appendMsg(dlws,"-> NO") ;
           }

        /* ... Get version ... */
        L_VERBOSE_LOG_newMsg(dlws,"Trying detect http version... ") ;
        ok = L_HTTP_SERVER_GetHttpVersion( &(webCfg->httpVer),
                                           httpr,
                                           dlws ) ;

        L_VERBOSE_LOG_newMsg(dlws,"\n\n") ;
        L_HTTP_RESPONSE_Destroy(&(httpr)) ;
        return ok ;
      }


      /*  Main Functions *
       * --------------- */
      T_BOOL   L_HTTP_SERVER_Empty         ( INOUT  t_httpCfg   *webCfg )
      {
        /* ... check params ... */
        NULL__SET_ERROR__RET_FALSE(webCfg) ;

        L_DISALLOWLI_Empty(&(webCfg->disallowList)) ;
        L_URL_Destroy(&(webCfg->host)) ;
        return TRUE ;
      }

      T_BOOL  L_HTTP_SERVER_GetConnection   ( IN     t_httpCfg      *webCfg,
                                              IN     t_url          *url,
                                              INOUT  t_downLoadWS   *dlws )
      {
        T_BOOL ok ;

        if (webCfg->httpVer == v_0_9)
           {
             ok = L_HTTP09_COMMAND_Connect( &(webCfg->sd),
                                            url->machine,
                                            url->port ) ;
             FALSE_RET_FALSE(ok) ;
           }
        if (webCfg->httpVer == v_1_0)
           {
             if (dlws->proxy == NULL)
                 ok = L_HTTP10_COMMAND_Connect( &(webCfg->sd),
                                                url->machine,
                                                url->port ) ;
             if (dlws->proxy != NULL)
                 ok = L_HTTP10_COMMAND_Connect( &(webCfg->sd),
                                                 (dlws->proxyUrl).machine,
                                                 (dlws->proxyUrl).port ) ;
             FALSE_RET_FALSE(ok) ;
           }
        if (webCfg->httpVer == v_1_1)
           {
             if (dlws->proxy == NULL)
                 ok = L_HTTP11_COMMAND_Connect( &(webCfg->sd),
                                                url->machine,
                                                url->port ) ;
             if (dlws->proxy != NULL)
                 ok = L_HTTP11_COMMAND_Connect( &(webCfg->sd),
                                                 (dlws->proxyUrl).machine,
                                                 (dlws->proxyUrl).port ) ;
             FALSE_RET_FALSE(ok) ;
             webCfg->connected = TRUE ;
           }

        return TRUE ;
      }

      T_BOOL   L_HTTP_SERVER_Setup          ( OUT     t_httpCfg      *webCfg,
                                              IN      t_url          *urlHost,
                                              INOUT   t_downLoadWS   *dlws )
      {
        T_BOOL  ok ;

        /* ... check params ... */
        NULL__SET_ERROR__RET_FALSE(webCfg) ;
        NULL__SET_ERROR__RET_FALSE(urlHost) ;
        NULL__SET_ERROR__RET_FALSE(dlws) ;

        webCfg->host      = L_URL_UrlDup(urlHost) ;
	NULL_RET_FALSE(webCfg->host) ;
        webCfg->httpVer   = v_1_0 ;
        webCfg->connected = FALSE ;
        L_DISALLOWLI_Empty(&(webCfg->disallowList)) ;
        ok = L_HTTP_SERVER_GetConfiguration(webCfg,
                                            urlHost,
                                            dlws) ;
        if (ok == FALSE)
            L_VERBOSE_LOG_newMsg(dlws,"Server don't love me (:-<)... ") ;
	return ok ;
      }


   /* ................................................................... */

