/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1999)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Include / Inclusion ........................................... */

      #include "weblib/l_http/l_http_download/l_http10_command.h"


   /* ... Function / Funciones .......................................... */

      T_BOOL    L_HTTP10_COMMAND_GET  ( INOUT  t_sock     *sd,
                                        IN     T_CHAR     *url,
                                        IN     T_CHAR     *HttpVer,
                                        IN     T_CHAR     *clientName,
                                        IN     T_CHAR     *ident ) 
      {
        T_CHAR  *reqstr ;
        T_BOOL   ok ;
  
        if (ident == NULL)
           {
             reqstr = X_STRING_Dsprintf("GET %s %s\n"
                                        "User-Agent: %s\n"
                                        "Accept: */*\n"
                                        "\n",
                                        url,HttpVer,clientName) ;
           }
        else
           {
             unsigned char *encodeId ;
             unsigned int   encodeIdLen ;
  
             ok = L_BASE64_encode((unsigned char  *)ident,
                                  (unsigned int    )X_STRING_StrLen(ident),
                                  (unsigned char **)&encodeId,
                                  (unsigned int   *)&encodeIdLen) ;
             FALSE_RET_FALSE(ok) ;
             reqstr = X_STRING_Dsprintf("GET %s %s\n"
                                        "User-Agent: %s\n"
                                        "Accept: */*\n"
                                        "Authorization: Basic %s\n"
                                        "\n",
                                        url,HttpVer,clientName,encodeId) ;
             X_ALLOC_Free((void **)&encodeId) ;
           }
        NULL_RET_FALSE(reqstr) ;
        ok = L_HTTP10_COMMAND_Request(sd,reqstr) ;
        X_ALLOC_Free((void **)&reqstr) ;
        return ok ;
      } 
  
      T_BOOL    L_HTTP10_COMMAND_HEAD ( INOUT  t_sock     *sd,
                                        IN     T_CHAR     *url,
                                        IN     T_CHAR     *clientName ) 
      {
        T_CHAR  *reqstr ;
        T_BOOL   ok ;
  
        reqstr = X_STRING_Dsprintf("HEAD %s HTTP/1.0\n"
                                   "User-Agent: %s\n"
                                   "Accept: */*\n"
                                   "\n",
                                   url,clientName) ;
        NULL_RET_FALSE(reqstr) ;
        ok = L_HTTP10_COMMAND_Request(sd,reqstr) ;
        X_ALLOC_Free((void **)&reqstr) ;
        return ok ;
      } 


/* ...................................................................... */

