# HTTP client class
# 
# The code is taken from "httplib.py" of the python source
# and is just slightly modified to connect to HTTP/1.1 server

import httplib

import string
import regex
import regsub
import mimetools

replypat = 'HTTP/1.[0-9][ \t]+\([0-9][0-9][0-9]\)\(.*\)'
replyprog = regex.compile(replypat)

class HTTP_NEW(httplib.HTTP):

	def getreply(self):
		self.file = self.sock.makefile('r')
		self.sock = None
		line = self.file.readline()
		if self.debuglevel > 0: print 'reply:', `line`
		if replyprog.match(line) < 0:
			self.headers = None
			return -1, line, self.headers
		errcode, errmsg = replyprog.group(1, 2)
		errcode = string.atoi(errcode)
		errmsg = string.strip(errmsg)
		self.headers = mimetools.Message(self.file, 0)
		return errcode, errmsg, self.headers
