#!/usr/local/bin/python

from globale import Globale
from utils   import *

DEFAULT_HTML_FILE = 'index.html'

################################################
## Main
G = Globale()

while 1:
	# Check for anchor todo
	anchor = G.parser.current_todo()
	if not anchor: break # work completed
   	G.print_normal(N0, '(%d/%d) "%s"' %(G.parser.nbDone+1,
				                        len(G.parser.anchorList), anchor))
	
	# Treat anchor
	fileName = anchor
	if fileName[-1]=='/': fileName = fileName + DEFAULT_HTML_FILE
	res = G.retrieve_page(anchor, fileName)

	# the anchor is a directory : retrieve it with an additionnal /
	if res==['rep']:
		G.parser.modify_current_todo(anchor + '/')
		continue

	G.parser.increment_done()
	if not res: continue # error
	
	# eventually read the file (need to be saved or/and to be parsed)
	if not res[3] and not res[0]=="text/html": continue
	try:
		page = res[1].read()
		res[1].close()
	except: 
		G.print_error('error cannot read a file')
		continue

	# enventually search for new anchors
	if res[0]=="text/html": G.treat_html(page, anchor)

	# eventually save the file
	if not res[3] and not G.page: continue
	if G.page: page = G.page
	G.treat_return(save_file(fileName, page, mktime(res[2])))
	if G.page: G.page = ''

G.end()
