##############################################################################
# balloon.tcl - procedures used by balloon help
#
# Copyright (C) 1996-1997 Stewart Allen
# 
# This is part of vtcl source code
# Adapted for general purpose by 
# Daniel Roche <daniel.roche@bigfoot.com>
# thanks to D. Richard Hipp for the multi-headed display fix
# version 1.2 ( Sep 21 2000 ) 
#
# Modified 15-Nov-2000 by Andres Garcia <fandom@retemail.es>
#     - Wrapped it up in a namespace.
#     - Added the 'delete_balloon' procedure to unbind a 
#       widget to a balloon.
#
# Modified 14-Jan-01 by Andres Garcia <fandom@retemail.es>
#     - Added a <destroy> binding to the Bulle class so
#       that if a widget that has a balloon gets destroyed
#       the balloon won't survive it.
#
# Modified 14-Aug-01 by Andres Garcia <fandom@reteamil.es>
#     - I made sure there can be no balloon when going to
#       show one.
#
# Modified 30-Aug-01 by Andres Garcia <fandom@reteamil.es>
#     - The coordinates where the balloon is going to be shown
#       get modified by the <Motion> event between entering the
#       widget and the moment where the balloon is shown.
#     - Put more vertical and less horizontal distance between
#       the cursor and the balloon. Mainly because the hourglass
#       in Windows would cover the balloon.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##############################################################################

namespace eval BalloonHelp {

bind Bulle <Enter> {
    set BalloonHelp::Bulle(x) %X
    set BalloonHelp::Bulle(y) %Y
    set BalloonHelp::Bulle(id) \
            [after 500 {BalloonHelp::balloon %W}]
}

bind Bulle <Leave> {
    BalloonHelp::kill_balloon
}

bind Bulle <Motion> {
    set BalloonHelp::Bulle(x) %X
    set BalloonHelp::Bulle(y) %Y
}

bind Bulle <Button> {
    BalloonHelp::kill_balloon
}

bind Bulle <Destroy> {
    BalloonHelp::delete_balloon %W
}

proc set_balloon {target message} {
    variable Bulle

    if {![info exists Bulle($target)]} {
        bindtags $target "[bindtags $target] Bulle"
    } else {
        if {![string match $Bulle($target) $message]} {
            catch {destroy .balloon}
        }
    }
    set Bulle($target) $message

   return
}

proc delete_balloon {target} {
    variable Bulle

    if {![info exists Bulle($target)]} {
        return
    }
    after cancel Bulle(id) 
    unset Bulle($target)
    set bindList   [bindtags $target]
    set bulleIndex [lsearch $bindList Bulle]
    set bindList   [lreplace $bindList $bulleIndex $bulleIndex]
    bindtags $target $bindList

    catch {destroy .balloon}

    return
}

proc kill_balloon {} {
    variable Bulle

    after cancel $Bulle(id)
    catch {destroy .balloon}

    return
}

proc balloon {target} {
    variable Bulle

    if {[catch {set Bulle($target)} message]} return
    catch {destroy .balloon}

    set x $Bulle(x)
    set y [expr {$Bulle(y) + 20}]

    toplevel .balloon -bg black -screen [winfo screen $target]
    wm overrideredirect .balloon 1
    label .balloon.l \
            -text $message -relief flat \
            -bg #ffffaa -fg black -padx 2 -pady 0 -anchor w
    pack .balloon.l -side left -padx 1 -pady 1
    wm geometry .balloon +${x}+${y}

    return
}

}
