###############################################################################
###############################################################################
##                        Herramientas.tcl
###############################################################################
###############################################################################
## Includes procedures to implement the commands in the 'Tools' and 'Options'
## menus.
###############################################################################
###############################################################################
## (c) 1999-2002 Andrs Garca Garca. fandom@retemail.es
## Distributed under the terms of the GPL v2
###############################################################################
###############################################################################

namespace eval Herramientas {

###############################################################################
# ExtensionsDialog
#    Creates a dialog box to choose file extensions
#
# Parameters:
#    title: title of the dialog box
#    parent: the window over which the dialog will be created.
#    filter: a string with the current filter, defaults to empty.
#
# Side effect:
#    Namespace scope variable 'bot' will contain the choosen extensions
#
# Returns:
#    1: if cancelled
###############################################################################
proc ExtensionDialog {title parent {filter ""}} {
    global labelButtons labelTitles downOptions
    variable done

    set coord(x) [winfo rootx $parent]
    set coord(y) [winfo rooty $parent]

    set win [toplevel .extDialog]
    wm title $win $title
    wm resizable $win 0 0
    wm geometry $win +[expr {$coord(x)+100}]+[expr {$coord(y)+15}]

    set marcoExt [frame $win.marcoext]
    set marcoInt [frame $marcoExt.marcoInt -bd 2 -relief groove]
    set marcoBot [frame $win.marcoBot]

    set izqBot1  [checkbutton $marcoInt.bot1 -variable ::Herramientas::bot(1) \
            -onvalue "jpg" -offvalue "" -text "*.jpg"]
    set izqBot2  [checkbutton $marcoInt.bot2 -variable ::Herramientas::bot(2) \
            -onvalue "gif" -offvalue "" -text "*.gif"]
    set izqBot3  [checkbutton $marcoInt.bot3 -variable ::Herramientas::bot(3) \
            -onvalue "ps"  -offvalue "" -text "*.ps" ]

    set cenBot1  [checkbutton $marcoInt.bot4 -variable ::Herramientas::bot(4) \
            -onvalue "pdf" -offvalue "" -text "*.pdf"]
    set cenBot2  [checkbutton $marcoInt.bot5 -variable ::Herramientas::bot(5) \
            -onvalue "txt" -offvalue "" -text "*.txt"]
    set cenBot3  [checkbutton $marcoInt.bot6 -variable ::Herramientas::bot(6) \
            -onvalue "mov" -offvalue "" -text "*.mov"]

    set derBot1  [checkbutton $marcoInt.bot7 -variable ::Herramientas::bot(7) \
            -onvalue "avi" -offvalue "" -text "*.avi"]
    set derBot2  [checkbutton $marcoInt.bot8 -variable ::Herramientas::bot(8) \
            -onvalue "zip" -offvalue "" -text "*.zip"]
    set derBot3  [checkbutton $marcoInt.bot9 -variable ::Herramientas::bot(9) \
            -onvalue "tgz" -offvalue "" -text "*.tgz"]

    if {![string match $title $labelTitles(exclude)]} {
        foreach {index ext} {1 jpg 2 gif 3 ps 4 pdf 5 txt 6 mov 7 avi 8 zip 9 tgz} {
            set ::Herramientas::bot($index) $ext
        }
    } else {
        foreach {index ext} {1 jpg 2 gif 3 ps 4 pdf 5 txt 6 mov 7 avi 8 zip 9 tgz} {
            if {[regexp "$ext" $filter]} {
                set ::Herramientas::bot($index) $ext
            } else {
                set ::Herramientas::bot($index) ""
            }
        }
    }

    set aceptar  [button $marcoBot.aceptar  -textvariable labelButtons(ok)    \
		-width 8 -command "set ::Herramientas::done 1"]
    set cancelar [button $marcoBot.cancelar -textvariable labelButtons(cancel)\
		-width 8 -command "set ::Herramientas::done 0"]

    bind $win <Escape> "$cancelar invoke"

    pack $marcoExt -ipadx 10 -ipady  5
    pack $marcoInt -ipadx 10 -ipady 15 -side bottom

    grid $izqBot1 $cenBot1 $derBot1 -sticky w -padx 3
    grid $izqBot2 $cenBot2 $derBot2 -sticky w -padx 3
    grid $izqBot3 $cenBot3 $derBot3 -sticky w -padx 3

    pack $marcoBot -fill x -padx 7
    pack $cancelar $aceptar  -side right -pady 5 -padx 3

#    grab $win
    tkwait variable ::Herramientas::done
#    grab release $win
    destroy $win
    if {$::Herramientas::done==0} {
        return 1
    }

    return
}

###############################################################################
# PurgeFilesDir
#    Sweeps a directory turning files to size 0
#
# Parameters:
#    dir: directory to be processed
#    purgarCmd: extensions of the files to minimize
###############################################################################
proc PurgeFilesDir {dir purgarCmd} {
    global dirGetleft tcl_platform

    cd $dir
    set archivos ""
    set extList  [concat $purgarCmd ram jpeg zip aiff]
    foreach ext $extList {
        set archivos [concat $archivos [glob -nocomplain *.$ext]]
        set archivos [concat $archivos [glob -nocomplain [string toupper *.$ext]]]
    }

    foreach file $archivos {
        file stat $file estado
        if {$estado(size)!=0} {
            file delete -force $file
            Commands::Touch $file
        }
    }

    set directorios [glob -nocomplain */]

    foreach dir $directorios {
        update
        PurgeFilesDir $dir $purgarCmd
        cd ..
    }
    return
}

###############################################################################
# PurgeFiles
#    The procedures takes care of recursively clean directories of files
#    with certain extensions *.jpg, *.gif, etc.
###############################################################################
proc PurgeFiles {} {
    global labelTitles labelMessages dirGetleft

    if {[winfo exists .extDialog]} {
        focus .extDialog
        return
    }

    if {[ExtensionDialog $labelTitles(purge) .]==1} {
        return
    }

    set dir [Dialogos::SelectDirectory $dirGetleft(toolDir)]
#    set dir [tk_chooseDirectory]
    if {![string compare $dir ""]} {
        return
    }
    set dirGetleft(toolDir) [file dirname $dir]

    set dirTmp [pwd]
    for {set i 1;set purgarCmd ""} {$i<10} {incr i} {
        append purgarCmd $::Herramientas::bot($i) " "
    }

    PurgeFilesDir $dir $purgarCmd

    tk_messageBox -title $labelTitles(theEnd) -icon info \
        -message $labelMessages(purged)

    cd $dirTmp

    return
}

###############################################################################
# RestoreOriginalsDir
#    Recursively restores the original files.
#
# Parameter:
#    dir: directory in which it will begin to restore.
###############################################################################
proc RestoreOriginalsDir {dir} {

    cd $dir
    set directorio [glob -nocomplain *.orig]
    foreach fichero $directorio {
        file rename -force -- $fichero [file root $fichero]
    }

    set directories [glob -nocomplain */]
    foreach dir $directories {
	    RestoreOriginalsDir $dir
        cd ..
    }
    return
}

###############################################################################
# RestoreOriginals
#    Starts the process of restoring the original files downloaded from Web
#    pages.
###############################################################################
proc RestoreOriginals {} {
    global labelTitles labelMessages dirGetleft

    set dir [Dialogos::SelectDirectory $dirGetleft(toolDir)]
#    set dir [tk_chooseDirectory]
    if {![string compare $dir ""]} {
        return
    }
    set dirGetleft(toolDir) [file dirname $dir]
    set dirTmp [pwd]
    RestoreOriginalsDir $dir

    tk_messageBox -title $labelTitles(theEnd) -icon info \
            -message $labelMessages(restored)

    cd $dirTmp

    return
}

###############################################################################
# SameProxy
#    Disables or enables the entries for the ftp proxy, depending on
#    the checkbutton
###############################################################################
proc SameProxy {} {
    global getleftOptions
    variable ip

    for {set i 3} {$i<5} {incr i} {
        if {$getleftOptions(sameProxy)==1} {
            $ip($i) configure -state disabled
            $ip($i) configure -bg $getleftOptions(disBg)
        } else {
            $ip($i) configure -state normal -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg)
        }
    }

    return
}

###############################################################################
# AuthenProxy
#    Disables or enables the entries for authentificatinf proxies.
###############################################################################
proc AuthenProxy {} {
    global getleftOptions tcl_platform
    variable authen

    if {$getleftOptions(useAuthProxy)==1} {
        $authen(name) configure -state normal
        if {$getleftOptions(saveAuthPass)==1} {
            $authen(pass) configure -state normal
        } else {
            $authen(pass) configure -state disabled
        }
        $authen(name) configure -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg)
        if {$getleftOptions(saveAuthPass)==1} {
            $authen(pass) configure -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg)
        } else {
            $authen(pass) configure -bg $getleftOptions(disBg)
        }
        $authen(save) configure -state normal
    } else {
        $authen(name) configure -state disabled
        $authen(pass) configure -state disabled
        set getleftOptions(saveAuthPass) 0
        $authen(name) configure -bg $getleftOptions(disBg)
        $authen(pass) configure -bg $getleftOptions(disBg)
        $authen(save) configure -state disabled
    }    

    return
}

###############################################################################
# ConfProxyControl
#    Takes the action ordered by the user in the proxy dialog.
#
# Parameter
#    action: 'clear' if the user wants to clear the configuration.
#            'accept' if the user accepts it.
#            'cancel' the user cancels the dialog
#    parent: parent widget of the conf dialog.
#
# Returns:
#    '0' if everything went well and '1' if there was an error.
###############################################################################
proc ConfProxyControl {action {parent .proxy}} {
    global getleftOptions labelMessages labelTitles
    variable ip
    variable getleftOptionsTemp
    variable authen

    switch -exact -- $action {
        clear {
            set getleftOptions(sameProxy) 0
            SameProxy
            for {set i 1} {$i<5} {incr i} {
                $ip($i) delete 0 end
            }
            catch {unset getleftOptions(httpProxy)}
            catch {unset getleftOptions(ftpProxy)}
            set getleftOptions(proxy) 0
            $authen(name) delete 0 end
            $authen(pass) delete 0 end
            catch {unset getleftOptions(proxyUser)}
            catch {unset getleftOptions(proxyPass)}
            set getleftOptions(useAuthProxy) 0
            set getleftOptions(saveAuthPass) 0
            AuthenProxy
            return 0
        }
        accept {
            for {set i 1} {$i<5} {incr i} {
                set tmp [$ip($i) get]
                set dirProxy($i) $tmp
                if {($getleftOptions(sameProxy)==1)&&($i==2)} break
            }
            if {($dirProxy(1)=="")&&($dirProxy(2)=="")} {
                catch {unset getleftOptions(httpProxy)}
                catch {unset getleftOptions(ftpProxy)}
            } else {
                set getleftOptions(httpProxy)    "$dirProxy(1):$dirProxy(2)"
                if {$getleftOptions(sameProxy)==0} {
                    set getleftOptions(ftpProxy) "$dirProxy(3):$dirProxy(4)"
                } else {
                    set getleftOptions(ftpProxy) $getleftOptions(httpProxy)
                }
                set getleftOptions(proxy)     1
                set getleftOptions(proxyUser) [$authen(name) get]
                set getleftOptions(proxyPass) [$authen(pass) get]
                if {($getleftOptions(useAuthProxy)==1)\
                    &&($getleftOptions(proxyUser)=="")} {
                    tk_messageBox -type ok -icon error -parent $parent \
                            -message $labelMessages(noUser) -title $labelTitles(error)    
                    return 1
                }
                if {($getleftOptions(saveAuthPass)==1) \
                        &&($getleftOptions(proxyPass)=="")} {
                    tk_messageBox -type ok -icon error -parent $parent \
                            -message $labelMessages(noPass) -title $labelTitles(error)
                    return 1
                }
            }
        }
        cancel {
            array set getleftOptions [array get getleftOptionsTemp]
        }
    }

    SaveConfig
    destroy .proxy

    return 0
}

###############################################################################
# ConfProxyWindowCommon
#    This procedure takes care of creating the parts of the window that are
#    shared between the proper 'Proxy configure' dialog and the one in the 
#    configuration wizard.
#
# Parameter:
#    The widget in which it will be put.
###############################################################################
proc ConfProxyWindowCommon {parent} {
    global getleftOptions
    variable ip
    variable authen

    set marcoEx   [frame $parent.marcoEx]
    set marcoIn   [frame $marcoEx.marcoIn]
    set marcoIp   [fl::FrameLabel $marcoIn.marcoIp   -bd 2 -relief groove\
            -textvariable  labelFrames(proxy)]

    set label1 [label $marcoIp.label1 -textvariable labelDialogs(http)]
    set ip(1)  [entry $marcoIp.1 -width 20 -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg) -justify  left]
    set ip(2)  [entry $marcoIp.2 -width 4  -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg)]
    set colon1 [label $marcoIp.colon1 -text : -width 2]

    set label2 [label $marcoIp.label2  -textvariable labelDialogs(ftp)]
    set ip(3)  [entry $marcoIp.3 -width 20 -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg) -justify  left]
    set ip(4)  [entry $marcoIp.4 -width 4  -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg)]
    set colon2 [label $marcoIp.colon2 -text : -width 2]

    set checkIp [checkbutton $marcoIp.check -textvariable labelDialogs(sameProxy) \
            -variable getleftOptions(sameProxy) -command ::Herramientas::SameProxy]

    set marcoAuth    [fl::FrameLabel $marcoIn.marcoAuth -bd 2 -relief groove \
            -textvariable labelFrames(authen)]
    set nameLabel    [label $marcoAuth.nameLabel -textvariable labelDialogs(username)]
    set authen(name) [entry $marcoAuth.nameEntry -width 15  -bg $getleftOptions(bg) \
            -fg $getleftOptions(fg)]
    set passLabel    [label $marcoAuth.passLabel -textvariable labelDialogs(password)]
    set authen(pass) [entry $marcoAuth.passEntry -width 15  -bg $getleftOptions(bg) \
            -fg $getleftOptions(fg) -show *]

    set authen(use)  [checkbutton $marcoAuth.use  -command Herramientas::AuthenProxy \
        -textvariable labelDialogs(authenUse) -variable getleftOptions(useAuthProxy)]
    set authen(save) [checkbutton $marcoAuth.save -command Herramientas::AuthenProxy \
        -textvariable labelDialogs(authenSave) -variable getleftOptions(saveAuthPass)]

    grid $marcoEx -padx 7    -ipady 5
    grid $marcoIn -sticky s  -pady 5
    grid $marcoIp $marcoAuth -padx 5 -ipadx 10 -ipady 7 -sticky ns
    grid $label1 -in $marcoIp -row 0 -column 0 -sticky w -pady 3
    grid $ip(1)  -in $marcoIp -row 0 -column 1 -sticky w -pady 3
    grid $colon1 -in $marcoIp -row 0 -column 2 -sticky w -pady 3
    grid $ip(2)  -in $marcoIp -row 0 -column 3 -sticky e -pady 3
    grid $label2 -in $marcoIp -row 1 -column 0 -sticky w -pady 3
    grid $ip(3)  -in $marcoIp -row 1 -column 1 -sticky w -pady 3
    grid $colon2 -in $marcoIp -row 1 -column 2 -sticky w -pady 3
    grid $ip(4)  -in $marcoIp -row 1 -column 3 -sticky e -pady 3
    grid configure $checkIp -columnspan 4

    grid $nameLabel    -in $marcoAuth -row 0 -column 0 -padx 5 -pady 3 -sticky w
    grid $authen(name) -in $marcoAuth -row 0 -column 1 -padx 5 -pady 3
    grid $passLabel    -in $marcoAuth -row 1 -column 0 -padx 5 -pady 3 -sticky w
    grid $authen(pass) -in $marcoAuth -row 1 -column 1 -padx 5 -pady 3
    grid $nameLabel    -in $marcoAuth -row 0 -column 0 -padx 5 -pady 3 
    grid configure $authen(use)  -padx 5 -columnspan 2
    grid configure $authen(save) -padx 5 -columnspan 2

    focus $ip(1)
    bind $ip(1) <Return>   "focus $ip(2)"
    bind $ip(1) <KP_Enter> "focus $ip(2)"
    bind $ip(2) <Return>   "focus $ip(3)"
    bind $ip(2) <KP_Enter> "focus $ip(3)"
    bind $ip(3) <Return>   "focus $ip(4)"
    bind $ip(3) <KP_Enter> "focus $ip(4)"
    bind $authen(name) <Return>   "focus $authen(pass)"
    bind $authen(name) <KP_Enter> "focus $authen(pass)"
    bind $authen(pass) <Return>   "focus $authen(use)"
    bind $authen(pass) <KP_Enter> "focus $authen(use)"
    bind $authen(use)  <Key-Down> "focus $authen(save)"
    bind $authen(save) <Key-Up>   "focus $authen(use)"

    if {[info exists getleftOptions(httpProxy)]} {
        regexp {(.+)(?::)(.+)} $getleftOptions(httpProxy) nada name port
        $ip(1) insert insert $name
        $ip(2) insert insert $port
    }
    if {[info exists getleftOptions(ftpProxy)]} {
        regexp {(.+)(?::)(.+)} $getleftOptions(ftpProxy)  nada name port
        $ip(3)  insert insert $name
        $ip(4)  insert insert $port
    }
    SameProxy

    catch {$authen(name) insert insert $getleftOptions(proxyUser)}
    catch {$authen(pass) insert insert $getleftOptions(proxyPass)}
    AuthenProxy

    return
}

###############################################################################
# ConfProxyWindow
#    Creates the window in which the user enters his proxy data.
###############################################################################
proc ConfProxyWindow {} {
    global labelTitles

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set proxy [toplevel .proxy]
    wm title $proxy $labelTitles(proxy)
    wm resizable $proxy 0 0
    wm geometry  $proxy +[expr {$coord(x)+75}]+[expr {$coord(y)+75}]

    ConfProxyWindowCommon $proxy

    set botones  [frame  $proxy.marcoEx.botones]
    set borrar   [button $botones.borrar   -textvariable labelButtons(clear) \
            -width 8 -command {::Herramientas::ConfProxyControl clear}]
    set aceptar  [button $botones.aceptar  -textvariable labelButtons(ok)    \
            -width 8 -command {::Herramientas::ConfProxyControl accept}]
    set cancelar [button $botones.cancelar -textvariable labelButtons(cancel)\
            -width 8 -command {::Herramientas::ConfProxyControl cancel}]

    grid $botones -sticky e -padx 2
    grid $borrar $aceptar $cancelar $aceptar -padx 3 -sticky n

    return
}

###############################################################################
# ConfProxy
#     Allows the user to enter the proxy data
###############################################################################
proc ConfProxy {} {
    global   getleftOptions
    variable getleftOptionsTemp

    if {[winfo exists .proxy]} {
        focus .proxy
        return
    }

    array set getleftOptionsTemp [array get getleftOptions]
    ConfProxyWindow

    return
}

###############################################################################
# GetPassControl
#    Takes the action ordered by the user in the 'Get Password' dialog.
###############################################################################
proc GetPassControl {} {
    global getleftOptions labelMessages
    variable done
    variable authen

    set getleftOptions(proxyUser) [$authen(name) get]
    set getleftOptions(proxyPass) [$authen(pass) get]

    if {($getleftOptions(proxyPass)=="")} {
        tk_messageBox -type ok -icon error -parent .getPass \
                -message $labelMessages(noPass)
        return
    }
    SaveConfig
    set done 1

    return
}

###############################################################################
# GetPassWindow
#    Dialog to get the Username and password for the proxy.
###############################################################################
proc GetPassWindow {} {
    global getleftOptions labelButtons labelTitles labelDialogs labelFrames
    variable done
    variable authen

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set win [toplevel .getPass]
    wm title $win $labelTitles(proxy)
    wm resizable $win 0 0
    wm geometry  $win +[expr {$coord(x)+125}]+[expr {$coord(y)+75}]

    set done 0

    set marcoEx    [frame $win.marcoEx]
    set marcoLabel [fl::FrameLabel $marcoEx.marcoIn   -bd 2 -relief groove \
            -textvariable labelFrames(authen)]
    set marcoIn    [frame $marcoLabel.in]
    set nameLabel    [label $marcoIn.nameLabel -textvariable labelDialogs(username)]
    set authen(name) [entry $marcoIn.nameEntry -width 15 -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg)]
    set passLabel    [label $marcoIn.passLabel -textvariable labelDialogs(password)]
    set authen(pass) [entry $marcoIn.passEntry -width 15 -bg $getleftOptions(bg) \
                    -fg $getleftOptions(fg) -show *]

    set authen(save) [checkbutton $marcoIn.save \
        -textvariable labelDialogs(authenSave) -variable getleftOptions(saveAuthPass)]

    set botones  [frame  $marcoEx.botones]
    set aceptar  [button $botones.aceptar  -textvariable labelButtons(ok)    \
            -width 8 -command ::Herramientas::GetPassControl]
    set cancelar [button $botones.cancelar -textvariable labelButtons(cancel)\
            -width 8 -command {set ::Herramientas::done 0}]

    grid $marcoEx -padx 7   -ipady 5
    grid $marcoLabel -padx 5 -pady 5
    grid $marcoIn -sticky s -pady 10 -padx 5
    grid $nameLabel    -in $marcoIn -row 0 -column 0 -padx 5 -pady 3 -sticky w
    grid $authen(name) -in $marcoIn -row 0 -column 1 -padx 5 -pady 3
    grid $passLabel    -in $marcoIn -row 1 -column 0 -padx 5 -pady 3 -sticky w
    grid $authen(pass) -in $marcoIn -row 1 -column 1 -padx 5 -pady 3
    grid configure $authen(save) -padx 5 -columnspan 2

    grid $botones -sticky e -padx 2
    grid $aceptar $cancelar $aceptar -padx 3 -sticky n

    bind $win          <Escape>   "$cancelar invoke"
    bind $authen(name) <Return>   "focus $authen(pass)"
    bind $authen(name) <KP_Enter> "focus $authen(pass)"
    bind $authen(pass) <Return>   "focus $authen(save)"
    bind $authen(pass) <KP_Enter> "focus $authen(save)"
    bind $authen(save) <Key-Up>   "focus $authen(save)"
    bind $authen(save) <Key-Down> "focus $aceptar"

    if {[catch {$authen(name) insert insert $getleftOptions(proxyUser)}]} {
        focus $authen(name)
    } else {
        focus $authen(pass)
    }

    return
}

###############################################################################
# GetPass
#     Queries the user for the password.
#
# Returns
#     '1' if a password is set, '0' otherwise
###############################################################################
proc GetPass {} {
    global getleftOptions

    if {[winfo exists .getPass]} {
        focus .getPass
        return
    }

    array set getleftOptionsTemp [array get getleftOptions]
    GetPassWindow
    tkwait variable ::Herramientas::done
    if {$::Herramientas::done==0} {
        array set getleftOptions [array get getleftOptionsTemp]
    }

    destroy .getPass

    return $::Herramientas::done
}

###############################################################################
# FilterFiles
#    You can choose which file extensions will be ignored while downloading a
#    Web site.
#
# Parameter:
#    filter: The current filter.
#    parent: The path of the window over which the dialog will be shown,
#            defaults to the main window.
#
# Returns: 
#    A string with the filter, if the users cancells the dialog, it will be
#    the same string passed as a parameter.
###############################################################################
proc FilterFiles {filter {parent .}} {
    global labelTitles

    if {[winfo exists .extDialog]} {
        focus .extDialog
        return $filter
    }

    if {[ExtensionDialog $labelTitles(exclude) $parent $filter]==1} {
        return $filter
    }
    catch {unset urlsDownloaded}
    for {set i 1;set filter ""} {$i<10} {incr i} {
        if {$::Herramientas::bot($i)!=""} {
            if {$::Herramientas::bot($i)=="tgz"} {
                append filter (tar.gz$) "|"
            } elseif {$::Herramientas::bot($i)=="jpg"} {
                append filter (jpeg$) "|"
            }
            append filter ($::Herramientas::bot($i)$) "|"
        }
    }
    regexp {(.*)(\|)} $filter nada filter

    return $filter
}

###############################################################################
# The following is some code I wrote to autodetect a proxy, it works, but it
# sometimes takes hours doing it so I haven't made it available through the GUI
###############################################################################

proc DummyProc {newSock addr port} {
    variable proxyIp

    regexp {(.*)(\.)} $addr nada myIp

    set proxyIp $myIp.1

    return
}

proc GuessProxyIp {} {
    variable proxyIp

    set serverSocket [socket -server ::Herramientas::DummyProc 11453]

    set channel [socket [info hostname] 11453]

    tkwait variable ::Herramientas::proxyIp

    close $serverSocket

    puts "La direccion: $proxyIp"

    return
}

proc GuessProxyPort {} {
    variable proxyIp
    variable proxyPort

    package require http

    http::config -proxyhost $proxyIp
    for {set i 80} {$i<=10000} {incr i} {
        http::config -proxyport $i
        if {[catch {http::geturl http://freshmeat.net/} token]} {
            continue
        }
        if {[::http::status $token]=="ok"} {
            regexp {( [0-9][0-9][0-9] )} [::http::code $token] code
            if {$code==200} {
                set proxyPort $i
                break
            }
        }
    }
    if {$i<=1000} {
        tk_messageBox -message "El proxy: es $proxyIp:$proxyPort" -type ok -icon info
    } else {
        tk_messageBox -message "No se encontr el proxy" -type ok -icon info
    }
    package forget http

    return
}

}

