###############################################################################
###############################################################################
#####                             Ccombinado.tcl
###############################################################################
# This file contains a combobox type widget
###############################################################################
# I don't know where this widget comes from originally, someone in college
# 'Jess' used to give it, I think he had adapted it and I have changed it
# further. Anyway until someone tells me differently:
# Copyright 1999-2002 Jess, Andrs Garca  fandom@retemail.es
# Distributed under the terms of the LGPL v2.
###############################################################################

# Yes, I know this is a kludge

if {![info exists ::labelMenus(cut)]} {
    set ::labelMenus(cut)             "Cut"
    set ::labelMenus(copy)            "Copy"
    set ::labelMenus(paste)           "Paste"
    set ::labelMenus(clear)           "Clear"
    set ::labelMenus(selectAll)       "Select all"
}

namespace eval Ccombinado {

# First of all we define the shape of the arrow.

if {[info comm flecha] == {}} {
    set flecha {
        #define flecha_width 15
        #define flecha_height 15
        static char flecha_text_bits[] = {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0xf8, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0x40, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00
        }
    }
    image create bitmap flecha -data [set flecha]
    unset flecha
}

###############################################################################
# SetEntryText
#    Sets the selected value in the entry widget, after deleting the former
#    one.
###############################################################################
proc SetEntryText {v entry} {
    variable cbArgs

    if { [set idx [$v curselection ]]!="" } {
        $entry configure -state normal
        $entry delete 0 end
        $entry insert 0 [$v get $idx]
        if {$cbArgs(-activeentry)==0} {
            $entry configure -state disabled
        }
    }
    return
}

###############################################################################
# UnMapList
#    Erases the window used by the list.
###############################################################################
proc UnMapList { w } {
    grab release $w
    wm withdraw [winfo toplevel $w]

    return
}

###############################################################################
# MapList
#    Maps the window with the list
#
# Parameter
#    Window name
###############################################################################
proc MapList {w} {

    set d ${w}_desplegable
    set l $d.listado

    if {[winfo ismapped $d]} {
        grab release $d
        wm withdraw $d
    } else {
        set x1 [expr {[winfo rootx ${w}.fondo.boton]-\
                [winfo reqwidth $l.cuadro]}]
        set y1 [expr {[winfo rooty ${w}.fondo.boton]+\
                [winfo height ${w}.fondo.boton]}]
        wm geometry $d +$x1+$y1
        wm deiconify $d
        raise $d
        focus $l.cuadro
        wm geometry $d +$x1+$y1
        update
        grab -global $d
    }
    return
}

###############################################################################
# Selected
#    If you click on a list element, this procedures puts the selected
#    value in the entry widget, and closes the window list
###############################################################################
proc Selected { w y } {
    variable cbArgs

    set d ${w}_desplegable
    set l $d.listado

    grab release $d

    $w.entry configure -state normal
    $w.entry delete 0 end
    $w.entry insert 0 [$l.cuadro get [$l.cuadro nearest $y] ]
    if {$cbArgs(-activeentry)==0} {
        $w.entry configure -state disabled
    }

    focus $w.entry

    UnMapList $l

    return
}

###############################################################################
# KeySelected
#    Invoked if you use return to select an element, it writes it in the
#    entry widget and then closes the list window.
#
# Parameters
#    w: Path of the widget
#    which: '0' if the key pressed was 'Escape'
#           '1' if it was 'Return'
###############################################################################
proc KeySelected { w which } {

    set d ${w}_desplegable
    set l $d.listado

    if { $which==1 } {
        SetEntryText $l.cuadro $w.entry
    }

    focus $w.entry
    UnMapList $d

    return
}

###############################################################################
# DeleteItem
#    This procedure is invoked when the user presses the 'supr' button while
#    an element of the listbox is selected, as you have probably guessed, the
#    element gets deleted.
#
# Parameters:
#    w: path of the combobox
#    y: 'y' coordinate of the point in the listbox where the user clicked
###############################################################################
proc DeleteItem {w y} {
    variable cbArgs

    if {$cbArgs(-erasable)==0} {
        return
    }

    set d ${w}_desplegable
    set l $d.listado

    set index [$l.cuadro curselection]
    if {$index!=""} {
        $l.cuadro delete $index
        $l.cuadro configure -height [expr {[$l.cuadro cget -height] - 1}]
        if {$index<[expr {[llength $cbArgs(items)]-1}]} {
            $l.cuadro selection set $index
        } else {
            $l.cuadro selection set [expr {$index -1}]
        }
        set cbArgs(items) [lreplace $cbArgs(items) $index $index]
    }
    return
}

###############################################################################
# UnMapScrollBar
#    Erases the scroll bar in the window list in case it is not needed.
###############################################################################
proc UnMapScrollBar { listbox scrollbar } {

    set items [$listbox index end]
    set size  [$listbox cget -height]
    if {$items <= $size} {
        pack forget $scrollbar
        $listbox configure -height $items
    } else {
        pack $scrollbar -side right -fill y
    }
    return
}

###############################################################################
# ParseArguments
#    Gets the optional parameters passed to the ComboBox into the
#    namespace variable 'cbArgs', the rest get the default values.
###############################################################################
proc ParseArguments {parameters} {
    variable cbArgs

    upvar $parameters args

    set cbArgs(-width)        50
    set cbArgs(-default)      ""
    set cbArgs(-erasable)      0
    set cbArgs(-activeentry)   1
    set cbArgs(-textvariable) ""
    set cbArgs(-bg)           white
    set cbArgs(-fg)           black

    array set cbArgs $args

    return
}

###############################################################################
# ComboBox
#    This procedure creates the combobox.
#
# Parameters:
#    w: full path to name the combobox.
#    items: list with the items to be displayed.
#    args: list with the optional parameters:
#           -default: the value that will appear preselected in the entry.
#           -width: width of the entry, defaults to 50
#           -erasable: '1' if the user can erase items from the listbox,
#            defaults to '0'.
#           -activeEntry: '1' if the user can enter new items.
#           -textvariable: contents of the entry
#           -bg: background color.
#           -fg: foreground color.
#
# Returns
#    The path of the combobox.
###############################################################################
proc ComboBox { w items args} {
    variable cbArgs
    global tcl_platform labelMenus

    frame $w -relief sunken -bd 1
#    array set cbArgs $args
    ParseArguments args

    set cbArgs(items) $items

# Entry box
    menuEntry::menuEntry $w.entry -bd 1 -relief flat -width $cbArgs(-width) \
            -bg $cbArgs(-bg) -fg $cbArgs(-fg)
    catch {$w.entry configure  \
            -disabledbackground $cbArgs(-bg)  -disabledforeground $cbArgs(-fg)}

    frame $w.fondo -bg gray
    $w.entry  insert 0 $cbArgs(-default)
    $w.entry  selection range 0 end	
    if {$cbArgs(-activeentry)==1} {
        $w.entry configure -state normal
    } else {
        $w.entry configure -state disable
    }
    if {$cbArgs(-textvariable)!=""} {
        $w.entry configure -textvariable $cbArgs(-textvariable)
    }

# Button
    button $w.fondo.boton -image flecha -relief raised \
        -command "Ccombinado::MapList $w" -width 8 -height 10
    pack $w.entry -side left -pady 1 -padx 1 -fill x
    pack $w.fondo -side right
    pack $w.fondo.boton -side bottom -pady 1

# Toplevel window with the list
    set d ${w}_desplegable
    toplevel $d -relief raised -bd 1 -bg $cbArgs(-bg)
    wm overrideredirect $d 1
    wm transient $d
    wm withdraw $d

# Frame for the listbox '$l'
    set l $d.listado
    frame $l
    pack $l -expand yes -fill y

# Scrollbar for the listbox '$l.barra'
    scrollbar $l.barra -bd 1 -command "$l.cuadro yview"

# Finally the listbox '$l.cuadro'
    listbox $l.cuadro -yscroll "$l.barra set" -setgrid 1 -bg $cbArgs(-bg) \
        -fg $cbArgs(-fg) -relief sunken -width $cbArgs(-width)
    pack $l.barra -side right -fill y
    pack $l.cuadro -side left -expand 1 -fill both

# 'Etiqueta' is used so all the elementos of the list can be binded
# in one go.
    set etiqueta [winfo name $w]_listado
    foreach q "$d $l $l.cuadro $l.barra" {
         bindtags $q [concat ${etiqueta} [bindtags $q]]
    }
    set numero [llength $cbArgs(items)]
    if {$cbArgs(items) != ""} {
        $l.cuadro delete 0 end
        foreach q $cbArgs(items) {
            $l.cuadro insert end $q
            if { $q==$cbArgs(-default) } {
                set i [lsearch $cbArgs(items) $q]
                $l.cuadro yview moveto [expr {(double($i))/$numero}]
                if {[catch {tkListboxMotion $l.cuadro \ $i}]} {
                    tk::ListboxMotion $l.cuadro \ $i
                }
            }
        }
    }
    bind $l.cuadro <Motion> {
        if {[catch {tkListboxMotion %W [%W index @%x,%y]}]} {
            tk::ListboxMotion %W [%W index @%x,%y]
        }
    }
    bind $l.cuadro <Enter> {
        if {[catch {tkCancelRepeat}]} {
            tk::CancelRepeat
        }
    }
    bind $etiqueta <ButtonPress>  {
        foreach q {rootx rooty width height} {
            set $q [winfo $q %W]
        }
        if {(%X < $rootx) || (%X > ($rootx+$width)) || \
                 (%Y < $rooty) || (($rooty+$height) < %Y)} {
            Ccombinado::UnMapList %W
        }
    }

    bind $etiqueta  <Return>    "Ccombinado::KeySelected [list $w] 1"
    bind $etiqueta  <KP_Enter>  "Ccombinado::KeySelected [list $w] 1"
    bind $etiqueta  <Escape>    "Ccombinado::KeySelected [list $w] 0"
    bind $l.cuadro  <1>         "Ccombinado::Selected    [list $w] %y"
    bind $l.cuadro  <Delete>    "Ccombinado::DeleteItem  [list $w] %y"
    bind $w.entry   <Down>      "Ccombinado::MapList $w"
    bind $l.cuadro  <Configure> "Ccombinado::UnMapScrollBar $l.cuadro $l.barra"

    return $w
}

}
