#!/usr/bin/wish

proc ReadConfig {confFile } {
    set handle [open $confFile]

    for {} {![eof $handle]} {} {
        set line [gets $handle]
        if {[regexp {^#|^ |^$} $line]} {
            continue
        }
        if {[regexp {(?:\[)(.*)(?:\])} $line nada active]} {
            continue
        }
        switch -regexp -- $active {
            scripts {
                set helpDir $line
            }
        }
    }
    return $helpDir
}


wm withdraw .
wm overrideredirect . 1

if {[file exists ../scripts/help.tcl]} {
    set helpDir ../scripts/
} else {
    if {$tcl_platform(platform)=="unix"} {
        if {[file exists /etc/getlet.conf]} {
            set helpDir [ReadConfig /etc/getleft.conf]
        } elseif {[file exists /usr/local/etc/getleft.conf]} {
            set helpDir [ReadConfig /usr/local/etc/getleft.conf]
        } else {
            tk_messageBox -icon error -title Error -type ok \
                    -message "I can't find the help system"
            exit
        }
    }
}

source [file join $helpDir help.tcl]

help::init help.help

after 1000 exit_on_destroy

proc exit_on_destroy {} {
    if {[winfo exists .tophelpwindow]} {
        after 1000 exit_on_destroy
    } else {
        exit
    }
}



