###############################################################################
###############################################################################
##                          FrameLabel
###############################################################################
###############################################################################
## Creates a frame with a label in the top-left of it.
###############################################################################
###############################################################################
## (c) 2000 Andrs Garca Garca. fandom@retemail.es
## You may distribute the contents of this file under the terms of the LGPL v2
###############################################################################
###############################################################################

namespace eval fl {

###############################################################################
# FrameLabel
#    Creates the frame with the label.
#
# Parameters
#    framePath: path to the frame.
#    args: Arguments to be passed to the label and the frame, actually the
#          label only accepts 'text' or 'textvariable', the rest go to 
#          the frame.
###############################################################################
proc FrameLabel {framePath args} {

    frame $framePath

    regexp {(^\.[^\.]+)(.*)} $framePath nada toplevelPath parentFrame
    regsub -all {\.} $parentFrame {} parentFrame

    set labelPath $toplevelPath.$parentFrame
    set frameArgs ""
    foreach {option value} $args {
        switch -exact -- $option {
            -text {
                set frameLabel [label $labelPath -text $value]
            }
            -textvariable {
                set frameLabel [label $labelPath -textvariable $value]
            }
            default {
                lappend frameArgs $option $value
            }
        }
    }
    eval $framePath configure $frameArgs

    set ascent [font metrics [$labelPath cget -font] -ascent]
    place $frameLabel -in $framePath -x [expr {$ascent/2}] -y -$ascent            

    bind $framePath <Destroy> "destroy $labelPath ; break"

    return $framePath
}

}
