###############################################################################
###############################################################################
##                          Ayuda.tcl
###############################################################################
###############################################################################
## Includes the procedures needed for the commands in the 'help' menu
###############################################################################
###############################################################################
## (c) 1999-2000 Andrs Garca Garca. fandom@retemail.es
## You may distribute the contents of this file under the terms of the GPL v2
###############################################################################
###############################################################################

namespace eval Ayuda {

set tclLogo [image create photo -file "$dirGetleft(images)/pwrdLogo150.gif"]
set about   [image create photo -file "$dirGetleft(images)/about.gif"]
set curl    [image create photo -file "$dirGetleft(images)/curl.gif"]

###############################################################################
# Manual
#   Shows Getleft's manual.
###############################################################################
proc Manual {} {
    global dirGetleft

    help::init [file join $dirGetleft(doc) help.help]

    return
}

###############################################################################
# Changes
#   Shows the 'Changes' log
###############################################################################
proc Changes {} {
    global dirGetleft

    help::init [file join $dirGetleft(doc) help.help] changes

    return
}

###############################################################################
# Licence
#   Shows the GPL.
###############################################################################
proc Licence {} {
    global dirGetleft

    help::init [file join $dirGetleft(doc) help.help] GPL

    return
}

###############################################################################
# About
#    Shows some info about the program.
###############################################################################
proc About {} {
    global dirGetleft
    global labelButtons labelTitles

    if {[winfo exists .acercade]} {
        focus .acercade
        return
    }

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set ven [toplevel .acercade]
    wm title $ven $labelTitles(about)
    wm resizable $ven 0 0
    wm geometry  $ven +[expr {$coord(x)+180}]+[expr {$coord(y)+50}]

    set interno    [frame $ven.interno -bd 2 -relief sunken]
    set internoLft [frame $interno.left]
    set internoCnt [frame $interno.center]
    set internoRgt [frame $interno.right]

    set tclIma  [label $internoLft.tcl   -image $Ayuda::tclLogo]
    set textIma [label $internoCnt.texto -image $Ayuda::about]
    set curlIma [label $internoRgt.curl  -image $Ayuda::curl]
    set aceptar [button $ven.aceptar -textvariable labelButtons(ok) \
            -command "destroy $ven"]

    pack $interno
    pack $internoLft $internoCnt $internoRgt -side left
    pack $tclIma
    pack $textIma
    pack $curlIma
    pack $ven.aceptar -pady 4

    bind $ven <Escape> "$aceptar invoke"

    focus $aceptar

    return
}
}
