.TH HTTPHAPS 8 "Jun 19 2003"
.SH NAME
httphaps \- capture and output statistics on HTTP packets on a network.
.SH SYNOPSIS
\fBhttphaps\fP [\fIOPTION\fP]... \fIfile\fP
.SH DESCRIPTION
\fIhttphaps\fP captures HTTP packets from a network interface, and writes statistics on them to \fIfile\fP, or standard out if \fIfile\fP is \fI-\fP.  Statistics are written as well-formed XML between an \fIinterval\fP and just before program exit.

Statistics are collected on: bytes sent to IP, SYN requests sent to IP, HTTP requests sent from IP, HTTP responses sent from IP, content types sent from IP, and different servers sent to all IPs.
.SH OPTIONS
.TP
\fB-i\fP, \fB--interval\fP=\fI<interval>\fR
Write statistics to file between \fIinterval\fR seconds.  Default is 360.  If \fIinterval\fP is <= 0, statistics are written only after program exit.  
.TP
\fB-s\fP, \fB--snaplength\fP=\fI<snaplength>\fR
Defines snaplength in bytes.  Default is 1024.  Should be large enough to get the IP, TCP and HTTP headers.
.TP
\fB-t\fP, \fB--timeout\fP=\fI<timeout>\fR
Defines read timeout for each packet in milliseconds.  Default is 100.
.TP
\fB-d\fP, \fB--interface\fP=\fI<interface>\fR
Defines interface to sniff from.  If omitted, looks up a suitable interface.
.TP
\fB-e\fP, \fB--exit\fP=\fI<sec>\fR
Exit after \fIsec\fP seconds.  Default is never.  Also exits after a keyboard interrupt.
.TP
\fB-c\fP, \fB--count\fP=\fI<count>\fR
Exit after \fIcount\fP packages.  Default is never.  Overrides \fI-b\fP.  Also exits after keyboard interrupt.
.TP
\fB-r\fP, \fB--read\fP=\fI<file>\fR
Read packets from \fIfile\fP instead of an interface.  Overrides \fI-d\fP.  Standard input is used if \fIfile\fP is \fI-\fP.
.SH BUGS AND KNOWN PROBLEMS
If there are few HTTP requests, the interval between writes will be longer than defined.  This is not a bug, and happens because httphaps locks when waiting for a port 80 packet to process.  Please report any bugs to hsh@freecode.dk.
.SH AUTHOR
Written by Jakob Frlich <de01a04@skivehs.dk> and Henrik S. Hansen <hsh@freecode.dk>.  New versions should be available from www.freecode.dk/software.html.
.SH "SEE ALSO"
pcap(3), tcpdump(8), ngrep(8).
