
/*

    File: main.c

    Copyright (C) 2000,2003,2004  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>

#include <signal.h>
#include <wait.h>
#include <pwd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <syslog.h>
#include <sys/time.h>

#include "ftp.h"
#include "ip-lib.h"
#include "lib.h"


char	*program =		"";
char	progname[80] =		"";

int	verbose =		0;
int	debug =			0;
int	ignorenetrc =		0;

char	command[20] =		"get";
char	urllocation[300] =	"";


char *get_homedir(char *dir, int size)
{
	struct passwd *pw;

	if ((pw = getpwuid(getuid())) == NULL) {
		fprintf (stderr, "%s: no such user, uid= %u\n", program, getuid());
		exit (-1);
		}

	copy_string(dir, pw->pw_dir, size);
	return (dir);
}

char *read_netrc(char *hostname, char *username, char *password, int size)
{
	int	is_user, is_server;
	char	home[200], filename[200];
	char	*p, token[80], par[80], line[200];
	struct stat sbuf;
	FILE	*fp;

	get_homedir(home, sizeof(home));
	snprintf (filename, sizeof(filename) - 2, "%s/.netrc", home);

	*password = 0;
	if (stat(filename, &sbuf) != 0)
		return (0);
	else if ((sbuf.st_mode & 0x077) != 0) {
		fprintf (stderr, "%s: wrong permission on %s\n", program, filename);
		exit (1);
		}

	if ((fp = fopen(filename, "r")) == NULL) {
		fprintf (stderr, "%s: can't open %s\n", program, filename);
		exit (1);
		}

	is_server = is_user = 0;
	while (fgets(line, sizeof(line), fp) != NULL) {
		p = skip_ws(noctrl(line));
		if (*p == 0  ||  *p == '#')
			continue;

		get_word(&p, token, sizeof(token));
		get_word(&p, par, sizeof(par));
		if (strcmp(token, "machine") == 0) {
			is_server = (strcasecmp(par, hostname) == 0);
			continue;
			}

		if (is_server != 0) {
			if (strcmp(token, "login") == 0) {
				is_user = 0;
				if (strcmp(par, username) == 0)
					is_user = 1;

				continue;
				}

			if (is_user != 0) {
				if (strcmp(token, "password") == 0) {
					copy_string(password, par, size);
					break;
					}
				}
			}
		}

	fclose (fp);
	return (password);
}


int addfile(ftp_t *x, char *filename)
{
	if (x->arg.argc >= x->arg.argmax) {
		x->arg.argmax += 20;
		x->arg.argv = reallocate(x->arg.argv, x->arg.argmax * sizeof(char *));
		}

	x->arg.argv[x->arg.argc] = allocate(strlen(filename) + 1);
	strcpy(x->arg.argv[x->arg.argc], filename);
	x->arg.argc++;

	return (x->arg.argc);
}


int parse_url(ftp_t *x, char *url)
{
	char	*p, *r;

	p = url;
	if (strncmp(url, "ftp://", 6) == 0)
		p += 6;

	if ((r = strchr(p, '@')) != NULL  &&  strchr(p, '/') > r) {
		*r++ = 0;
		copy_string(x->username, p, sizeof(x->username));
		p = r;
		}

	get_quoted(&p, '/', x->server, sizeof(x->server));
	copy_string(urllocation, p, sizeof(urllocation));

	return (0);
}

void missing_arg(int c, char *string)
{
	fprintf (stderr, "%s: missing arg: -%c, %s\n", program, c, string);
	exit (-1);
}

int main(int argc, char *argv[], char *envp[])
{
	int	c, i, k;
	char	*p, option[80];
	ftp_t	*x;
	
	if ((p = strrchr(argv[0], '/')) == NULL)
		program = argv[0];
	else {
		copy_string(progname, &p[1], sizeof(progname));
		program = progname;
		}

	x = allocate(sizeof(ftp_t));

	k = 1;
	while (k < argc  &&  argv[k][0] == '-'  &&  argv[k][1] != 0) {
		copy_string(option, argv[k++], sizeof(option));
		for (i=1; (c = option[i]) != 0; i++) {
			if (c == 'a')
				x->ascii = 1;
			else if (c == 'c') {
				if (k >= argc)
					missing_arg(c, "command");

				copy_string(command, argv[k++], sizeof(command));
				}
			else if (c == 'd') {
				if (k >= argc)
					missing_arg(c, "directory");

				if (x->ndir >= MAXDIR) {
					fprintf (stderr, "%s: to many directories: %s\n", program, argv[k]);
					exit (1);
					}

				copy_string(x->directory[x->ndir], argv[k++], sizeof(x->directory[x->ndir]));
				x->ndir++;
				}
			else if (c == 'g')
				x->glob = 1;
			else if (c == 'i')
				ignorenetrc = 1;
			else if (c == 'l') {
				if (k >= argc)
					missing_arg(c, "username");

				copy_string(x->username, argv[k++], sizeof(x->username));
				}
			else if (c == 'o') {
				if (k >= argc)
					missing_arg(c, "list options");

				copy_string(x->lsopt, argv[k++], sizeof(x->lsopt));
				}
			else if (c == 'p')
				x->pipe = 1;
			else if (c == 'q') {
				if (x->autolist == 0)
					x->autolist = 1;
				else {
					if (k >= argc)
						missing_arg(c, "output file");

					copy_string(x->outputfile, argv[k++], sizeof(x->outputfile));
					}

				}
			else if (c == 'u') {
				char	url[300];

				if (k >= argc)
					missing_arg(c, "url");

				copy_string(url, argv[k++], sizeof(url));
				parse_url(x, url);
				}
			else if (c == 'v') {
				if (verbose == 0)
					verbose = 1;
				else {
					verbose = 0;
					debug = 1;
					}
				}
			else if (c == 'y')
				x->passive = 1;
			else if (c == 'z') {
				if (k >= argc)
					missing_arg(c, "buffer size");

				x->bsize = atoi(argv[k++]);
				}
			else if (c == 'V') {
				printf ("%s %s\n", program, VERSION);
				exit (1);
				}
			else {
				fprintf (stderr, "%s: unknown option: -%c\n", program, c);
				exit (-1);
				}
			}
		}


	if (*x->server == 0) {
		if (k >= argc) {
			fprintf (stderr, "usage: %s [<options>] <server>\n", program);
			exit (1);
			}

		if (strncmp(argv[k], "ftp://", 6) != 0)
			copy_string(x->server, argv[k++], sizeof(x->server));
		else {
			char	url[300];

			copy_string(url, argv[k++], sizeof(url));
			parse_url(x, url);

			if (k < argc) {
				fprintf (stderr, "%s: unexpected arguments with url addressing\n", program);
				exit (1);
				}
			}
		}


	if (x->pipe != 0  &&  argc - k > 2) {
		fprintf (stderr, "%s: too much arguments for pipe mode\n", program);
		exit (1);
		}


	if (strcmp(x->username, "-") == 0) {
		if ((p = getenv("FTPC_AUTH")) != NULL)
			copy_string(x->username, p, sizeof(x->username));
		}

	if (*x->username == 0) {
		struct passwd *pw;

		if ((pw = getpwuid(getuid())) == NULL) {
			fprintf (stderr, "%s: can't get username\n", program);
			exit (1);
			}

		copy_string(x->username, pw->pw_name, sizeof(x->username));
		}


	if ((p = strchr(x->username, ':')) != NULL) {

		/*
		 * Passwort aus username Parameter holen ...
		 */

		*p++ = 0;
		copy_string(x->password, p, sizeof(x->password));
		}
	else if (ignorenetrc == 0) {

		/*
		 * ... ansonsten probieren wir die ~/.netrc
		 */

		read_netrc(x->server, x->username, x->password, sizeof(x->password));
		}


	if (*x->password == 0) {

		/*
		 * Password abfragen.  Um ein leeres Passwort anzugeben
		 * muss `-l <user:->' verwendet werden.
		 */

		p = getpass("password: ");
		copy_string(x->password, p, sizeof(x->password));
		}



	if (*urllocation != 0) {
		addfile(x, urllocation);
		
		argc = x->arg.argc;
		argv = x->arg.argv;
		}
	else if (k < argc  &&  strcmp(argv[k], "-") == 0) {

		/*
		 * Dateiliste von stdin lesen.
		 */

		char	line[200];

		if ((argc - k) > 1) {
			fprintf (stderr, "%s: too much arguments for file list mode\n", program);
			exit (1);
			}
		else if (x->pipe != 0) {
			fprintf (stderr, "%s: pipe mode is incompatible with file list\n", program);
			exit (1);
			}

		while (fgets(line, sizeof(line), stdin) != NULL) {
			p = skip_ws(noctrl(line));
			addfile(x, line);
			}

		argc = x->arg.argc;
		argv = x->arg.argv;
		}
	else {
		argc = argc - k;
		argv = &argv[k];
		}


	x->port = get_port(x->server, 21);
	ftp_request(x, command, argc, argv);

	exit (0);
}


