
/*

    File: ftp.h

    Copyright (C) 2000,2003,2004  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#ifndef	_FTP_INCLUDED
#define	_FTP_INCLUDED


extern char *program;
extern char progname[80];

extern int debug;
extern int extralog;

#define	MAXDIR		8
#define	MAXBSIZE	4096

typedef struct _ftp {
    char	server[200];
    unsigned int port;

    int		ndir;
    char	directory[MAXDIR][200];
    
    int		ascii;
    int		glob;
    int		pipe;
    int		passive;
    int		bsize;
    char	lsopt[40];

    int		autolist;
    char	outputfile[200];

    char	username[200];
    char	password[200];

    struct {
	char	username[80];
	char	password[80];
	} local;

    int			control;

    struct {
	int		fd;
	int		passive;
	char		interface[80];
	unsigned int	port;
	} data;

    struct {
	int		argc, argmax;
	char		**argv;
	} arg;
    } ftp_t;


extern int addfile(ftp_t *x, char *filename);
extern int ftp_request(ftp_t *x, char *command, int argc, char **argv);

#endif

