#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>

#include "candle.h"
#include "const.h"
#include "protos/memory.h"

/*
 * The functions for allocating and freeing memory.
 * CalAlloc guarantees memory initialized to only 0's,
 * CalFree is there for symmetry only
 */

void *CalMalloc (size_t size)
{
  void *ret = malloc (size)/*NPN_MemAlloc (size)*/;

  return ret;
}

void *CalCalloc (size_t nmemb, size_t size)
{
  void *ret = calloc (nmemb, size)/*NPN_MemAlloc (size)*/;

  return ret;
}

void CalFree (void *ptr)
{
  free/*NPN_MemFree*/ (ptr);
}

void *CalRealloc (void *ptr, size_t size)
{
  return realloc (ptr, size);
}




