#ifdef WIN32
#include <windows.h>
#endif

#include <stdio.h>

#ifdef MDEBUG
#include <malloc.h>

#define M1 0x5A43
#define M2 0x31BC
#define F1 0x2345
#define F2 0x6789
#define R1 0x4475

typedef struct _mdebug {
  int no;
  int error;
  struct _mdebug *next;
  struct _mdebug *prev;
  size_t len;
  char *file;
  int lineno;
  int m1;
  int m2;
} mdebug;

static struct _mdebug debugtail= {
  0,
  0,
  &debugtail,
  &debugtail,
  0,
  NULL,
  0,
  M1,
  M2,
};
static mdebug *debuglist=&debugtail;
static int debugno=0;

void DebugError(const char *file, int line, mdebug *dbf)
{
  if (dbf->error != R1)
  {
MessageBeep(0);
    fprintf(stderr, "DebugError: in module %s, line %d\n", file, line);
    fprintf(stderr, "   Object %d, size %d, allocated in module %s, line %d\n",
	dbf->no, dbf->len, dbf->file, dbf->lineno);
  }
  dbf->error = R1;
}


void DebugVerify(const char *file, int line, int mode)
{
  mdebug *dbf, *dbt;
  char *ptr;
  int *m;
  if (mode >= 1)
      fprintf(stderr, "Verify: %s, line %d\n", file, line);
  dbf = debuglist->next;
  while(dbf->no != 0)
  {
    ptr = (char *) dbf;
    dbt = (mdebug *) &ptr[dbf->len];
    if (dbf->m1 != M1 || dbt->m2 != M2)
      DebugError(file, line, dbf);
    if (mode == 2)
      fprintf(stderr, "%cMalloc: %5d byte in %s, line %d\n",
      dbf->error ? '?' : ' ', dbf->len, dbf->file, dbf->lineno);
    dbf = dbf->next;
  }
}

void *DebugMalloc(const char *file, int line, size_t size)
{
  mdebug *dbf, *dbt;
  char *ptr;
  int *m;
  DebugVerify(file, line, 0);
  ptr = (char *) (dbf = (mdebug *) calloc(size + sizeof(mdebug),1));
  if (dbf == NULL) return(NULL);
  dbt = (mdebug *) &ptr[size];
  dbf->no = ++debugno;
  dbf->next = debuglist;
  dbf->prev = debuglist->prev;
  (dbf->next)->prev = dbf;
  (dbf->prev)->next = dbf;
  dbf->len = size;
  dbf->file = (char *) file;
  dbf->lineno = line;
  dbf->m1 = M1;
  dbt->m2 = M2;
  return((void *) &(dbf->m2));
}

void *DebugCalloc(const char *file, int line, size_t nitems, size_t size)
{
  return(DebugMalloc(file, line, nitems*size));
}

void *DebugRealloc(const char *file, int line, void *block, size_t size)
{
  mdebug *dbf, *dbt;
  char *ptr, *nptr;
  int *m;
  DebugVerify(file, line, 0);
  ptr = (char *) block;
  dbf = (mdebug *) &ptr[sizeof(int)-sizeof(mdebug)];
  dbt = (mdebug *) &ptr[sizeof(int)-sizeof(mdebug)+dbf->len];
  if (dbf->m1 != M1 || dbt->m2 != M2)
    DebugError(file, line, dbf);
  dbf = (mdebug *) (nptr = (char *) realloc(dbf, size+sizeof(mdebug)));
  if (dbf == NULL) return(NULL);
  dbt = (mdebug *) &nptr[size];
  dbf->no = ++debugno;
  (dbf->next)->prev = dbf;
  (dbf->prev)->next = dbf;
  dbf->len = size;
  dbf->file = (char *) file;
  dbf->lineno = line;
  dbf->m1 = M1;
  dbt->m2 = M2;
  return((void *) &(dbf->m2));
}

void DebugFree(const char *file, int line, void *block)
{
  mdebug *dbf, *dbt;
  char *ptr;
  int *m;
  ptr = (char *) block;
  dbf = (mdebug *) &ptr[sizeof(int)-sizeof(mdebug)];
  dbt = (mdebug *) &ptr[sizeof(int)-sizeof(mdebug)+dbf->len];
  if (dbf->m1 != M1 || dbt->m2 != M2)
  {
    DebugError(file, line, dbf);
  } else {
    (dbf->next)->prev = dbf->prev;
    (dbf->prev)->next = dbf->next;
    free(dbf);
  }
  DebugVerify(file, line, 0);
}

#ifdef MDEBUG_TEST

#include "mdebug.h"

main(int argc, char *argv[])
{
  char *t1, *t2, *t3, *t4;
  printf("%s %d - %d\n", __FILE__, __LINE__, sizeof(size_t));
  t1 = malloc(14);
  t2 = malloc(24);
  t3 = malloc(34);
  t4 = malloc(44);
  t2 = realloc(t2, 54);
  verify(2);
  free(t2);
  t1 = malloc(64);
  free(t3);
  fprintf(stderr, "err\n");
  t1[64] = 4;
  free(t1);
  free(t4);
  verify(2);
  return(0);
}

#endif 

#endif
