/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 */

/*
 * Return pointer to buffer with the source of the current  unit.
 * Caller must deallocate buffer.
 */

#include <stdio.h>
#include <stdlib.h>

#include "candle.h"
#include "parser.h"
#include "wwwcom.h"
#include "sysproto.h"
#include "function.h"
#include "protos/fast_lis.h"
#include "protos/canutil.h"
#include "protos/simulate.h"
#include "protos/instance.h"
#include "protos/parser.h"
#include "protos/memory.h"

char *get_source(struct cw_status *gp)
{
  AweStream *as;
  char *url, *buf, *pbuf;
  int c, size=0;
  
  /*
   * Read current candle file into buf.
   */
  if(gp->curlunit){
    url = gp->curlunit->url;
    as = AweOpen(gp, gp->curlunit->url);
    if(as != NULL){
      buf = CalMalloc(2048 * sizeof(char) + 1);
      do {
		  pbuf = buf + size;
	c = AweRead(as, pbuf, 2048);
	size += c;
	
	if(c == 2048)
	  buf = CalRealloc(buf, size + 2048 + 1);
      } while(c == 2048);
      size += c;
      buf[size] = 0;
      AweClose(as);
    }
  } else 
    buf = strdup("No (awe) file is loaded.\n");

  return buf;
}

void goto_url(struct cw_status *gp, char *url)
{
  struct param par;
  struct oper op;

  gp->freeze_sim = FALSE;

#if (defined WIN31 || defined WIN32)
  ClearFrameBuffer();
#endif

  init_list(&par);
  par.line = -1;
  par.exp = &op;
  op.flag = TEXTVAL;
  op.left.text = url;
  compute_valtype(gp, &op);
  CalCall(gp, &par);
/*   free(url); */
}

void reload(struct cw_status *gp)
{
  int start = FALSE;
  AweStream *as;

  if(!gp->curlunit)
    return;

  if(gp->command == MAINLOOP)
    start = TRUE;
  
  gp->command |= RESTART_CALUNIT | RELOAD_CALUNIT;

  RemoveMapEntry(gp, gp->curlunit->url);
  as = AweOpen(gp, gp->curlunit->url);


  if(start && as != NULL){
    start_candle_unit(gp, as, gp->curlunit->url);
    killLearnUnit(gp);
    gp->command = MAINLOOP;
  }else if(as != NULL)
    gp->reload_as = as;
}    

void back(struct cw_status *gp)
{
  gp->command |= RETURN_CALUNIT;
}
