/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

/* All error messages are here */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#if (defined WIN31 || defined WIN32)
#include <windows.h>            // required for all Windows applications
#include <windowsx.h>
#endif

#include "candle.h"
#include "const.h"
#include "simulate.h"
#include "sysproto.h"
#include "protos/canutil.h"

/* Errors */

#ifdef UNIX
#undef STRDEF
#define STRDEF(a,b,c) char *a = c;
#include "error.def"
#include "error.sym"
#endif


void paramErrorDS (struct cw_status *gp, struct param FAR *par, char FAR *msg, long p1, char FAR *p2)
{
  char errormsg[256];
  char mess[256];
  sprintf(mess, msg, p1, p2);
  gp->command |= RETURN_ACTION;
  if(par != NULL)
    sprintf(errormsg, "Line %d: %s", par->line, mess);
  else
    sprintf(errormsg, "%s", mess);

#if (defined WIN31 || defined WIN32)

  MessageBox(0, errormsg, "Parameter error", MB_OK);
#else  
  fprintf(stderr, "%s\n",errormsg);
#endif
}

 

void paramError(struct cw_status *gp, struct param FAR *par, char FAR *msg)
{
  char errormsg[256];
  gp->command |= RETURN_ACTION;
  if(par != NULL)
    sprintf(errormsg, "Line %d: %s", par->line, msg);
  else
    sprintf(errormsg, "%s", msg);
#if (defined WIN31 || defined WIN32)
  MessageBox(0, errormsg, "Parameter error", MB_OK);
#else  
  fprintf(stderr, "%s\n",errormsg);
#endif
}

void errorMsg(struct cw_status *gp, int level, char FAR *msg)
{
  if(level == 1)
    gp->command |= RETURN_ACTION;
#if (defined WIN31 || defined WIN32)
  MessageBox(0, msg, "Error", MB_OK);
#else  
  fprintf(stderr, "%s\n",msg);
#endif
  if (level == 2) c_exit(gp, NOT_OK);
}

void userMsg(char FAR *msg)
{
#if (defined WIN31 || defined WIN32)
  MessageBox(0, msg, "Error", MB_OK);
#else  
  fprintf(stderr, "%s\n",msg);
#endif
}



