/* Copyright (c) 1995,1996 by Candleweb AS (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <malloc.h>
#ifdef UNIX
#include <unistd.h>
#include <signal.h>
#endif

#include "candle.h"
#include "error.h"
#include "learnuni.h"
#include "const.h"
#include "wwwcom.h"
#include "parser.h"
#include "fast_lis.h"
#include "nodes.h"
#include "function.h"

#include "protos/memory.h"

#ifdef AWETHOR
#include "awethor.h"
#endif

#include "sysproto.h"
#include "protos/instance.h"
#include "protos/readsim.h"
#include "protos/simulate.h"
#include "protos/freesim.h"
#include "protos/fast_lis.h"
#include "protos/parser.h"

#if (defined SOUNDSUPPORT && defined UNIX)
extern int seqfd, audio;
#endif

int start_candle_unit(struct cw_status *gp, AweStream *as, char *url)
{
  int firsttime = TRUE;

  do {
    if(firsttime || (gp->command & RELOAD_CALUNIT)){
      firsttime = FALSE;
      newLearnUnit (gp, DEFAULT_WIDTH, DEFAULT_HEIGHT, 
		    colorOfRGB (0x000000));
      gp->curlunit->url = strdup(url);
      if (!gp->parseOnly)
	setStatus (gp, "Parsing candle-file");
      gp->command = 0L;
      readsim (gp, as);
      AweClose(as);
    }
    if (gp->parseOnly) exit (0); /* No garbage collecting !! */

    setStatus (gp, "Starting simulation");
    start_sim (gp, gp->curlunit);
     setStatus (gp, "Simulation is done");
     if(gp->command & RELOAD_CALUNIT){
      killLearnUnit(gp);
      as = gp->reload_as;
     }
  } while (gp->command & RESTART_CALUNIT);
  return OK;
}

void AweCleanup(struct cw_status *gp)
{
  char tmpname[128];
  if(gp != NULL){
    if(!gp->firsttime)
      return;
    gp->firsttime = FALSE;

#ifdef SOUNDSUPPORT
    PlStop (gp, NULL);
    SndStop (gp, NULL);
#ifdef UNIX
    kill (gp->wavePid, SIGTERM);
    kill (gp->midiPid, SIGTERM);
    if (seqfd > 0) close (seqfd);
    if (audio > 0) close (audio);
#endif /* UNIX */
#endif /* SOUNDSUPPORT */

    while(gp->curlunit){
      killLearnUnit(gp);
    }
    parser_cleanup(gp);

    if(gp->err_file){
      strcpy(tmpname, gp->err_file);
      unlink(tmpname);
    }

    if(gp->imgcache){
      freeImage (gp, gp->imgcache);
      gp->imgcache = NULL;
    }
    CalFree(gp->rectspace);
    
    winsysCleanup(gp);
#ifdef AWETHOR
    awethor_free(gp);
#endif
  }
#ifdef WWWENABLE
  WWWFree();
#endif

}

#ifdef DEBUG
#define SEGFAULT
#else
#define SEGFAULT
#endif

/* Free the allocated resources and exit. Remember that 
 * we don't _always_ run under Unix.
 */
void c_exit(struct cw_status *gp, int ret_val) 
{
  AweCleanup(gp);
  if (ret_val == NOT_OK) SEGFAULT;
  exit(ret_val);
}

void l_exit(int sig) 
{
  AweCleanup(NULL);
  exit(sig);
}

void bibi(int sig)
{
  char mess[160];
  AweCleanup(NULL);
  sprintf(mess, ErrABNTERSIG, sig);
  errorMsg(NULL, 1, mess);
  abort();
}

/*
 * Return copy of the string s. 
 * Don't treat the empty string as an error.
 */
char FAR *safestrdup(char FAR *s)
{
  if(s != NULL)
    return strcpy(CalMalloc(strlen(s)+1), s);
  return NULL;
}

#ifndef PLUGIN
#ifndef STRICMP 
int stricmp(char FAR *s1, char FAR *s2)
{
  while(*s1 && *s2){
    if(tolower(*s1) < tolower(*s2))
      return -1;
    else if(tolower(*s1) > tolower(*s2))
      return 1;
    s1++;
    s2++;
  }
  if(*s1 == 0) return -1;
  if(*s2 == 0) return 1;
  return 0;
}
#endif /* STRICMP */
#endif /* PLUGIN */


