/*
 * April 15, 1992
 * Copyright 1992 Rick Richardson
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

/*
 * Windows 3.0 .wav format driver
 */

#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include "st.h"
#include "protos.h"

/* Private data for .wav file */
typedef struct wavstuff {
	long	samples;
} *wav_t;

extern float volume, amplitude;
extern long summary, verbose;

/*
 * Do anything required before you start reading samples.
 * Read file header. 
 *	Find out sampling rate, 
 *	size and style of samples, 
 *	mono/stereo/quad.
 */
void wavstartread(gp, ft) 
struct cw_status *gp;
ft_t ft;
{
	wav_t	wav = (wav_t) ft->priv;
	char	magic[4];
	long	len;

	read (ft->fp, magic, 4);
	if (strncmp("RIFF", magic, 4))
		fail(gp, "Not a RIFF file");

	len = rllong(gp, ft);

	read(ft->fp, magic, 4);
	if (strncmp("WAVE", magic, 4))
		fail(gp, "Not a WAVE file");

	read(ft->fp, magic, 4);
	if (strncmp("fmt ", magic, 4))
		fail(gp, "Missing fmt spec");

	len = rllong(gp, ft);
	switch (rlshort(gp, ft))
	{
	case 1:		ft->info.style = UNSIGNED; break;
	default:	fail(gp, "Don't understand format");
	}
	ft->info.channels = rlshort(gp, ft);
	ft->info.rate = rllong(gp, ft);
	rllong(gp, ft);	/* Average bytes/second */
	rlshort(gp, ft);	/* Block align */
	switch (rlshort(gp, ft))
	{
	case 8:		ft->info.size = ST_BYTE; break;
	case 16:	ft->info.size = ST_WORD; break;
	case 32:	ft->info.size = ST_LONG; break;
	default:	fail(gp, "Don't understand size");
	}
	len -= 16;
	/* What is this good for: while (len) getc(ft->fp); ??? */

	read(ft->fp, magic, 4);
	if (strncmp("data", magic, 4))
		fail(gp, "Missing data portion");

	wav->samples = rllong(gp, ft);
}

/*
 * Read up to len samples from file.
 * Convert to signed longs.
 * Place in buf[].
 * Return number of samples read.
 */

int wavread(gp, ft, buf, len) 
struct cw_status *gp;
ft_t ft;
long *buf, len;
{
	wav_t	wav = (wav_t) ft->priv;
	int	done;

	if (len > wav->samples) len = wav->samples;
	if (len == 0) return 0;
	done = rawread(gp, ft, buf, len);
	wav->samples -= len;
	return done;
}

/*
 * Do anything required when you stop reading samples.  
 * Don't close input file! 
 */
void wavstopread(gp, ft) 
struct cw_status *gp;
ft_t ft;
{
}


