/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

#include "protos.h"
#include "st.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

int strcmpcase(s1, s2)
char *s1, *s2;
{
	while(*s1 && *s2 && (tolower(*s1) == tolower(*s2)))
		s1++, s2++;
	return *s1 - *s2;
}

void init(struct cw_status *gp, ft_t informat) {

	/* init files */
	informat->info.rate = 0.0;
	informat->info.size = -1;
	informat->info.style = -1;
	informat->info.channels = -1;
	informat->swap      = 0;
	informat->filetype  = (char *) 0;
	/*	informat->fp        = stdin; */
	informat->filename  = "input";
}

/*
 * Check that we have a known format suffix string.
 */
void
gettype(gp, formp)
struct cw_status *gp;
ft_t formp;
{
	char **list;
	int i;
	extern format_t formats[];

	if (! formp->filetype)
fail(gp, "Must give file type for %s file, either as suffix or with -t option",
formp->filename);
	for(i = 0; formats[i].names; i++) {
		for(list = formats[i].names; *list; list++) {
			char *s1 = *list, *s2 = formp->filetype;
			if (! strcmpcase(s1, s2))
				break;	/* not a match */
		}
		if (! *list)
			continue;
		/* Found it! */
		formp->h = &formats[i];
		return;
	}
	if (! strcmpcase(formp->filetype, "snd")) {
	  /*		verbose = 1;
		report("File type '%s' is used to name several different formats.", formp->filetype);
		report("If the file came from a Macintosh, it is probably");
		report("a .ub file with a sample rate of 11025 (or possibly 5012 or 22050).");
		report("Use the sequence '-t .ub -r 11025 file.snd'");
		report("If it came from a PC, it's probably a Soundtool file.");
		report("Use the sequence '-t .sndt file.snd'");
		report("If it came from a NeXT, it's probably a .au file.");
		fail("Use the sequence '-t .au file.snd'\n"); */
	}
	fail(gp, "File type '%s' of %s file is not known!",
	     formp->filetype, formp->filename);
}

void cmpformats(gp, ft, ft2)
ft_t ft, ft2;
{
}

/* check that all settings have been given */
void checkformat(gp, ft) 
struct cw_status *gp;
ft_t ft;
{
	if (ft->info.rate == 0.0)
		fail(gp, "Sampling rate for %s file was not given\n", ft->filename);
	if ((ft->info.rate < 100) || (ft->info.rate > 50000))
		fail(gp, "Sampling rate %d for %s file is bogus\n", 
			ft->info.rate, ft->filename);
	if (ft->info.size == -1)
		fail(gp, "Data size was not given for %s file\nUse one of -b/-w/-l/-f/-d/-D", ft->filename);
	if (ft->info.style == -1)
		fail(gp, "Data style was not given for %s file\nUse one of -s/-u/-U/-A", ft->filename);
	/* it's so common, might as well default */
	if (ft->info.channels == -1)
		ft->info.channels = 1;
	/*	fail("Number of output channels was not given for %s file",
			ft->filename); */
}

int filetype(gp, fd)
struct cw_status *gp;
int fd;
{
	struct stat st;

	fstat(fd, &st);

	return st.st_mode & S_IFMT;
}

void
report(struct cw_status *gp, char *s, ...) 
{
}

void fail(struct cw_status *gp, char *s, ...)
{
	va_list args;
	char *fmt;

	va_start(args, s);
	fmt = va_arg(args, char *);
	vfprintf(stderr, fmt, args);
	va_end(args);
	fprintf(stderr, "\n");
	exit(2);
}

