/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

/*
 * Sound Tools miscellaneous stuff.
 */

#include "protos.h"
#include <sys/types.h>
#include <unistd.h>


char *sizes[] = {
	"NONSENSE!",
	"bytes",
	"shorts",
	"longs",
	"32-bit floats",
	"64-bit floats",
	"ST_IEEE floats"
};

char *styles[] = {
	"NONSENSE!",
	"unsigned",
	"signed (2's complement)",
	"u-law",
	"a-law"
};

char readerr[] = "Premature EOF while reading sample file.";
char writerr[] = "Error writing sample file.  You are probably out of disk space.";

#include "st.h"

/* Utilities */

/* Read short, little-endian: little end first. VAX/386 style. */
unsigned short
rlshort(gp, ft)
struct cw_status *gp;
ft_t ft;
{
	unsigned char uc, uc2;
	read (ft->fp, &uc, 1);
	read (ft->fp, &uc2, 1);
	return (uc2 << 8) | uc;
}

/* Read short, bigendian: big first. 68000/SPARC style. */
unsigned short
rbshort(gp, ft)
struct cw_status *gp;
ft_t ft;
{
	unsigned char uc, uc2;
	read (ft->fp, &uc, 1);
	read (ft->fp, &uc2, 1);
	return (uc2 << 8) | uc;
}

/* Write short, little-endian: little end first. VAX/386 style. */
#ifdef CANDLEWEBNEEDSTOWRITE
unsigned short
wlshort(gp, ft, us)
struct cw_status *gp;
ft_t ft;
unsigned int us;
{
	putc(us, ft->fp);
	putc(us >> 8, ft->fp);
	if (ferror(ft->fp))
		fail(gp, writerr);
	return 0;
}

/* Write short, big-endian: big end first. 68000/SPARC style. */
unsigned short
wbshort(gp, ft, us)
struct cw_status *gp;
ft_t ft;
unsigned int us;
{
	putc(us >> 8, ft->fp);
	putc(us, ft->fp);
	if (ferror(ft->fp))
		fail(gp, writerr);
	return 0;
}
#endif /* CANDLEWEBNEEDTOWRITE */

/* Read long, little-endian: little end first. VAX/386 style. */
unsigned long
rllong(gp, ft)
struct cw_status *gp;
ft_t ft;
{
	unsigned char uc, uc2, uc3, uc4;
	read (ft->fp, &uc, 1);
	read (ft->fp, &uc2, 1);
	read (ft->fp, &uc3, 1);
	read (ft->fp, &uc4, 1);
	return ((long)uc4 << 24) | ((long)uc3 << 16) | ((long)uc2 << 8) | (long)uc;
}

/* Read long, bigendian: big first. 68000/SPARC style. */
unsigned long
rblong(gp, ft)
struct cw_status *gp;
ft_t ft;
{
	unsigned char uc, uc2, uc3, uc4;
	read (ft->fp, &uc, 1);
	read (ft->fp, &uc2, 1);
	read (ft->fp, &uc3, 1);
	read (ft->fp, &uc4, 1);
	return ((long)uc << 24) | ((long)uc2 << 16) | ((long)uc3 << 8) | (long)uc4;
}

#ifdef CANDLEWEBNEEDSTOWRITE
/* Write long, little-endian: little end first. VAX/386 style. */
unsigned long
wllong(gp, ft, ul)
struct cw_status *gp;
ft_t ft;
unsigned long ul;
{
int datum;

	datum = (ul) & 0xff;
	putc(datum, ft->fp);
	datum = (ul >> 8) & 0xff;
	putc(datum, ft->fp);
	datum = (ul >> 16) & 0xff;
	putc(datum, ft->fp);
	datum = (ul >> 24) & 0xff;
	putc(datum, ft->fp);
	if (ferror(ft->fp))
		fail(gp, writerr);
	return 0;
}

/* Write long, big-endian: big end first. 68000/SPARC style. */
unsigned long
wblong(gp, ft, ul)
struct cw_status *gp;
ft_t ft;
unsigned long ul;
{
int datum;

	datum = (ul >> 24) & 0xff;
	putc(datum, ft->fp);
	datum = (ul >> 16) & 0xff;
	putc(datum, ft->fp);
	datum = (ul >> 8) & 0xff;
	putc(datum, ft->fp);
	datum = (ul) & 0xff;
	putc(datum, ft->fp);
	if (ferror(ft->fp))
		fail(gp, writerr);
	return 0;
}
#endif /* CANDLEWEBNEEDTOWRITE */

/* Read and write words and longs in "machine format".  Swap if indicated. */

/* Read short. */
unsigned short
rshort(gp, ft)
struct cw_status *gp;
ft_t ft;
{
	unsigned short us;

	read(ft->fp, &us, 2);
	if (ft->swap)
	  us = swapw(gp, us);
	return us;
}

#ifdef CANDLEWEBNEEDSTOWRITE
/* Write short. */
unsigned short
wshort(gp, ft, ui)
struct cw_status *gp;
ft_t ft;
unsigned int ui;
{
	unsigned short us;
	us = ui;
	if (ft->swap)
		us = swapw(gp, us);
	if (fwrite(&us, 2, 1, ft->fp) != 1)
		fail(gp, writerr);
	return 0;
}
#endif /* CANDLEWEBNEEDSTOWRITE */

/* Read long. */
unsigned long
rlong(gp, ft)
struct cw_status *gp;
ft_t ft;
{
	unsigned long ul;

	read(ft->fp, &ul, 4);
	if (ft->swap)
		ul = swapl(gp, ul);
	return ul;
}

#ifdef CANDLEWEBNEEDSTOWRITE
/* Write long. */
unsigned long
wlong(gp, ft, ul)
struct cw_status *gp;
ft_t ft;
unsigned long ul;
{
	if (ft->swap)
		ul = swapl(gp, ul);
	if (fwrite(&ul, 4, 1, ft->fp) != 1)
		fail(gp, writerr);
	return 0;
}
#endif /* CANDLEWEBNEEDSTOWRITE */

/* Byte swappers */

unsigned short
swapw(gp, us)
struct cw_status *gp;
unsigned int us;
{
	return ((us >> 8) | (us << 8)) & 0xffff;
}

unsigned long
swapl(gp, ul)
struct cw_status *gp;
unsigned long ul;
{
	return (ul >> 24) | ((ul >> 8) & 0xff00) | ((ul << 8) & 0xff0000) | (ul << 24);
}

/* dummy routine for do-nothing functions */
int nothing(struct cw_status *gp) {return 0;}

/* dummy drain routine for effects */
void null_drain(gp, effp, obuf, osamp)
struct cw_status *gp;
eff_t effp;
long *obuf;
long *osamp;
{
	*osamp = 0;
}

/* here for linear interp.  might be useful for other things */
int gcd(gp, a, b) 
struct cw_status *gp;
long a, b;
{
	if (b == 0)
		return a;
	else
		return gcd(b, a % b);
}

int lcm(gp, a, b) 
struct cw_status *gp;
long a, b;
{
	return (a * b) / gcd(a, b);
}

/* sine wave gen should be here, also */
