/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

#include "st.h"

/*
 * Sound Tools file format and effect tables.
 */

/* File format handlers. */

char *rawnames[] = {
	"raw",
/*	"sou",  */
	(char *) 0
};
extern rawstartread(), rawread();

char *vocnames[] = {
	"voc",
	(char *) 0
};
extern vocstartread(), vocread(), vocstopread();
extern vocstartwrite(), vocwrite(), vocstopwrite();

char *aunames[] = {
	"au",
#ifdef	NeXT
	"snd",
#endif
	(char *) 0
};
extern austartread();

char *aiffnames[] = {
	"aiff",
	"aif",
	(char *) 0
};
extern aiffstartread(), aiffread(), aiffstopread();

char *svxnames[] = {
	"8svx",
	"iff",
	(char *) 0
};
extern svxstartread(), svxread(), svxstopread();

char *hcomnames[] = {
	"hcom",
	(char *) 0
};
extern hcomstartread(), hcomread(), hcomstopread();

char *sndtnames[] = {
	"sndt",
#ifdef	DOS
	"snd",
#endif
	(char *) 0
}; 
extern sndtstartread();

char *sndrnames[] = {
	"sndr",
	(char *) 0
};

char *ubnames[] = {
	"ub",
	"sou",
	"fssd",
#ifdef	MAC
	"snd",
#endif
	(char *) 0
};
extern ubstartread();
/*
char *sbnames[] = {
	"sb",
	(char *) 0
};
extern sbstartread();
extern sbstartwrite();
*/
char *uwnames[] = {
	"uw",
	(char *) 0
};
extern uwstartread();

char *swnames[] = {
	"sw",
	(char *) 0
};
extern swstartread();

char *ulnames[] = {
	"ul",
	(char *) 0
};
extern ulstartread();


char *sfnames[] = {
	"sf",
	(char *) 0
};
extern sfstartread();

char *wavnames[] = {
	"wav",
	(char *) 0
};
extern wavstartread(), wavread();

#ifdef	i386
/*
char *sbdspnames[] = {
	"sbdsp",
	(char *) 0
};
extern sbdspstartread(), sbdspread(), sbdspstopread();
extern sbdspstartwrite(), sbdspwrite(), sbdspstopwrite(); */
#endif

extern nothing();

format_t formats[] = {
	{rawnames, rawstartread, rawread, nothing, 	/* Raw format */
		nothing, nothing, nothing},
	{vocnames, nothing, nothing, nothing,  /* Sound Blaster .VOC */
		nothing, nothing, nothing},
	{aunames, austartread, rawread, nothing, 	/* SPARC .AU w/header */
		nothing, nothing, nothing},	
	{ubnames, ubstartread, rawread, nothing, 	/* unsigned ST_BYTE raw */
		nothing, nothing, nothing},	/* Relies on raw */
	/*
	{sbnames, sbstartread, rawread, nothing,     
		sbstartwrite, rawwrite, nothing},	*/

	{uwnames, uwstartread, rawread, nothing, 	/* unsigned ST_WORD raw */
		nothing, nothing, nothing},	
	{swnames, swstartread, rawread, nothing, 	/* signed ST_WORD raw */
		nothing, nothing, nothing},
	{ulnames, ulstartread, rawread, nothing, 	/* u-law ST_BYTE raw */
		nothing, nothing, nothing},	
	{aiffnames, nothing, nothing, nothing,    /* SGI/Amiga AIFF */
		nothing, nothing, nothing},
	{svxnames, nothing, nothing, nothing,      /* Amiga 8SVX */
		nothing, nothing, nothing},
	{hcomnames, nothing, nothing, nothing, /* Mac FSSD/HCOM */
		nothing, nothing, nothing},
	{sfnames, nothing, nothing, nothing, 	/* IRCAM Sound File */
		nothing, nothing, nothing},	/* Relies on raw */
	{sndtnames, nothing, nothing, nothing,    /* Sndtool Sound File */
		nothing, nothing, nothing},
	{sndrnames, nothing, rawread, nothing,    /* Sounder Sound File */
		nothing, nothing, nothing},
	{wavnames, wavstartread, wavread, nothing, 	/* Windows 3.0 .wav */
		nothing, nothing, nothing},	
#ifdef	i386
	/* Unix/386 sound blaster player.  No more of these, please! */
	/*	{sbdspnames, sbdspstartread, sbdspread, sbdspstopread,
		sbdspstartwrite, sbdspwrite, sbdspstopwrite},	*/
#endif
	0
};


