/************************************************************************
   playmidi.c -- last change: 1 Jan 96

   Plays a MIDI file to any supported synth (including midi) device

   Copyright (C) 1994-1996 Nathan I. Laredo

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Send your comments and all your spare pocket change to
   laredo@gnu.ai.mit.edu (Nathan Laredo) or to PSC 1, BOX 709, 2401
   Kelly Drive, Lackland AFB, TX 78236-5128, USA.
 *************************************************************************/
#include <getopt.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/stat.h>
#include "playmidi.h"

SEQ_DEFINEBUF(SEQUENCERBLOCKSIZE);

#ifdef PLAY_FM
int play_fm = 0xffff, play_gus = 0, play_ext = 0;
#endif
#ifdef PLAY_GUS
int play_fm = 0, play_gus = 0xffff, play_ext = 0;
#endif
#ifdef PLAY_MIDI
int play_fm = 0, play_gus = 0, play_ext = 0xffff;
#endif

struct miditrack seq[MAXTRKS];

int verbose = 0, chanmask = 0xffff, perc = PERCUSSION;
int dochan = 1, force8bit = 0, wantopl3 = FM_DEFAULT_MODE;
int patchloaded[256], fmloaded[256], useprog[16], usevol[16];
int graphics = 0, reverb = 0, chorus = 0, nrsynths, nrmidis;
int sb_dev = -1, gus_dev = -1, ext_dev = -1, p_remap = 0;
int seqfd, mfd, find_header = 0, MT32 = 0;
int FORCE_EXT_DEV = DEFAULT_MIDI_DEV;
unsigned long int default_tempo;
char *filename;
float skew = 1.0;
extern int ntrks;
extern char *gmvoice[256];
extern int mt32pgm[128];
extern int playevents();
extern int gus_load(int);
extern int readmidi(unsigned char *, off_t);
extern void loadfm();

void setup_show()
{

}

void init_show ()
{

}

void close_show()
{

}

void updatestatus ()
{

}

void showevent ()
{

}

struct synth_info card_info[MAX_CARDS];
void synth_setup()
{
#ifdef ULTRA_DRIVER
    gus_dev = 0;
    sb_dev = -1;
    ext_dev = -1;
    play_ext = 0;
    play_fm = 0;
    play_gus = 0xffff;
#else
    int i;

    if (ioctl(seqfd, SNDCTL_SEQ_NRSYNTHS, &nrsynths) == -1) {
	fprintf(stderr, "there is no soundcard\n");
	exit(-1);
    }
    for (i = 0; i < nrsynths; i++) {
	card_info[i].device = i;
	if (ioctl(seqfd, SNDCTL_SYNTH_INFO, &card_info[i]) == -1) {
	    fprintf(stderr, "cannot get info on soundcard\n");
	    perror(SEQUENCER_DEV);
	    exit(-1);
	}
	card_info[i].device = i;
	if (card_info[i].synth_type == SYNTH_TYPE_SAMPLE
	    && card_info[i].synth_subtype == SAMPLE_TYPE_GUS)
	    gus_dev = i;
	else if (card_info[i].synth_type == SYNTH_TYPE_FM) {
	    sb_dev = i;
	    if (play_fm)
		loadfm();
	    if (wantopl3)
		card_info[i].nr_voices = 12;	/* we have 12 with 4-op */
	}
    }

    if (gus_dev >= 0) {
	if (ioctl(seqfd, SNDCTL_SEQ_RESETSAMPLES, &gus_dev) == -1) {
	    perror("Sample reset");
	    exit(-1);
	}
    }
    if (ioctl(seqfd, SNDCTL_SEQ_NRMIDIS, &nrmidis) == -1) {
	fprintf(stderr, "can't get info about midi ports\n");
	exit(-1);
    }
    if (nrmidis > 0) {
	if (FORCE_EXT_DEV >= 0)
	    ext_dev = FORCE_EXT_DEV;
	else
	    ext_dev = nrmidis - 1;
    }
    if (!play_gus)
	gus_dev = -1;
    if (!play_fm)
	sb_dev = -1;
    if (!play_ext)
	ext_dev = -1;
    if (ext_dev < 0)
	play_ext = 0;
    if (sb_dev < 0)
	play_fm = 0;
    if (gus_dev < 0)
	play_gus = 0;
#endif
}

void seqbuf_dump()
{
    if (_seqbufptr)
	if (write(seqfd, _seqbuf, _seqbufptr) == -1) {
	    perror("write " SEQUENCER_DEV);
	    exit(-1);
	}
    _seqbufptr = 0;
}

int hextoi(s)
char *s;
{
    int i, j, k, l;

    j = 0;
    k = strlen(s);
    for (i = 0; i < k; i++) {
	l = toupper(s[i]);
	if (l > 64 && l < 71)
	    j += (l - 55) << ((k - i - 1) * 4);
	else if (l > 47 && l < 58)
	    j += (l - 48) << ((k - i - 1) * 4);
	else if (l != 88) {
	    fprintf(stderr, "invalid character in hexidecimal mask\n");
	    exit(1);
	}
    }
    if (j < 0 || j > 0xffff) {
	fprintf(stderr, "mask must be between 0 and ffff hexidecimal\n");
	exit(1);
    }
    return j;

}

void playmidi (char *filebuf, int fblen)
{
  int error = 0, i, j, newprog;
  struct stat info;

  do {
    if (play_gus)
      gus_load(-1);
    default_tempo = 500000;
    /* error holds number of tracks read */
    error = readmidi(filebuf, info.st_size);
    if (play_gus && error > 0) {
      int i;		/* need to keep other i safe */
#define CMD (seq[i].data[j] & 0xf0)
#define CHN (seq[i].data[j] & 0x0f)
#define PGM (seq[i].data[j + 1])
      /* REALLY STUPID way to preload GUS, but it works */
      for (i = 0; i < ntrks; i++)
	for (j = 0; j < seq[i].length - 5; j++)
	  if (ISGUS(CHN) && !(PGM & 0x80) &&
	      ((CMD == MIDI_PGM_CHANGE && !ISPERC(CHN))
	       || (CMD == MIDI_NOTEON && ISPERC(CHN))))
	    gus_load(ISPERC(CHN) ? PGM + 128 :
		     useprog[CHN] ? useprog[CHN] - 1 :
		     MT32 ? mt32pgm[PGM] : PGM);
      /* make sure that some program was loaded to use */
      for (j = 0; patchloaded[j] != 1 && j < 128; j++);
      if (j > 127)
	gus_load(0);
    }
    newprog = 1;	/* if there's an error skip to next file */
    if (error > 0)	/* error holds number of tracks read */
      while ((newprog = playevents()) == 0);
    if (find_header)	/* play headers following selected */
      find_header += newprog;
  } while (find_header);
}
/* end of file */





