/*
 * This file holds the needed stuff from everywhere in the CandleWeb code
 */

//#include "npapi.h"

#include <X11/Intrinsic.h>
#include <X11/Xcms.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <values.h>
#include <assert.h>

//#include "sysdep.h"
#include "candle.h"
#include "nodes.h"
#include "graphic.h"
#include "stuff.h"
#include "error.h"
#include "lex.h"
#include "pbmplus.h"

#include "protos/fast_lis.h"
#include "protos/canutil.h"
#include "protos/update.h"
#include "protos/memory.h"

void drawInitial ()
{

}

void setStatus ()
{

}

void freeImage ()
{

}

void setURL ()
{

}

CalImage *getImage (struct cw_status *gp, char *URL)
{
    return &gp->imgcache->img;
}

void changeColEntry ()
{

}

void regcomp ()
{

}

void regexec ()
{

}

void initDefImg ()
{

}

void makeGUI ()
{

}

void message (char *m, ...)
{
  va_list args;
  FILE *fp = fopen ("awelog", "a");
  if (fp) {
    va_start (args, m);
    vfprintf (fp, m, args);
    va_end (args);
    fclose (fp);
  }
}

//void __eprintf ()
//{
//  return;
//}

/*
 * From X/athena/GUI.c
 */

void CalSync(struct cw_status *gp)
{
  XSync (gp->system.dpy, 0); /* Improves response time drastically */
}

/*
 * From X/display.c:
 */

/* The rasters used to emulate colors on black-and-white displays */

static char rast0_bits[] = {
   0x00, 0x00, 0x00, 0x00};
static char rast1_bits[] = {
   0x00, 0x02, 0x00, 0x00};
static char rast2_bits[] = {
   0x00, 0x02, 0x00, 0x08};
static char rast3_bits[] = {
   0x00, 0x0a, 0x00, 0x08};
static char rast4_bits[] = {
   0x00, 0x0a, 0x00, 0x0a};
static char rast5_bits[] = {
   0x04, 0x0a, 0x00, 0x0a};
static char rast6_bits[] = {
   0x04, 0x0a, 0x01, 0x0a};
static char rast7_bits[] = {
   0x05, 0x0a, 0x01, 0x0a};
static char rast8_bits[] = {
   0x05, 0x0a, 0x05, 0x0a};
static char rast9_bits[] = {
   0x0d, 0x0a, 0x05, 0x0a};
static char rast10_bits[] = {
   0x0d, 0x0a, 0x07, 0x0a};
static char rast11_bits[] = {
   0x0f, 0x0a, 0x07, 0x0a};
static char rast12_bits[] = {
   0x0f, 0x0a, 0x0f, 0x0a};
static char rast13_bits[] = {
   0x0f, 0x0a, 0x0f, 0x0e};
static char rast14_bits[] = {
   0x0f, 0x0b, 0x0f, 0x0e};
static char rast15_bits[] = {
   0x0f, 0x0b, 0x0f, 0x0f};
static char rast16_bits[] = {
   0x0f, 0x0f, 0x0f, 0x0f};

char *rastptr[MAXRAST] = {
  rast0_bits, rast1_bits, rast2_bits, rast3_bits,
  rast4_bits, rast5_bits, rast6_bits, rast7_bits,
  rast8_bits, rast9_bits, rast10_bits, rast11_bits,
  rast12_bits, rast13_bits, rast14_bits, rast15_bits,
  rast16_bits
};

extern const unsigned char defpicdata[];

void installPalette (struct cw_status *gp)
{
  register double bestbadness, colbadness;
  int i, j, bestind, n;
  float  cx, cy, cz;
  XColor def_col[MAXCOLS], exact_def[MAXCOLS];
  char usedCol[MAXCOLS];
  unsigned char *src = defpicdata, *dst;
  unsigned long pixels[MAXCOLS];
  
  /* Fill default-colors with pixel-values */
  for(i=0; i<MAXCOLS; i++) {
      awe_system.color[i].color.pixel = def_col[i].pixel = exact_def[i].pixel = i;
      usedCol[i] = FALSE;
      def_col[i].flags = DoRed | DoGreen | DoBlue;
      awe_system.color[i].color.format = XcmsRGBFormat;
  }
  /* Fill def_col-array with color values of default colormap */
  if (gp->system.depth == 8) {
    /* Perfect or adapted, get current colors in order to mess up
       as little as possible */
    XQueryColors (XtDisplay (gp->system.topLevel),
		  DefaultColormapOfScreen (XtScreen (gp->system.topLevel)),
		  def_col, MAXCOLS);

    if (gp->system.colorModel == PSEUDO8ADAPTED) {
      /* Allocate as many as possible into pixels */
      for (n = 0; n < MAXCOLS
	     && XAllocColorCells (XtDisplay (gp->system.topLevel),
				  DefaultColormapOfScreen (XtScreen (gp->system.topLevel)),
				  FALSE, NULL, 0, &pixels[n], 1); n++);
      /* Find the allocated pixels */
      for (i = 0; i < MAXCOLS; i++) {
	for (j = 0; j < n && pixels[j] != i; j++);
	if (j < n) continue;
	/* i is an allocated pixel */
	
	cx = def_col[i].red;
	cy = def_col[i].green;
	cz = def_col[i].blue;
	/* Find the best fitting color in the CIE-palette for this color */
	bestbadness = MAXFLOAT;
	for (j = 0; j < MAXCOLS; j++)
	  if (!usedCol[j]
	      && (colbadness =
		  (double)(YIQ11*YIQ11)
		  *(double)(((j&0xE0)+0x10-cx)*((j&0xE0)+0x10-cx))
		  +(double)(YIQ12*YIQ12)
		  *(double)((((j&0x1C)<<3)+0x10-cy)*(((j&0x1C)<<3)+0x10-cy))
		  +(double)(YIQ13*YIQ13)
		  *(double)((((j&0x03)<<6)+0x20-cz)*(((j&0x03)<<6)+0x20-cz)))
	  < bestbadness) {
	    bestbadness = colbadness; bestind = j;
	  }
	usedCol[bestind] = TRUE;
	
	awe_system.color[i].color.spec.RGB.red = cx;
	awe_system.color[i].color.spec.RGB.green = cy;
	awe_system.color[i].color.spec.RGB.blue = cz;
	awe_system.color[i].color.pixel = i;
      }
      /* Matched the used colors to the best ones in CIEpal,
	 now write the rest to the previously allocated entries */
      j = 0;
      for (i = 0; i < MAXCOLS; i++) {
	if (!usedCol[i]) {
	  assert ((usedCol[i] = TRUE));
	  awe_system.color[pixels[j]].color.spec.RGB.red = (i&0xE0)+0x10;
	  awe_system.color[pixels[j]].color.spec.RGB.green = ((i&0x1C)<<3)+0x10;
	  awe_system.color[pixels[j]].color.spec.RGB.blue = ((i&0x03)<<6)+0x20;
	  /* And, just in case */
	  awe_system.color[pixels[j]].color.pixel = pixels[j];

	  XcmsStoreColor (XtDisplay (gp->system.topLevel), 
			  DefaultColormapOfScreen (XtScreen (gp->system.topLevel)),
		       &awe_system.color[pixels[j]].color);
	  j++; /* Index of next candle-allocated pixel */
	}
      }
    }
    else if (gp->system.colorModel == PSEUDO8PERFECT) {
      for (i = 0; i < MAXCOLS; i++) {
	cx = def_col[i].red;
	cy = def_col[i].green;
	cz = def_col[i].blue;
	/* Find the best fitting color in the CIE-palette for this color */
	bestbadness = MAXFLOAT;
	for (j = 0; j < MAXCOLS; j++)
	  if (!usedCol[j]
	      && (colbadness =
		  (double)(YIQ11*YIQ11)
		  *(double)(((j&0xE0)+0x10-cx)*((j&0xE0)+0x10-cx))
		  +(double)(YIQ12*YIQ12)
		  *(double)((((j&0x1C)<<3)+0x10-cy)*(((j&0x1C)<<3)+0x10-cy))
		  +(double)(YIQ13*YIQ13)
		  *(double)((((j&0x03)<<6)+0x20-cz)*(((j&0x03)<<6)+0x20-cz)))
	  < bestbadness) {
	    bestbadness = colbadness; bestind = j;
	  }
	usedCol[bestind] = TRUE;
	
	awe_system.color[i].color.spec.RGB.red = exact_def[i].red =
	  (bestind&0xE0)+0x10;
	awe_system.color[i].color.spec.RGB.green = exact_def[i].green =
	  ((bestind&0x1C)<<3)+0x10;
	awe_system.color[i].color.spec.RGB.blue = exact_def[i].blue =
	  ((bestind&0x03)<<6)+0x20;

	awe_system.color[bestind].color.pixel = i;
      }
      XStoreColors (XtDisplay (gp->system.topLevel),
		    gp->system.colormap, exact_def, MAXCOLS);
    }
  }
  if (!gp->defpic)
    gp->defpic = (unsigned char *)CalMalloc (DEFPICWIDTH*DEFPICHEIGHT);
  if ((dst = gp->defpic))
    for (i = 0; i < DEFPICHEIGHT; i++)
      for (j = 0; j < DEFPICWIDTH; j++) {
	n = *(src++);
	*(dst++) =
	  colorOfRGB (gp, ((n&0xE0)<<16)|((n&0x1C)<<11)|((n&0x03)<<6))&0xFF;
      }
}

void makeColors (struct cw_status *gp)
{
  int r, g, b, i;

  gp->system.colormap =
    DefaultColormapOfScreen (XtScreen (gp->system.topLevel));

  switch (gp->system.colorModel) {
  case GRAY1:
/*
 * Black-and-white :
 * awe_system.color is filled with 17 values used as an index into rastptr
 */
    i = 0;
    for (r = 0; r < 8; r++)
      for (g = 0; g < 8; g++)
	for (b = 0; b < 4; b++)
	  awe_system.color[i++].color.pixel = (int)
	    ((((float)r*YIQ11/7.0+(float)g*YIQ12/7.0+(float)b*YIQ13/3.0)
	      *MAXRAST)+.5);
    awe_system.color[MAXCOLS-1].color.pixel = MAXRAST-1;
    break;
  case GRAY4:
/* 16 color Grayscale */
    i = 0;
    for (r = 0; r < 8; r++)
      for (g = 0; g < 8; g++)
	for (b = 0; b < 4; b++)
	  awe_system.color[i++].color.pixel = (int)
	    ((((float)r*YIQ11/7.0+(float)g*YIQ12/7.0+(float)b*YIQ13/3.0)*16)+.5);
    awe_system.color[MAXCOLS-1].color.pixel = 15;
    break;
  case PSEUDO8PERFECT:
/* 256 colors pseudocolor */
    gp->system.colormap =
      XCreateColormap (XtDisplay (gp->system.topLevel),
		       RootWindowOfScreen (XtScreen (gp->system.topLevel)),
		       gp->system.visual, AllocAll);
    /* Fall through */
  case PSEUDO8ADAPTED:
    installPalette (gp);
    break;
  }
}


CalImage *blankImage (struct cw_status *gp, int width, int height, int color)
{
  CalImage *img = (CalImage *)CalCalloc (1, sizeof (CalImage));
  img->width = width; img->height = height;
  img->color = color;
  img->picture =
    XCreatePixmap (gp->system.dpy, XtWindow (gp->system.topLevel),
		   width, height, gp->system.depth);

  XCopyGC (gp->system.dpy, gp->system.origGc,
	   GCFunction
	   | GCForeground | GCLineWidth | GCLineStyle | GCCapStyle
	   | GCJoinStyle | GCFillStyle | GCTile | GCStipple
	   | GCFont | GCClipXOrigin | GCClipYOrigin | GCClipMask
	   | GCDashList,
	   gp->system.drawGc);
  
  XSetForeground (gp->system.dpy, gp->system.drawGc, color);
  
  XFillRectangle (gp->system.dpy, img->picture, gp->system.drawGc,
		  0, 0, width, height);
  return img;
}

void clearImage (struct cw_status *gp, Pixmap pic, int width, int height)
{
  XFillRectangle (gp->system.dpy, pic, gp->system.copyGc,
		  0, 0, width, height);
}

void drawGraph (struct cw_status *gp,
		struct graphobj *object, struct levlist *statlevel,
		CalRect subwin, int winxoffs, int winyoffs)
{
  int i, lw, fill, sa, ea, type, minx, maxx, miny, maxy, severity = Complex,
    colval;
  int imh, imw;
  struct levlist *level;
  XPoint *point;
  Pixmap mask = None;
  CalRect defrect;
  CalText *textnode;
  struct txtlist *tl;
  Pixmap win;
  int *dval = object->pointlist->directval.ptarr;
  message("Drawgraph\n");
  win = statlevel ?
    gp->curlunit->picstatic->picture : gp->curlunit->win->picture;

  if (subwin.width == 0 || subwin.height == 0 || !win)
    return;
//  assert (subwin.width > 0 && subwin.height > 0);

/* Get ACTIVE-attribute */
  if (object->active && !object->active->directval.typint) {
    object->visible = FALSE;
    return;
  }

  type = object->type;
  if (!(point = (XPoint *)CalCalloc (1, (object->ptcount+1)*sizeof (XPoint)))) {
    fprintf (stderr, ErrNOMOREMEM);
    c_exit (gp, NOT_OK);
  }
  defrect = screenRect (gp);

  if (winxoffs != 0 || winyoffs != 0
      || subwin.x != object->boundingbox.x
      || subwin.y != object->boundingbox.y
      || subwin.width != object->boundingbox.width
      || subwin.height != object->boundingbox.height) {
    mask = XCreatePixmap (gp->system.dpy,
			  XtWindow (gp->system.topLevel),
			  subwin.width, subwin.height, 1);
    XCopyGC (gp->system.dpy, gp->system.omskGc,
	     GCFunction | GCLineStyle | GCFillStyle | GCFont,
	     gp->system.maskGc);
  }

/* Map points and lines to polygon, since they are equivalent */
  if (type == S_POINT || type == S_LINE) type = S_POLYGON;

/* (part of) object must be drawn, get original values for Gc */
  XCopyGC (gp->system.dpy, gp->system.origGc,
	   GCFunction
	   | GCForeground | GCLineStyle
	   | GCFillStyle | GCTile | GCStipple
	   | GCFont | GCClipXOrigin | GCClipYOrigin | GCClipMask
	   | GCDashList,
	   gp->system.drawGc);
  XSetTSOrigin (gp->system.dpy, gp->system.drawGc,
		-winxoffs, -winyoffs);

/* Put all the points into an array */
  for (i = 0; i < object->ptcount; i++) {
    point[i].x =  dval[2*i] + winxoffs;
    point[i].y = dval[2*i+1] + winyoffs;
  }
  point[i].x = point[0].x;
  point[i].y = point[0].y;

  /* The following will be used to draw some primitives whose size must
     be positive */
  minx = min (point[0].x, point[1].x);
  maxx = max (point[0].x, point[1].x);
  miny = min (point[0].y, point[1].y);
  maxy = max (point[0].y, point[1].y);

  if (type != S_IMAGE) {
 /* Get the COLOR-attribute */
    switch (gp->system.depth) {
    case 1:
      if ((colval = object->color->directval.typint) > 0
	  && colval < MAXRAST-1) {
	XSetBackground (gp->system.dpy, gp->system.drawGc,
			BlackPixelOfScreen (XtScreen (gp->system.topLevel)));
	XSetForeground (gp->system.dpy, gp->system.drawGc,
			WhitePixelOfScreen (XtScreen (gp->system.topLevel)));
	XSetFillStyle (gp->system.dpy, gp->system.drawGc,
		       FillOpaqueStippled);
	XSetStipple (gp->system.dpy, gp->system.drawGc,
		     gp->raster[colval].picture);
      }
      else {
	XSetFillStyle (gp->system.dpy, gp->system.drawGc, FillSolid);
	XSetForeground (gp->system.dpy, gp->system.drawGc,
			colval == 0 ?
			BlackPixelOfScreen (XtScreen (gp->system.topLevel))
			: WhitePixelOfScreen (XtScreen (gp->system.topLevel)));
      }
      break;
    case 8:
      if ((colval = object->color->directval.typint)>>16 > 0
	  && (colval>>16) < MAXRAST-1) {
	XSetBackground (gp->system.dpy, gp->system.drawGc,
			(colval>>8)&0xFF);
	XSetForeground (gp->system.dpy, gp->system.drawGc,
			colval&0xFF);
	XSetFillStyle (gp->system.dpy, gp->system.drawGc,
		       FillOpaqueStippled);
	XSetStipple (gp->system.dpy, gp->system.drawGc,
		     gp->raster[colval>>16].picture);
      }
      else {
	XSetFillStyle (gp->system.dpy, gp->system.drawGc, FillSolid);
	XSetForeground (gp->system.dpy, gp->system.drawGc,
			(colval>>16) == 0 ? colval&0xFF : (colval>>16)&0xFF);
      }
      break;
    case 24:
    case 4:
      XSetForeground (gp->system.dpy, gp->system.drawGc,
		      object->color->directval.typint);
      break;
    }
  }

/* Get LEVEL-attribute (all objects have this, at least lev0).
   The actual mask to use resides one level above the attributes level-value,
   as the static objects on the object's level are not to be part of this
   level's mask. It's the object's mask we want here, so if the object is
   (part of) a window, use the parent-window's level */

  level = object->parentwin ?
    (struct levlist *)next(object->parentwin->level->directval.typlev) :
      (struct levlist *)next(object->level->directval.typlev);

/* Get FILL-attribute (textobj is always filled) */  
  fill = (type == S_TEXTOBJECT) ?
    TRUE : object->fill ? object->fill->directval.typint : DEF_FILL;

/* Get TEXTURE-attribute */
  if (object->texture
      && object->texture->curval.typint > 0
      && object->texture->curval.typint < MAXSTIPS) {
    if (mask == None) { /* Need mask anyway */
      mask = XCreatePixmap (gp->system.dpy,
			    XtWindow (gp->system.topLevel),
			    subwin.width, subwin. height, 1);
      XCopyGC (gp->system.dpy, gp->system.omskGc,
	       GCFunction | GCLineStyle | GCFont,
	       gp->system.maskGc);
    }
    XSetFillStyle (gp->system.dpy, gp->system.maskGc,
		   FillOpaqueStippled);
    XSetStipple (gp->system.dpy, gp->system.maskGc,
		 object->texture->directval.typimage->picture);
    XFillRectangle (gp->system.dpy, mask, gp->system.maskGc,
		    0, 0, subwin.width, subwin.height);
  }
  else {/* In case it will be needed later */
    XSetFillStyle (gp->system.dpy, gp->system.maskGc, FillSolid);
    if (mask != None)
      XFillRectangle (gp->system.dpy, mask, gp->system.maskGc,
		      0, 0, subwin.width, subwin.height);
  }

/* Get object-specific attributes, and draw if possible */
  switch (type) {
  case S_ARC:
    if (object->startangle)
      sa = object->startangle->directval.typint;
    else sa = DEF_STARTANGLE;
    if (object->endangle)
      ea = object->endangle->directval.typint;
    else ea = DEF_ENDANGLE;
    break;
  case S_IMAGE:
/* If the image is in the cache, don't kill */
    imh = point[1].y-point[0].y;
    imw = point[1].x-point[0].x;
    if(object->ptcount == 1){
      imw = object->image->directval.typimage->width; 
      imh = object->image->directval.typimage->height; 
    }
      
    if(object->ptcount > 1 && imw && imh)
      if (object->image->directval.typimage->in_cache)
	object->image->directval.typimage =
	  scaleImage (gp, object->image->directval.typimage, imw, imh);
      else if (object->image->directval.typimage->width != imw ||
	       object->image->directval.typimage->height != imh) {
	killImage (gp, object->image->directval.typimage);
	object->image->directval.typimage =
	  scaleImage (gp, getImage (gp, object->image->curval.typtxt),
		      imw, imh);
      }

    /* From this point, we're just really interested in positive sizes */
    if (imw < 0) imw = -imw; if (imh < 0) imh = -imh;
  
    if (object->image->directval.typimage->mask) {
/* Copy the subwin-part of the picture's original mask
   into the temporary mask */
      if (mask == None) { /* Need mask anyway */
	mask = XCreatePixmap (gp->system.dpy,
			      XtWindow (gp->system.topLevel),
			      subwin.width, subwin. height, 1);
	XCopyGC (gp->system.dpy, gp->system.omskGc,
		 GCLineStyle | GCFillStyle | GCFont, gp->system.maskGc);
	XSetFunction (gp->system.dpy, gp->system.maskGc, GXcopy);
      }
      else
	XSetFunction (gp->system.dpy, gp->system.maskGc, GXand);

      XCopyArea (gp->system.dpy,
		 object->image->directval.typimage->mask, mask,
		 gp->system.maskGc,
		 subwin.x-minx/*point[0].x*/,
		 subwin.y-miny/*point[0].y*/,
		 subwin.width, subwin.height, 0, 0);
    }
    if (level && level->maskstatic) {
      if (mask == None) { /* Need mask anyway */
	mask = XCreatePixmap (gp->system.dpy,
			      XtWindow (gp->system.topLevel),
			      subwin.width, subwin. height, 1);
	XCopyGC (gp->system.dpy, gp->system.omskGc,
		 GCLineStyle | GCFillStyle | GCFont,
		 gp->system.maskGc);
	XSetFunction (gp->system.dpy, gp->system.maskGc,
		      GXcopyInverted);
      }
      else
	XSetFunction (gp->system.dpy, gp->system.maskGc,
		      GXandInverted);
      XCopyArea (gp->system.dpy, level->maskstatic->mask, mask,
		 gp->system.maskGc,
		 subwin.x, subwin.y, subwin.width, subwin.height, 0, 0);
    }

/* Now draw image with this mask */
    if (mask != None) {
      XSetClipOrigin (gp->system.dpy, gp->system.drawGc,
		      subwin.x, subwin.y);
      XSetClipMask (gp->system.dpy, gp->system.drawGc, mask);
    }
    XCopyArea (gp->system.dpy, 
	       object->image->directval.typimage->picture, win,
	       gp->system.drawGc,
	       0, 0, imw, imh, minx, miny);

    if (statlevel) {
/* Mask must be drawn into maskstatic on the level */
/* INVAR: When static object are setup, they are always drawn entirely */
      if (!statlevel->maskstatic) newLevMask (gp, statlevel);
      XSetFunction (gp->system.dpy, gp->system.maskGc, GXor);
      if (object->image->directval.typimage->mask)
	XCopyArea (gp->system.dpy, 
		   object->image->directval.typimage->mask,
		   statlevel->maskstatic->mask,
		   gp->system.maskGc,
		   0, 0, imw, imh, minx, miny);
      else
	XFillRectangle (gp->system.dpy, statlevel->maskstatic->mask,
			gp->system.maskGc,
			minx, miny, imw, imh);
    }
    goto objdrawn;
  }

/* For the other objects (not IMAGE) */
  if (level && level->maskstatic) {
    if (mask == None) { /* Need mask anyway */
      mask = XCreatePixmap (gp->system.dpy,
			    XtWindow (gp->system.topLevel),
			    subwin.width, subwin. height, 1);
      XCopyGC (gp->system.dpy, gp->system.omskGc,
	       GCLineStyle | GCFillStyle | GCFont,
	       gp->system.maskGc);
      XSetFunction (gp->system.dpy, gp->system.maskGc,
		    GXcopyInverted);
    }
    else
      XSetFunction (gp->system.dpy, gp->system.maskGc, GXandInverted);
    XCopyArea (gp->system.dpy, level->maskstatic->mask, mask,
	       gp->system.maskGc,
	       subwin.x, subwin.y, subwin.width, subwin.height, 0, 0);
  }
  if (mask != None) {
    XSetClipOrigin (gp->system.dpy, gp->system.drawGc,
		    subwin.x, subwin.y);
    XSetClipMask (gp->system.dpy, gp->system.drawGc, mask);
  }

  if (statlevel)
    XSetFunction (gp->system.dpy, gp->system.maskGc, GXor);

  if (!fill) {
/* Get LINEWIDTH-attribute */
    lw = (object->linewidth && object->linewidth->directval.typint != 1) ?
      object->linewidth->directval.typint : 0;

/* Get DASHES-attribute */
    if (object->dashes
	&& object->dashes->curval.typint > 0
	&& object->dashes->curval.typint < MAXDASHES) {
      XSetDashes (gp->system.dpy, gp->system.drawGc, 0,
		  object->dashes->directval.typdash->list,
		  object->dashes->directval.typdash->length);
      XSetLineAttributes (gp->system.dpy, gp->system.drawGc,
			  lw, LineOnOffDash, CapButt, JoinMiter);
    }
    else
      XSetLineAttributes (gp->system.dpy, gp->system.drawGc,
			  lw, LineSolid, CapButt, JoinMiter);
    if (statlevel) {
      if (object->dashes && object->dashes->curval.typint) {
	XSetDashes (gp->system.dpy, gp->system.maskGc, 0,
		    object->dashes->directval.typdash->list,
		    object->dashes->directval.typdash->length);
	XSetLineAttributes (gp->system.dpy, gp->system.maskGc,
			    lw, LineOnOffDash, CapButt, JoinMiter);
      }
      else {
	XSetLineAttributes (gp->system.dpy, gp->system.maskGc,
			    lw, LineSolid, CapButt, JoinMiter);
      }
    }
/* Draw unfilled object */
    switch (type) {
    case S_ARC:
      if (minx != maxx && miny != maxy) { /* Due to X bug */
	XDrawArc (gp->system.dpy, win,
		  gp->system.drawGc,
		  minx, miny, maxx-minx-1, maxy-miny-1, sa*64, (ea-sa)*64);
	if (statlevel) {
	  if (!statlevel->maskstatic) newLevMask (gp, statlevel);
	  XDrawArc (gp->system.dpy, statlevel->maskstatic->mask,
		    gp->system.maskGc,
		    minx, miny, maxx-minx-1, maxy-miny-1, sa*64, (ea-sa)*64);
	}
      }
      goto objdrawn;
    case S_BOX:
      XDrawRectangle (gp->system.dpy, win,
		      gp->system.drawGc,
		      minx, miny, maxx-minx-1, maxy-miny-1);
      if (statlevel) {
	if (!statlevel->maskstatic) newLevMask (gp, statlevel);
	XDrawRectangle (gp->system.dpy, statlevel->maskstatic->mask,
			gp->system.maskGc,
			minx, miny, maxx-minx-1, maxy-miny-1);
      }
      goto objdrawn;
    case S_POLYGON:
      if (i == 1) {
	XDrawPoint (gp->system.dpy, win,
		    gp->system.drawGc,
		    point[0].x, point[0].y);
      }
      else {
	XDrawLines (gp->system.dpy, win,
		    gp->system.drawGc,
		    point, i == 2 ? 2 : i+1, CoordModeOrigin);
      }
      if (statlevel) {
	if (!statlevel->maskstatic) newLevMask (gp, statlevel);
	if (i == 1) {
	  XDrawPoint (gp->system.dpy, statlevel->maskstatic->mask,
		      gp->system.maskGc,
		      point[0].x, point[0].y);
	}
	else {
	  XDrawLines (gp->system.dpy, statlevel->maskstatic->mask,
		      gp->system.maskGc,
		      point, i == 2 ? 2 : i+1, CoordModeOrigin);
	}
      }
      goto objdrawn;
    }
  }
  else {                      /* FILL-attribute == TRUE */

/* Get IMAGE-attribute */
    if (object->image && strcmp (object->image->curval.typtxt, "") != 0) {
      XSetFillStyle (gp->system.dpy, gp->system.drawGc,
		     FillTiled);
      XSetTile (gp->system.dpy, gp->system.drawGc,
		object->image->directval.typimage->picture);
    }

/* Draw filled object */
    switch (type) {
    case S_ARC:
      XFillArc (gp->system.dpy, win,
		gp->system.drawGc,
		minx, miny, maxx-minx, maxy-miny, sa*64, (ea-sa)*64);
      if (statlevel) {
	if (!statlevel->maskstatic) newLevMask (gp, statlevel);
	XFillArc (gp->system.dpy, statlevel->maskstatic->mask,
		  gp->system.maskGc,
		  minx, miny, maxx-minx, maxy-miny, sa*64, (ea-sa)*64);
      }
      goto objdrawn;
    case S_BOX:
      XFillRectangle (gp->system.dpy, win,
		      gp->system.drawGc,
		      minx, miny, maxx-minx, maxy-miny);
      if (statlevel) {
	if (!statlevel->maskstatic) newLevMask (gp, statlevel);
	XFillRectangle (gp->system.dpy, statlevel->maskstatic->mask,
			gp->system.maskGc,
			minx, miny, maxx-minx, maxy-miny);
      }
      goto objdrawn;
    case S_POLYGON:
      /* IMPORTANT: Determine here characteristics of the polygon,
	 this should be in the client, not the -program! */
      if (i < 4) severity = Convex;
      if (i == 1) {
	XDrawPoint (gp->system.dpy, win,
		    gp->system.drawGc,
		    point[0].x, point[0].y);
      }
      else {
	XFillPolygon (gp->system.dpy, win,
		      gp->system.drawGc,
		      point, i, severity, CoordModeOrigin);
      }
      if (statlevel) {
	if (!statlevel->maskstatic) newLevMask (gp, statlevel);
	if (i == 1) {
	  XDrawPoint (gp->system.dpy, statlevel->maskstatic->mask,
		      gp->system.maskGc,
		      point[0].x, point[0].y);
	}
	else {
	  XFillPolygon (gp->system.dpy, statlevel->maskstatic->mask,
			gp->system.maskGc,
			point, i, severity, CoordModeOrigin);
	}
      }
      goto objdrawn;
    case S_TEXTOBJECT:
      textnode = object->outtext ? object->outtext->directval.typtxtnode
	: object->outint ? object->outint->directval.typtxtnode
	  : object->outfloat->directval.typtxtnode;

      if (!textnode->defaultfont) {
	XSetFont (gp->system.dpy, gp->system.drawGc,
		  textnode->fontinfo->fontid);
	if (statlevel)
	  XSetFont (gp->system.dpy, gp->system.maskGc,
		    textnode->fontinfo->fontid);
      }
      if (statlevel && !statlevel->maskstatic) newLevMask (gp, statlevel);

      for (tl = textnode->linlist; tl; tl = (struct txtlist *)next(tl)) {
	XDrawString (gp->system.dpy, win,
		     gp->system.drawGc,
		     point[0].x, point[0].y+textnode->fontinfo->ascent,
		     tl->line, tl->length);
	if (statlevel)
	  XDrawString (gp->system.dpy, statlevel->maskstatic->mask,
		       gp->system.maskGc,
		       point[0].x, point[0].y+textnode->fontinfo->ascent,
		       tl->line, tl->length);
	point[0].y += (textnode->fontinfo->ascent+textnode->fontinfo->descent);
      }
      goto objdrawn;

    }
  }
  objdrawn:
  CalFree (point);
  if (mask != None) XFreePixmap (gp->system.dpy, mask);
}

void openMainWin (struct cw_status *gp)
{
  XVisualInfo visual_info;
  Pixmap dummy;
  XGCValues gcvals;

  gp->system.visual =
    DefaultVisualOfScreen (XtScreen (gp->system.topLevel));
  gp->system.depth =
    DefaultDepthOfScreen (XtScreen (gp->system.topLevel));

  /* A 24-bit TrueColor would be pretty cool */
  if (XMatchVisualInfo (gp->system.dpy, DefaultScreen (gp->system.dpy),
			24, TrueColor, &visual_info)) {
    gp->system.colorModel = TRUECOLOR24;
    goto visualOK;
  }
  /* Sjekk om Visual er Pseudo-color og at vi har minst 8 plan */
  if (gp->system.depth >= 8
      && XMatchVisualInfo (gp->system.dpy, DefaultScreen (gp->system.dpy),
			   8, PseudoColor, &visual_info)) {
    gp->system.colorModel = gp->perfect_colors ?
      PSEUDO8PERFECT : PSEUDO8ADAPTED;
    goto visualOK;
  }
  if (gp->system.depth == 4
      && XMatchVisualInfo (gp->system.dpy, DefaultScreen (gp->system.dpy),
			   4, StaticGray, &visual_info)) {
    gp->system.colorModel = GRAY4;
    goto visualOK;
  }
  if (gp->system.depth == 1
      && XMatchVisualInfo (gp->system.dpy, DefaultScreen (gp->system.dpy),
			   1, StaticGray, &visual_info)) {
    gp->system.colorModel = GRAY1;
    goto visualOK;
  }
  fprintf (stderr, "Required visual not supported on this display !\n");
  exit (1);

visualOK:
  gp->system.visual = visual_info.visual;
  gp->system.depth = visual_info.depth;
  
  makeColors (gp);

/*
 * Xlib initialization
 */

  gp->curlunit = NULL;

  gcvals.background = gcvals.foreground =
    BlackPixelOfScreen (XtScreen (gp->system.topLevel));
  gcvals.graphics_exposures = FALSE;

  gp->system.origGc =
    XCreateGC (gp->system.dpy, XtWindow (gp->system.topLevel),
	      GCGraphicsExposures, &gcvals);

  gp->system.drawGc =
    XCreateGC (gp->system.dpy, XtWindow (gp->system.topLevel),
	      GCGraphicsExposures, &gcvals);

  gp->system.copyGc =
    XCreateGC (gp->system.dpy, XtWindow (gp->system.topLevel),
	      GCGraphicsExposures | GCBackground | GCForeground, &gcvals);

/* Dummy pixmap, only to create a one-plane GC */
  dummy =
    XCreatePixmap (gp->system.dpy, XtWindow (gp->system.topLevel),
		   1, 1, 1);
  gcvals.background = 0;
  gcvals.foreground = 1;
  gp->system.omskGc =
    XCreateGC (gp->system.dpy, dummy,
	       GCForeground | GCBackground | GCGraphicsExposures,
	       &gcvals);
  gp->system.maskGc =
    XCreateGC (gp->system.dpy, dummy,
	       GCForeground | GCBackground | GCGraphicsExposures,
	       &gcvals);
  XFreePixmap (gp->system.dpy, dummy);
}
