#ifdef PTHREAD
#include "pthread.h"
#endif

#include <stdio.h>
#include "npapi.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <fcntl.h>
#include <assert.h>
#include <sys/types.h>
#include <errno.h>

#include "candle.h"
#include "nodes.h"
#include "Awe.h"
#include "stuff.h"
#include "wwwcom.h"
#include "sysproto.h"
#include "protos/fast_lis.h"
#include "protos/parser.h"
#include "protos/canutil.h"
#include "protos/memory.h"

#if 0
#ifdef PTHREAD
#include "pthread/posix.h"
#endif
#endif

/***********************************************************************
 * Instance state information about the plugin.
 *
 * PLUGIN DEVELOPERS:
 *	Use this struct to hold per-instance information that you'll
 *	need in the various functions in this file.
 ***********************************************************************/

typedef struct _PluginInstance
{
  uint16 mode;
  Window window;
  Display *display;
  uint32 x, y;
  uint32 width, height;

  struct cw_status globals; /* All global variables resides in globals */
  AweStream *basestream;
#ifdef PTHREAD
  pthread_t threadId;
  pthread_mutex_t mutex;
  pthread_cond_t stream_ready;
  pthread_attr_t attr;
#endif
} PluginInstance;


#ifdef PTHREAD
/* Simulation's own Awe-thread */
void *threadmain (void *p)
{
  NPP instance = p;
  PluginInstance* This;
  message("threadmain\n");
  This = (PluginInstance*)instance->pdata;

  pthread_mutex_lock (&This->mutex);
  pthread_cond_init(&This->stream_ready, NULL);
  if (This->basestream == NULL) 
    pthread_cond_wait(&This->stream_ready, NULL);
  message("starting candle_unit\n");
  start_candle_unit (&This->globals, This->basestream);
  message("After start_candle_unit\n");
}
#endif

/***********************************************************************
 *
 * Empty implementations of plugin API functions
 *
 * PLUGIN DEVELOPERS:
 *	You will need to implement these functions as required by your
 *	plugin.
 *
 ***********************************************************************/

char*
NPP_GetMIMEDescription(void)
{
//  message("NPP_GetMIMEDescription\n");
  /* Should be: "application/x-candleweb:.awe", I think */
  return("application/x-candleweb:.awe");
}

NPError
NPP_GetValue(void *future, NPPVariable variable, void *value)
{
  NPError err = NPERR_NO_ERROR;

  switch (variable) {
  case NPPVpluginNameString:
    *((char **)value) = "CandleWeb plugin";
    break;
  case NPPVpluginDescriptionString:
    *((char **)value) =
    "This plugin runs (awe) files with CandleWeb"
    "<a href = \"http://www.candleweb.no/\">More info</a>";
    break;
  default:
    err = NPERR_GENERIC_ERROR;
  }
  return err;
}

NPError
NPP_Initialize(void)
{
  return NPERR_NO_ERROR;
}


jref
NPP_GetJavaClass()
{
  return NULL;
}

void
NPP_Shutdown(void)
{
}


NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
  PluginInstance* This;
  int i;


  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  instance->pdata = CalCalloc (1, sizeof(PluginInstance));
  
  This = (PluginInstance*) instance->pdata;
  
  if (This != NULL) {
    /* mode is NP_EMBED, NP_FULL, or NP_BACKGROUND (see npapi.h) */
    This->mode = mode;
    This->window = (Window) 0;
    This->globals.nppinstance = instance;

    message ("----------------New------------------\n");

    This->globals.Gif89.transparent = -1;
    This->globals.Gif89.delayTime = -1;
    This->globals.Gif89.inputFlag = -1;

    This->globals.LEXfirsttime = TRUE;
    This->globals.firsttime = TRUE;
    This->globals.system.clientcache = NULL; /* Not for Win32!! */
    This->globals.defpic = NULL;

    This->globals.rectmaxcount = RECTPOWER;
    if (!(This->globals.rectspace =
	  CalMalloc (This->globals.rectmaxcount
		     *sizeof (struct rectlist))))
      return NPERR_OUT_OF_MEMORY_ERROR;

      /* PLUGIN DEVELOPERS:
       *	Initialize fields of your plugin
       *	instance data here.  If the NPSavedData is non-
       *	NULL, you can use that data (returned by you from
       *	NPP_Destroy to set up the new plugin instance).
       */
      
#ifdef PTHREAD
    pthread_init();
    pthread_mutex_init (&This->mutex, NULL);
    /*    pthread_attr_init(&This->attr);
    pthread_attr_setstacksize(&This->attr, 4000000);
    */
    message("create thread\n");
    if (pthread_create (&This->threadId, NULL, threadmain, instance) == 0)
      return NPERR_NO_ERROR;
#else
    /*while(This->basestream == NULL)
      CalServeEvents(&This->globals);
      */
    return NPERR_NO_ERROR;
#endif

    return NPERR_OUT_OF_MEMORY_ERROR;
  }
  else return NPERR_OUT_OF_MEMORY_ERROR;
}


NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
  PluginInstance* This;

  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  This = (PluginInstance*) instance->pdata;

  /* PLUGIN DEVELOPERS:
   *	If desired, call NP_MemAlloc to create a
   *	NPSavedDate structure containing any state information
   *	that you want restored if this plugin instance is later
   *	recreated.
   */
  
  if (This != NULL) {
    CalFree (instance->pdata);
    instance->pdata = NULL;
  }
  
  return NPERR_NO_ERROR;
}

NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
  PluginInstance* This;
  int i, j;
  struct learnunit *learnnode;
  message("SetWindow");
  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;
  
  if (window == NULL)
    return NPERR_NO_ERROR;
  
  This = (PluginInstance*) instance->pdata;
  This->x = window->x;
  This->y = window->y;
  This->width = window->width;
  This->height = window->height;
  
  /*
   * PLUGIN DEVELOPERS:
   *	Before setting window to point to the
   *	new window, you may wish to compare the new window
   *	info to the previous window (if any) to note window
   *	size changes, etc.
   */
  
  if (This->window == (Window) window->window) {
    /* This is a plugin changing size */
    XtVaSetValues(This->globals.system.workArea,
		  XtNx, This->x, XtNy, This->y,
		  XtNheight, This->height, XtNwidth, This->width,
		  NULL);
  }
  else {
    This->window = (Window) window->window;
    This->display = ((NPSetWindowCallbackStruct *)window->ws_info)->display;

    This->globals.system.dpy = This->display;
    This->globals.system.topLevel = /* Netscape-widget */
      XtWindowToWidget(This->display, This->window);
    This->globals.system.app = 
      XtWidgetToApplicationContext (This->globals.system.topLevel);
    
    This->globals.icsize = 1;
    initStipples (&This->globals);
    initRasters (&This->globals);
    initDashes (&This->globals);
    openMainWin (&This->globals); /* Find visual and do some init */
    
    message ("Before initdefimg\n");
    //      init_list (&This->globals,
    //		 This->globals.imgcache = initDefImg (&This->globals));
    //      This->globals.imgcache->img.in_cache = TRUE;
    message ("After initdefimg\n");


    if (This->globals.rectmaxcount != RECTPOWER) {
      CalFree (This->globals.rectspace);
      if ((This->globals.rectspace = 
	   CalMalloc ((This->globals.rectmaxcount = RECTPOWER)
		      *sizeof (struct rectlist))) == NULL)
	return NPERR_OUT_OF_MEMORY_ERROR;
    }
    
    This->globals.system.workArea=
      XtVaCreateManagedWidget ("awe", aweWidgetClass,
			       This->globals.system.topLevel,
			       XtNwidth, This->width,
			       XtNheight, This->height,
			       XtNaweInstance, &This->globals,
			       NULL, NULL);
    XtManageChild (This->globals.system.workArea);
    message ("Before GetMousePos\n");
    GetMousePos(&This->globals,
		&This->globals.mousex, &This->globals.mousey);
    
  }
  return NPERR_NO_ERROR;
}


NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream, 
	      NPBool seekable,
	      uint16 *stype)
{
  NPByteRange range;
  PluginInstance* This;
  AweStream *as;
  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;

  This = (PluginInstance*) instance->pdata;
  message("New Stream\n");

#ifdef PTHREAD
  if (seekable) {
    *stype = NP_SEEK;
    range.offset = 0;
    range.length = 20000;
    range.next = NULL;
    NPN_RequestRead(stream, &range);
  }
  
  as = FindAweStream(stream);
  if(as != NULL){
    as->nps = stream;
  }

  if (This->basestream == NULL) {
    if(as == NULL){
      as = NewAweStream(&This->globals, stream);
      This->globals.current_anchor = strdup(stream->url);
    }
    This->basestream = as;
    message("starting candle unit\n");
    start_candle_unit(&This->globals, This->basestream);

    pthread_cond_signal(&This->stream_ready);
  }
#else
  as = AweOpen (&This->globals, stream->url);
  if (as != NULL) {
    message("starting candle unit\n");
    start_candle_unit(&This->globals, as);
  }
  else message ("Open failed !!!\n")
#endif

  return NPERR_NO_ERROR;
}

int32 STREAMBUFSIZE = 0X0FFFFFFF; /* If we are reading from a file in NPAsFile
				   * mode so we can take any size stream in our
				   * write call (since we ignore it) */


/* PLUGIN DEVELOPERS:
 *	These next 2 functions are directly relevant in a plug-in which
 *	handles the data in a streaming manner. If you want zero bytes
 *	because no buffer space is YET available, return 0. As long as
 *	the stream has not been written to the plugin, Navigator will
 *	continue trying to send bytes.  If the plugin doesn't want them,
 *	just return some large number from NPP_WriteReady(), and
 *	ignore them in NPP_Write().  For a NP_ASFILE stream, they are
 *	still called but can safely be ignored using this strategy.
 */

int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
  PluginInstance* This;
  message("WriteReady\n");
  if (instance != NULL)
    This = (PluginInstance*) instance->pdata;

#ifdef PTHREAD
  return STREAMBUFSIZE;
#else
  return 0;
#endif
}


int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
  char mess[256];
#ifdef PTHREAD
  if (instance != NULL)
    {
      PluginInstance* This = (PluginInstance*) instance->pdata;
      char *cbuf, tmpname[128];
      int fd;
      AweStream *as;
      sprintf(mess, "url:%s - len:%ld\n", stream->url, len);
      message(mess);
      as = FindAweStream(stream);
      sprintf(mess, "as:%d\n", as);
      message(mess);
      if(as->buffer == NULL){
	as->buffer = CalMalloc(len);
	memcpy(as->buffer, buffer, len);
      } else {
	as->buffer = CalRealloc(as->buffer, as->csize + len);
	memcpy(as->buffer + as->csize, buffer, len);
      }
      as->csize += len;
      
      //sprintf (tmpname, "%x\0", (unsigned long)This);
      //      cbuf = (char *) CalAlloc (len + 1);
      //      if (!cbuf) return 0;
      //      memcpy(cbuf, (char *)buffer, len);
      //      cbuf[len] = '\0';
      //      fd = open (tmpname, O_RDWR);
      //      assert (fd != -1);
      //      write (fd, buffer, len);
      //      close (fd);

      /* if (This->globals.system.workArea)
       * Possibly check if this is a hidden plugin here
       * Possibly also switch on the different kinds of streams
       */
      /*
      message ("Entering Write\n");
      setScanFileName (&This->globals, strdup("/home/svein/awelogo.awe"));
      message ("Before start_candle_unit\n");
      start_candle_unit (&This->globals, scanFileName(&This->globals));
      mainLoop (&This->globals);
      */
//      unlink (tmpname);
//      CalFree (cbuf);
    }
#else /* NOT PTHREAD */
  message("Write - Should never be called !!!\n");
#endif
  return len;		/* The number of bytes accepted */
}

NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
  PluginInstance* This;
  AweStream *as;
  message("DestroyStream\n");
  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;
  This = (PluginInstance*) instance->pdata;
#ifdef PTHREAD
  if(reason == NPRES_DONE || reason == NPRES_USER_BREAK){
    as = FindAweStream(stream);
    as->size = as->csize;
  }
#endif /* PTHREAD */
  return NPERR_NO_ERROR;
}


void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
  PluginInstance* This;
  if (instance != NULL)
    This = (PluginInstance*) instance->pdata;

  fprintf(stderr, "Got NPP_StreamAsFile: %s.\n", (fname == NULL)?"null":fname);
}


void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
  if(printInfo == NULL)
    return;
  
  if (instance != NULL) {
    PluginInstance* This = (PluginInstance*) instance->pdata;
    
    if (printInfo->mode == NP_FULL) {
      /*
       * PLUGIN DEVELOPERS:
       *	If your plugin would like to take over
       *	printing completely when it is in full-screen mode,
       *	set printInfo->pluginPrinted to TRUE and print your
       *	plugin as you see fit.  If your plugin wants Netscape
       *	to handle printing in this case, set
       *	printInfo->pluginPrinted to FALSE (the default) and
       *	do nothing.  If you do want to handle printing
       *	yourself, printOne is true if the print button
       *	(as opposed to the print menu) was clicked.
       *	On the Macintosh, platformPrint is a THPrint; on
       *	Windows, platformPrint is a structure
       *	(defined in npapi.h) containing the printer name, port,
       *	etc.
       */
      
      void* platformPrint =
	printInfo->print.fullPrint.platformPrint;
      NPBool printOne =
	printInfo->print.fullPrint.printOne;
      
      /* Do the default*/
      printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
    else {	/* If not fullscreen, we must be embedded */
      /*
       * PLUGIN DEVELOPERS:
       *	If your plugin is embedded, or is full-screen
       *	but you returned false in pluginPrinted above, NPP_Print
       *	will be called with mode == NP_EMBED.  The NPWindow
       *	in the printInfo gives the location and dimensions of
       *	the embedded plugin on the printed page.  On the
       *	Macintosh, platformPrint is the printer port; on
       *	Windows, platformPrint is the handle to the printing
       *	device context.
       */
      
      NPWindow* printWindow =
	&(printInfo->print.embedPrint.window);
      void* platformPrint =
	printInfo->print.embedPrint.platformPrint;
    }
  }
}
