char RcsId[] = "$Id: candlweb.c,v 1.41 1996/07/24 17:27:43 gunnar Exp $";

/* Copyright (c) 1995 by Computers and Learning A/S (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (svein@candleweb.no), 
 *	    Gunnar Rnning (gunnar@candleweb.no)
 */

#if (defined WIN31 || defined WIN32)
#include <windows.h>            // required for all Windows applications
#include "windows/main.h"
#endif

#include <math.h>
#include <stdlib.h>
#include <stdio.h> 
#include <string.h> 
#include <malloc.h> 
#include <signal.h>
#ifdef UNIX
#include <unistd.h>
#endif

#include "const.h"
#include "candle.h"
#include "graphic.h"
#include "parser.h"
#include "nodes.h"
#include "error.h"
#include "wwwcom.h"

#include "sysproto.h"
#include "protos/canutil.h"
#include "protos/readsim.h"
#include "protos/instance.h"
#include "protos/simulate.h"
#include "protos/fast_lis.h"
#include "protos/sound.h"
#include "protos/input.h"
#include "protos/parser.h"
#include "protos/memory.h"
#if (defined WIN31 || defined WIN32)

#ifdef ALLOWGLOBALS
struct cw_status *globalp;
#endif

int WinMainLoop( struct cw_status *gp );

int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance, 
                   LPSTR     lpCmdLine, 
                   int       nCmdShow)
#else

#ifdef SOUNDSUPPORT
int audio = -1, mtimes = 0, wtimes = 0;
#endif

int main (int argc, char *argv[])
#endif
{
  char *tmperr;           
  char *libpath;
  char tmpname[128];
  struct imgnode FAR *initImg;
  struct cw_status *gp = CalCalloc (1, sizeof (struct cw_status));
  AweStream *as;
  char *url;
  char errormsg[256];

  /* All global variables resides in globals */

#if (defined WIN32 && defined ALLOWGLOBALS)
  globalp = gp;
#endif

#ifdef UNIX
#ifdef SOUNDSUPPORT
  if (pipe (gp->wavefd) == -1 || pipe (gp->midifd) == -1)
    fprintf (stderr, "Pipe error !\n");
  if ((gp->wavePid = fork ()) == 0) waveserver (gp);
  if ((gp->midiPid = fork ()) == 0) midiserver (gp);
#endif
  signal(SIGKILL, l_exit);
  signal(SIGBUS, bibi);
#endif

  /*
   * Legal exits.
   */
  signal(SIGINT, l_exit);
  signal(SIGTERM, l_exit);

  /*
   * Programfault, dump core.
   */
/*   signal(SIGABRT, bibi); */

  gp->Gif89.transparent = -1;
  gp->Gif89.delayTime = -1;
  gp->Gif89.inputFlag = -1;

  gp->LEXfirsttime = TRUE;
  gp->firsttime = TRUE;
  
#ifdef X11
  gp->system.clientcache = NULL;
#endif
  gp->defpic = NULL;

  if((libpath = getenv("AWELIBPATH")) != NULL)
    gp->library_path = strdup(libpath);

  if ((gp->rectspace =
       CalMalloc ((gp->rectmaxcount = RECTPOWER)*sizeof (struct rectlist)))
      == NULL) {
    errorMsg(gp, 2, ErrNOMOREMEM);
    exit (NOT_OK);
  }

#ifdef WWWENABLE
  WWWInit();
#endif

#if (defined WIN31 || defined WIN32)
  installPalette (gp, 0, 0);
  if (!InitApplication(hInstance, nCmdShow)) return(FALSE);
  openMainWin (gp, &nCmdShow, &lpCmdLine); /* dummy parameters */
#else
    openMainWin (gp, &argc, argv);
#endif


  if(gp->redirect_stderr == 0){
    tmperr = NULL;
    gp->err_file = NULL;
  } else {
    tmperr = tmpnam(NULL);
    gp->err_file = strdup(tmperr);
    strcpy(tmpname, gp->err_file);
    gp->err_fp = freopen(tmpname, "w", stderr); 
  }

  if (!gp->parseOnly) {
    init_list (initImg = gp->imgcache = initDefImg (gp));
    gp->imgcache->img.in_cache = TRUE;

    gp->icsize = 1;
    initStipples (gp);
    initRasters (gp);
    initDashes (gp);
  }
  gp->command = 0L;
  GetMousePos(gp, &gp->mousex, &gp->mousey);

#if (defined WIN31 || defined WIN32)
  if(strlen(lpCmdLine)) {
    setScanFileName(gp, strdup(lpCmdLine));
#else
  if(argc > 1){  
    setScanFileName(gp, strdup(argv[1]));
#endif
    as = AweOpen(gp, scanFileName(gp));
    if (as == NULL) {
      sprintf(errormsg, "Could not open %s.", scanFileName(gp));
      userMsg (errormsg);
    } else {
      if (!gp->parseOnly){
	url = canonizedURL(gp, scanFileName(gp));
	setURL(gp, url);
      }
      start_candle_unit(gp, as, url);
      killLearnUnit(gp);
    }
  }

#if (defined WIN31 || defined WIN32)
  WinMainLoop(gp);
  closeMainWin (gp); /* dummy parameters */

  DeleteObject(gp->system.colormap);
#else
  if (!gp->parseOnly)
    mainLoop(gp);
#endif
  c_exit(gp, OK);
  return 1;
}
