/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no)
 */
/*
 * This files holds the routines pertaining images
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include "candle.h"
#include "nodes.h"
#include "fast_lis.h"
#include "error.h"
#include "pbmplus.h"

#include "sysproto.h"
#include "protos/fast_lis.h"
#include "protos/canutil.h"
#include "protos/memory.h"
#include "wwwcom.h"


/*
 * This is the routine creating a CalImage from a file.
 */

CalImage createImage (struct cw_status *gp, char FAR *URL)
{
  AweStream *in;
  long             gifColormap[MAXCOLS];
  CalImage        img = {0};
 
  setStatus (gp, "Getting remote image");

  setStatus (gp, "Creating image");

  if ((in = AweOpen(gp, URL)) == NULL) {
    img.width = 0;
    return img;
  }
  if (URL && !strcmp (ContentType(gp, URL), "image/gif")){
    ReadGIF (gp, in, gifColormap, &img);
    /*if (img.color != -1) calcMask (&img, &img);*/
  }
  else if (URL && !strcmp (ContentType(gp, URL), "image/jpeg"))
    readJPEG (gp, in, &img);
  else if (strchr (URL, '.')) {
    fprintf (stderr, "Warning: Unknown extension for image %s.\n"
	     "Using default image\n", URL);
    img.width = 0;
  }
  AweClose (in);
  setStatus (gp, "OK");
  return img;
}

/* getImage returns a reference to an image specified by its URL.
   It first checks the cache. If it's not there, it's dwonloaded and
   created by createImage. The URL is used as a key. */

CalImage FAR *getImage (struct cw_status *gp, char FAR *URL)
{
  struct imgnode FAR *imgnode, FAR *lastimg = NULL;
  CalImage image;
  char errormsg[256];

/* Invariants: LRU-order. Default-image always resides first in list,
   then comes LRU image */

  for (imgnode = (struct imgnode FAR *)next(gp->imgcache);
       imgnode;
       imgnode = (struct imgnode FAR *)next(imgnode)) { 

    lastimg = imgnode;                /* Last nonNULL img-ptr */
    if (strcmp (imgnode->key, URL) == 0) { /* Place first and return */
      remove_at(imgnode);
      place_next(gp->imgcache, imgnode);
      return &imgnode->img;
    }
  }
/* Image was not in cache, create it */
  image = createImage (gp, URL);
  if (image.width == 0) {
    if (strcmp ("", URL) != 0) {
      sprintf (errormsg, WarnIMGERR, URL);
      errorMsg(gp, 0, errormsg);
    }
    return &gp->imgcache->img;
  }
/* createImage was successfull */
  if (gp->icsize == MAXIMGCACHE) {
    remove_at(imgnode = lastimg);
    killImageFromNode (gp, &imgnode->img);
    place_next(gp->imgcache, imgnode);
    if (imgnode->key) free (imgnode->key);
    imgnode->key = NULL;
  }
  else {
    if (!(imgnode =
	  (struct imgnode FAR *)CalCalloc (1, sizeof (struct imgnode)))) {
      errorMsg(gp, 2, ErrNOMOREMEM);
      c_exit (gp, NOT_OK);
    }
    place_next(last(gp->imgcache), imgnode);
    gp->icsize++;
  }
  /* Have now a valid, empty imgnode */
  if (URL) imgnode->key = strdup(URL);
  image.in_cache = TRUE;
  imgnode->img = image;
  imgnode->lunit = gp->curlunit;
  return &imgnode->img;
}

void freeImage (struct cw_status *gp, struct imgnode FAR *in)
{
  remove_at(in);
  killImageFromNode (gp, &in->img);
  if (in->key){
    CalFree (in->key);
    in->key = NULL;
  }
  CalFree (in);
  gp->icsize--;
}

