/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

/*
 * Declarations/definitions of X11-specific types to Candle2.0 general types
 */

#ifndef _cal_X11
#define _cal_X11

#include <X11/Intrinsic.h>
#include <X11/Xcms.h>

#define MAXCOLS 256    /* The X-browser uses 256 colors. Must not be changed */

typedef struct {
  XcmsColor color;
  /*  int sortindex; */
} CalColor;

typedef struct {
  char in_cache;
  int width, height;	
  long color;
  Pixmap picture;      /* The actual picture */
  Pixmap mask;         /* The non-transparent pixels of picture */
} CalImage;

typedef struct {
  unsigned char *list;
  int length;
} CalDash;

typedef XFontStruct CalFont;
/* constants for accessing the XFontStruct */
#define fontid fid
#define ascent ascent
#define descent descent
#define xoffs min_bounds.lbearing

typedef struct {
  char defaultfont;    /* Set if this node contains default-font */
  CalFont *fontinfo;
  struct txtlist *linlist; 
  int maxwidth, lincount;
} CalText;

typedef struct {
  int x, y, width, height;
} CalRect;

typedef Region CalRegion;

/* Following colormodels are supported (StaticGray 4 planes not tested) */
#define TRUECOLOR24    0 /* TrueColor 24-bit */
#define PSEUDO8PERFECT 1 /* Pseudo 8 with 256 writeable colors */
#define PSEUDO8ADAPTED 2 /* Pseudo 8 with any 256 colors */
#define GRAY4          3 /* StaticGray, 4 planes */
#define GRAY1          4 /* StaticGray, 1 plane */
#define TRUECOLOR16    5 /* TrueColor 16-bit */

typedef struct {
  Display *dpy;      /* Display where the browser runs */
  Visual *visual;
  int depth;
  Widget topShell;   /* Top level shell */
  Widget topLevel;   /* Top widget */
  Widget workArea;   /* Main widget */
  Widget URL;        /* Showing current URL */
  Widget status;     /* Widget showing the status */
/* GCs :
 * origGc - Original Gc
 * drawGc - Configurable, usually copied from origGc
 * copyGc - Gc used for copying
 * maskGc - One-plane Gc used for masks
 * omskGc - Original mask Gc, as Gcs in copyGc must have the same depth
 */
  GC origGc, drawGc, copyGc, maskGc, omskGc;
  Colormap colormap;
  XtAppContext app;
  XImage *clientcache; /* Pointer to last image read from disk */
  CalImage *clientimage;
  XtIntervalId timeoutid;
} CalSystem;

typedef struct _AweSystem {
  Display *dpy;      /* Display where the browser runs */
  Visual *visual;
  int depth;
  Widget topShell;   /* Top level shell */
  Colormap colormap;
  XtAppContext app;
  CalColor color[MAXCOLS];        /* Colortable */
  int colorModel;
} AweSystem;

extern AweSystem awe_system;

#endif /* _cal_X11 */

