/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#ifndef WWWCOM_H
#define WWWCOM_H

#include "fast_lis.h"
#ifdef PLUGIN
#include "../plugin/npapi.h"
#endif

#define URL_ANCHOR	0
#define FILE_ANCHOR	1

#ifdef PTHREAD
typedef struct _AweStream {
  struct _AweStream *next, *prev;
  int position;		/* current position in the stream */
  int csize;		/* current size of the stream-buffer */
  int size;		/* Final size of the stream-buffer or -1 if the 
			 * entire stream is not received.
			 */ 
  unsigned char *buffer;
  char *url;
#ifdef PLUGIN
  NPStream *nps;
  struct cw_status *gp;
#endif
} AweStream;
#else 
typedef FILE AweStream;
#endif

#ifndef WWWCOM
extern AweStream *fstream;
#endif
#ifdef PLUGIN
AweStream *FindAweStream(NPStream *);
AweStream *NewAweStream(struct cw_status *, NPStream *);
#endif

#if (defined WWWCOM && defined WWWENABLE)
struct urlmap {
  struct urlmap *next;
  char *url;
  char *filename;
  char *content_type;	/* Pointer to the MIME content-type of the URL */
  struct AweReqContext *reqcon; /* Non-NULL indicates that the request for 
				 * this object is not yet finished.
				 */

  char is_tmp;		/* Set to true for all temporary files created by
			 * Candle. Only files with this flag set will be 
			 * deleted on exit.
			 */
};

struct AweReqContext {
  lp(AweReqContext)
  struct urlmap *map;
  HTRequest *req;
  int fd;
  int status;
  FILE *fp;
  struct cw_status *gp;
};
#endif /* WWWCOM && WWWENABLE */

/*
 * Prototypes
 */
void NewAnchor(struct cw_status *gp, char *, int type);
char *ResolveURL(struct cw_status *gp, char *);
int ReloadFile(struct cw_status *gp, char *);
void BindURL(struct cw_status *gp, char *url, char *filename);
char *findURL(struct cw_status *gp, char *filename);
int OpenURL(struct cw_status *gp, char *url, char *mode);
int Read(int fd, char *buf, int nbytes); 
int Write(int fd, char *buf, int nbytes);
void ProcessRequests(struct cw_status *gp);
char *ContentType(struct cw_status *gp, char *url);
char *canonizedURL(struct cw_status *gp, char *url);
char *AbsoluteURL(char *anchor, char *relative);
int RemoveMapEntry(struct cw_status *gp, char *url);
int PostData(struct cw_status *gp, char *dest, char *data, long datalen, char **reply);


AweStream *AweOpen (struct cw_status *gp, char *URL);
void AweClose (AweStream *as);
size_t AweRead (AweStream *as, char *buf, size_t count);
size_t AweWrite (AweStream *as, char *buf, size_t count);
int AweGetc (AweStream *as);
int AweUngetc (int c, AweStream *as);



#ifdef WWWENABLE
void WWWInit(void);
void WWWFree(void);
#ifdef WWWCOM
static struct AweReqContext *GetURL(struct cw_status *gp, struct urlmap *map, int block);
static char *lookupURL(struct cw_status *gp, char *);
static char *simplifyURL(struct cw_status *gp, char *);
static terminate_handler(HTRequest * request, void *param, 
			 int status);
static BOOL progress_handler(HTRequest *request, HTAlertOpcode op,
			     int msgnum, const char * dfault, 
			     void * input, HTAlertPar * reply);
#endif /* WWWCOM */
#endif /* WWWENABLE */


#endif /* WWWCOM_H */
