/* Copyright (c) 1996 by CandleWeb AS (candleweb@candleweb.no). 
 * See Copyright.txt for details.
 *
 * Authors: Gunnar Rnning (gunnar@candleweb.no)
 *          Borgar Olsen (borgar@osc.no)
 */

#ifndef AWE_TYPES_H
#define AWE_TYPES_H

#define T_VOID     0
#define T_INT      1
#define T_FLOAT    2
#define T_TEXT     3

#define T_CONST    1<<2
#define T_VAR	   1<<3
#define T_ARRAY    1<<4
#define T_FUNC     1<<5

#define T_OPER     1<<6
#define T_OBJECT   1<<7

#define T_BIN	   T_CONST

#define IS_CONST(a)  ( (a) & T_CONST )

#define IS_VAR(a)    ( (a) & T_VAR )
#define IS_ARRAY(a)  ( (a) & T_ARRAY )
#define IS_FUNC(a)   ( (a) & T_FUNC )
#define IS_OPER(a)   ( (a) & T_OPER )

#define IS_BFUNC(a)  ( (a) & T_CONST && (a) & T_FUNC )
#define IS_UFUNC(a)  ( (a) & ! T_CONST && (a) & T_FUNC )

#define SET_ARRAY(flag)	(flag |= T_ARRAY)

typedef char typevar;

/*
 * Attribute types.
 */
#define T_EXPR		1
#define T_TRANSLATION	2
#define T_POINTS	4

#endif /* AWE_TYPES_H */
