/* Copyright (c) 1995 by Computers and Learning A/S (candle@sn.no). 
 * See Copyright.txt for details.
 *
 * Authors: Svein Arne Johansen (sveinj@ifi.uio.no), 
 *	    Gunnar Rnning (gunnarr@ifi.uio.no)
 */

#ifndef SYSPROTO_H
#define SYSPROTO_H

#include <stdio.h>
#include "graphic.h"
#include "attr.h"
#include "wwwcom.h"

/* Declarations of the object-managing functions */
void fakeExpose (struct cw_status *, CalRect);
void makeGUI(struct cw_status *);
void calBell (struct cw_status *, long, long, long);
void CalSync(struct cw_status *);
void CalTimeOut (struct cw_status *, unsigned long);
void CalServeEvents (struct cw_status *);
void CalServeWinEvents (struct cw_status *);
void CalWaitForEvent(struct cw_status *);
void resizeMainWin (struct cw_status *, int, int);
int getFInfo (struct cw_status *, CalText FAR *, char FAR *);
int fextents (struct cw_status *, char FAR *, char FAR *, int FAR *, int FAR *, int FAR *);
void getDefFInfo (struct cw_status *, CalText FAR *);
void freeFont (struct cw_status *, CalText FAR *);
long defColor (struct cw_status *, long);
long displayPixel (long);
long stdRGBOfInd (struct cw_status *, long);
#ifndef PLUGIN
void installPalette (struct cw_status *, Widget, Colormap);
#endif
void makeColors (struct cw_status *);
void changeColEntry (struct cw_status *, int i, long v);
void newLevMask (struct cw_status *, struct levlist FAR *ll);
void drawWin (struct cw_status *, struct winobj FAR *, struct levlist FAR *, CalRect);
void drawGraph (struct cw_status *, struct graphobj FAR *, struct levlist FAR *, CalRect, int, int);


void killImage (struct cw_status *, CalImage FAR *);
void killImageFromNode (struct cw_status *, CalImage FAR *);
void copyStatPic (struct cw_status *, CalImage FAR *, CalRect);
CalImage FAR *scaleImage (struct cw_status *, CalImage FAR *, int, int);
CalImage createImage (struct cw_status *, char FAR *URL);
CalImage FAR *getImage (struct cw_status *, char FAR *);
void gifSendData (struct cw_status *, AweStream *, unsigned char, long *, CalImage *, int);
void freeImage (struct cw_status *, struct imgnode FAR *);
void ReadImage (struct cw_status *, AweStream *, int, int, int, int, long *, CalImage *);

void ReadGIF (struct cw_status *, AweStream *, long *, CalImage FAR *);
int LWZReadByte (struct cw_status *, AweStream *fd, int flag, int input_code_size);
void readJPEG (struct cw_status *, AweStream *, CalImage FAR *);
CalImage FAR *blankImage (struct cw_status *, int, int, int);
struct imgnode FAR *initDefImg (struct cw_status *);
void clearImage (struct cw_status *, Pixmap, int, int);
int colsInCMap (struct cw_status *);
void computeTxtWidth (struct cw_status *, CalText FAR *);
int calCharWidth (struct cw_status *, CalFont FAR *fontinfo, char FAR *c);

void initStipples (struct cw_status *);
void initRasters (struct cw_status *);
void initDashes (struct cw_status *);
void mainLoop (struct cw_status *);
void CalMapWait (struct cw_status *);


void setStatus(struct cw_status *, char FAR *);
void setURL (struct cw_status *, char FAR *);


/* guilib prototypes */
void goto_url(struct cw_status *, char FAR *url);
void reload(struct cw_status *);
void back(struct cw_status *);
void print_window(struct cw_status *);
char FAR *get_source(struct cw_status *);
void winsysCleanup(struct cw_status *);

#ifdef X11
void openMainWin (struct cw_status *, int FAR *argc, char FAR *argv[]);
Widget XtGetShell(Widget w);
Widget XtGetTopLevelShell(Widget w);
void HandleInput(struct cw_status *, XEvent FAR *event);
void BackCB(Widget widget, XtPointer client_data, XtPointer call_data);
void ReloadCB(Widget widget, XtPointer client_data, XtPointer call_data);
void DestroyShell(Widget widget, XtPointer client_data, XtPointer call_data);
void imgToServer (struct cw_status *, CalImage *imgptr, XImage *image, char picnotmask);
void drawInitial (struct cw_status *, Window);
#endif
void fakeExpose (struct cw_status *, CalRect rect);
#ifdef WIN32
#define colorOfRGB(RGB) (RGB)
#else
long colorOfRGB (long);
#endif

#endif /* SYSPROTO_H */


